/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.impl.bentobox;

import io.github.lijinhong11.protector.api.flag.CommonFlags;
import io.github.lijinhong11.protector.api.flag.IFlagState;
import io.github.lijinhong11.protector.api.protection.IProtectionModule;
import io.github.lijinhong11.protector.api.protection.ProtectionRangeInfo;
import io.github.lijinhong11.protector.impl.bentobox.BentoBoxIslandInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.objects.Island;

public class BentoBoxProtectionModule
implements IProtectionModule {
    private final BentoBox bentoBox = BentoBox.getInstance();

    @Override
    @NotNull
    public String getPluginName() {
        return "BentoBox";
    }

    @Override
    public List<? extends ProtectionRangeInfo> getProtectionRangeInfos(@NotNull OfflinePlayer player) {
        Collection islands = this.bentoBox.getIslands().getIslands();
        if (islands.isEmpty()) {
            return List.of();
        }
        for (Island island : islands) {
            if (!island.getMembers().containsKey(player.getUniqueId())) continue;
            return Collections.singletonList(new BentoBoxIslandInfo(island));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isInProtectionRange(@NotNull Location location) {
        return false;
    }

    @Override
    @Nullable
    public ProtectionRangeInfo getProtectionRangeInfo(@NotNull Location location) {
        Optional island = this.bentoBox.getIslands().getIslandAt(location);
        return island.map(BentoBoxIslandInfo::new).orElse(null);
    }

    @Override
    public boolean isSupportGlobalFlags() {
        return false;
    }

    @Override
    public IFlagState<?> getGlobalFlag(@NotNull String flag, @NotNull String world) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFlagState<?> getGlobalFlag(@NotNull CommonFlags flag, @NotNull String world) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGlobalFlag(@NotNull String world, @NotNull String flag, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGlobalFlag(@NotNull String world, @NotNull CommonFlags flag, Object value) {
        throw new UnsupportedOperationException();
    }
}

