/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.impl.dominion;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.flag.EnvFlag;
import cn.lunadeer.dominion.api.dtos.flag.Flag;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import io.github.lijinhong11.protector.api.convertions.FlagMap;
import io.github.lijinhong11.protector.api.flag.CommonFlags;
import io.github.lijinhong11.protector.api.flag.FlagState;
import io.github.lijinhong11.protector.api.flag.IFlagState;
import io.github.lijinhong11.protector.api.protection.ProtectionRangeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DominionRangeInfo
implements ProtectionRangeInfo {
    private final DominionDTO dominion;

    public DominionRangeInfo(DominionDTO dominion) {
        this.dominion = dominion;
    }

    @Override
    @NotNull
    public Map<String, IFlagState<?>> getFlags() {
        FlagMap flagMap = new FlagMap();
        this.dominion.getEnvironmentFlagValue().forEach((f, b) -> flagMap.put(f.getFlagName(), FlagState.fromBoolean(b)));
        this.dominion.getGuestPrivilegeFlagValue().forEach((f, b) -> flagMap.put(f.getFlagName(), FlagState.fromBoolean(b)));
        return Collections.unmodifiableMap(flagMap);
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull String flag) {
        return this.getFlagState(flag, null);
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull String flag, OfflinePlayer player) {
        Flag dominionFlag = Flags.getFlag((String)flag);
        if (dominionFlag == null) {
            return FlagState.UNSUPPORTED;
        }
        if (dominionFlag instanceof EnvFlag) {
            EnvFlag ef = (EnvFlag)dominionFlag;
            return FlagState.fromNullableBoolean(this.dominion.getEnvFlagValue(ef));
        }
        if (dominionFlag instanceof PriFlag) {
            PriFlag pf = (PriFlag)dominionFlag;
            if (player == null) {
                return FlagState.fromNullableBoolean(this.dominion.getGuestFlagValue(pf));
            }
            if (player.getUniqueId() == this.dominion.getOwner()) {
                return FlagState.fromNullableBoolean(this.dominion.getGuestFlagValue(pf));
            }
            Optional<MemberDTO> memberDTO = this.dominion.getMembers().stream().filter(m -> m.getPlayerUUID().equals(player.getUniqueId())).findFirst();
            if (memberDTO.isEmpty()) {
                return FlagState.fromNullableBoolean(this.dominion.getGuestFlagValue(pf));
            }
            return FlagState.fromNullableBoolean(memberDTO.get().getFlagValue(pf));
        }
        return FlagState.UNSUPPORTED;
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull CommonFlags flag) {
        return this.getFlagState(flag.getForDominion());
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull CommonFlags flag, OfflinePlayer player) {
        return this.getFlagState(flag.getForDominion(), player);
    }

    @Override
    public List<OfflinePlayer> getAdmins() {
        ArrayList<OfflinePlayer> admins = new ArrayList<OfflinePlayer>();
        for (MemberDTO member : this.dominion.getMembers()) {
            if (!member.getFlagValue(Flags.ADMIN).booleanValue()) continue;
            admins.add(Bukkit.getOfflinePlayer((UUID)member.getPlayerUUID()));
        }
        return admins;
    }

    @Override
    public List<OfflinePlayer> getMembers() {
        ArrayList<OfflinePlayer> members = new ArrayList<OfflinePlayer>();
        for (MemberDTO member : this.dominion.getMembers()) {
            if (member.getFlagValue(Flags.ADMIN).booleanValue()) continue;
            members.add(Bukkit.getOfflinePlayer((UUID)member.getPlayerUUID()));
        }
        return members;
    }

    @Override
    @Nullable
    public OfflinePlayer getOwner() {
        return Bukkit.getOfflinePlayer((UUID)this.dominion.getOwner());
    }
}

