/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.impl.huskclaims;

import io.github.lijinhong11.protector.api.flag.CommonFlags;
import io.github.lijinhong11.protector.api.flag.CustomFlag;
import io.github.lijinhong11.protector.api.flag.FlagRegisterable;
import io.github.lijinhong11.protector.api.flag.FlagState;
import io.github.lijinhong11.protector.api.flag.IFlagState;
import io.github.lijinhong11.protector.api.protection.IProtectionModule;
import io.github.lijinhong11.protector.api.protection.ProtectionRangeInfo;
import io.github.lijinhong11.protector.impl.huskclaims.HuskClaimsClaimInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.william278.huskclaims.api.BukkitHuskClaimsAPI;
import net.william278.huskclaims.claim.Claim;
import net.william278.huskclaims.claim.ClaimWorld;
import net.william278.huskclaims.libraries.cloplib.operation.OperationType;
import net.william278.huskclaims.libraries.cloplib.operation.OperationTypeRegistry;
import net.william278.huskclaims.position.Position;
import net.william278.huskclaims.position.World;
import net.william278.huskclaims.user.OnlineUser;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HuskClaimsProtectionModule
implements IProtectionModule,
FlagRegisterable {
    private static final BukkitHuskClaimsAPI api = BukkitHuskClaimsAPI.getInstance();

    @Override
    @NotNull
    public String getPluginName() {
        return "HuskClaims";
    }

    @Override
    public List<? extends ProtectionRangeInfo> getProtectionRangeInfos(@NotNull OfflinePlayer player) {
        Map claims = api.getUserClaims(OnlineUser.of((UUID)player.getUniqueId(), (String)player.getName()));
        ArrayList<HuskClaimsClaimInfo> list = new ArrayList<HuskClaimsClaimInfo>();
        for (List claims1 : claims.values()) {
            for (Claim claim : claims1) {
                list.add(new HuskClaimsClaimInfo(claim));
            }
        }
        return list;
    }

    @Override
    public boolean isInProtectionRange(@NotNull Location location) {
        return api.isWorldClaimable(HuskClaimsProtectionModule.wrapWorld(location.getWorld())) && api.isClaimAt(HuskClaimsProtectionModule.wrapLocation(location));
    }

    @Override
    @Nullable
    public ProtectionRangeInfo getProtectionRangeInfo(@NotNull Location location) {
        if (!api.isWorldClaimable(HuskClaimsProtectionModule.wrapWorld(location.getWorld()))) {
            return null;
        }
        Optional claim = api.getClaimAt(HuskClaimsProtectionModule.wrapLocation(location));
        return claim.map(HuskClaimsClaimInfo::new).orElse(null);
    }

    @Override
    public void registerFlag(CustomFlag flag) {
        OperationTypeRegistry reg = api.getOperationTypeRegistry();
        OperationType type = reg.createOperationType(Key.key((String)flag.namespace(), (String)flag.id()));
        reg.registerOperationType(type);
    }

    @Override
    public boolean isSupportGlobalFlags() {
        return true;
    }

    @Override
    public IFlagState<?> getGlobalFlag(@NotNull String flag, @NotNull String world) {
        Optional operationType = OperationType.get((String)flag);
        if (operationType.isEmpty()) {
            return FlagState.UNSUPPORTED;
        }
        Optional cw = api.getClaimWorld(HuskClaimsProtectionModule.wrapWorld(Bukkit.getWorld((String)world)));
        if (cw.isEmpty()) {
            return FlagState.WORLD_NOT_FOUND;
        }
        return FlagState.fromBoolean(((ClaimWorld)cw.get()).getWildernessFlags().contains(operationType.get()));
    }

    @Override
    public IFlagState<?> getGlobalFlag(@NotNull CommonFlags flag, @NotNull String world) {
        if (flag.getForHuskClaims() == null) {
            return FlagState.UNSUPPORTED;
        }
        return this.getGlobalFlag(flag.getForHuskClaims(), world);
    }

    @Override
    public void setGlobalFlag(@NotNull String world, @NotNull String flag, Object value) {
        Optional type = OperationType.get((String)flag);
        type.ifPresent(t -> {
            Optional cw = api.getClaimWorld(HuskClaimsProtectionModule.wrapWorld(Bukkit.getWorld((String)world)));
            cw.ifPresent(c -> {
                List wildernessFlags = api.getPlugin().getSettings().getClaims().getWildernessRules();
                if (wildernessFlags.contains(t)) {
                    boolean b = value.equals(true);
                    if (!b) {
                        wildernessFlags.remove(t);
                    }
                } else if (value.equals(true)) {
                    wildernessFlags.add(t);
                }
            });
        });
    }

    @Override
    public void setGlobalFlag(@NotNull String world, @NotNull CommonFlags flag, Object value) {
        if (flag.getForHuskClaims() == null) {
            return;
        }
        this.setGlobalFlag(world, flag.getForHuskClaims(), value);
    }

    static World wrapWorld(org.bukkit.World world) {
        return api.getWorld(world);
    }

    static Position wrapLocation(Location location) {
        return api.getPosition(location);
    }
}

