/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.impl.plotsquared;

import com.plotsquared.core.PlotAPI;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import io.github.lijinhong11.protector.api.flag.CommonFlags;
import io.github.lijinhong11.protector.api.flag.CustomFlag;
import io.github.lijinhong11.protector.api.flag.FlagRegisterable;
import io.github.lijinhong11.protector.api.flag.IFlagState;
import io.github.lijinhong11.protector.api.protection.IProtectionModule;
import io.github.lijinhong11.protector.api.protection.ProtectionRangeInfo;
import io.github.lijinhong11.protector.impl.plotsquared.PSCustomFlag;
import io.github.lijinhong11.protector.impl.plotsquared.PlotSquaredPlotInfo;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlotSquaredProtectionModule
implements IProtectionModule,
FlagRegisterable {
    private final PlotAPI plotAPI = new PlotAPI();

    @Override
    @NotNull
    public String getPluginName() {
        return "PlotSquared";
    }

    @Override
    public List<? extends ProtectionRangeInfo> getProtectionRangeInfos(@NotNull OfflinePlayer player) {
        return this.plotAPI.getPlayerPlots(this.getPlotPlayer(player)).stream().map(PlotSquaredPlotInfo::new).toList();
    }

    @Override
    public boolean isInProtectionRange(@NotNull org.bukkit.Location location) {
        Location loc = this.wrapLocation(location);
        return loc.isPlotArea() || loc.isUnownedPlotArea();
    }

    @Override
    @Nullable
    public ProtectionRangeInfo getProtectionRangeInfo(@NotNull org.bukkit.Location location) {
        Location loc = this.wrapLocation(location);
        if (loc.getPlot() == null) {
            return null;
        }
        return new PlotSquaredPlotInfo(loc.getPlot());
    }

    @Override
    public void registerFlag(CustomFlag flag) {
        GlobalFlagContainer.getInstance().addFlag((PlotFlag)new PSCustomFlag(flag));
    }

    @Override
    public boolean isSupportGlobalFlags() {
        return false;
    }

    @Override
    public IFlagState<?> getGlobalFlag(@NotNull String flag, @NotNull String world) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFlagState<?> getGlobalFlag(@NotNull CommonFlags flag, @NotNull String world) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGlobalFlag(@NotNull String world, @NotNull String flag, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGlobalFlag(@NotNull String world, @NotNull CommonFlags flag, Object value) {
        throw new UnsupportedOperationException();
    }

    private Location wrapLocation(org.bukkit.Location location) {
        return Location.at((String)location.getWorld().getName(), (int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ());
    }

    private PlotPlayer<?> getPlotPlayer(OfflinePlayer player) {
        return this.plotAPI.wrapPlayer(player.getUniqueId());
    }
}

