/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.impl.redprotect;

import br.net.fabiozumbi12.RedProtect.Bukkit.API.RedProtectAPI;
import br.net.fabiozumbi12.RedProtect.Bukkit.RedProtect;
import br.net.fabiozumbi12.RedProtect.Bukkit.Region;
import br.net.fabiozumbi12.RedProtect.Core.config.Category.GlobalFlagsCategory;
import io.github.lijinhong11.protector.api.flag.CommonFlags;
import io.github.lijinhong11.protector.api.flag.CustomFlag;
import io.github.lijinhong11.protector.api.flag.FlagRegisterable;
import io.github.lijinhong11.protector.api.flag.FlagState;
import io.github.lijinhong11.protector.api.flag.IFlagState;
import io.github.lijinhong11.protector.api.protection.IProtectionModule;
import io.github.lijinhong11.protector.api.protection.ProtectionRangeInfo;
import io.github.lijinhong11.protector.impl.redprotect.RedProtectRegionInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedProtectProtectionModule
implements IProtectionModule,
FlagRegisterable {
    private final RedProtectAPI api = RedProtect.get().getAPI();

    @Override
    @NotNull
    public String getPluginName() {
        return "RedProtect";
    }

    @Override
    public List<? extends ProtectionRangeInfo> getProtectionRangeInfos(@NotNull OfflinePlayer player) {
        ArrayList<RedProtectRegionInfo> protectionRangeInfos = new ArrayList<RedProtectRegionInfo>();
        for (Region region : this.api.getPlayerRegions(String.valueOf(player.getUniqueId()))) {
            protectionRangeInfos.add(new RedProtectRegionInfo(region));
        }
        return protectionRangeInfos;
    }

    @Override
    public boolean isInProtectionRange(@NotNull Location location) {
        return this.api.getRegion(location) != null;
    }

    @Override
    @Nullable
    public ProtectionRangeInfo getProtectionRangeInfo(@NotNull Location location) {
        Region region = this.api.getRegion(location);
        if (region == null) {
            return null;
        }
        return new RedProtectRegionInfo(region);
    }

    @Override
    public void registerFlag(CustomFlag flag) {
        RedProtect.get().getRegionManager().getAllRegions().forEach(r -> r.setFlag(null, flag.id(), (Object)flag.defaultValue()));
    }

    @Override
    public boolean isSupportGlobalFlags() {
        return true;
    }

    @Override
    public IFlagState<?> getGlobalFlag(@NotNull String flag, @NotNull String world) {
        Field[] field;
        GlobalFlagsCategory category = RedProtect.get().getConfigManager().globalFlagsRoot();
        GlobalFlagsCategory.WorldProperties properties = (GlobalFlagsCategory.WorldProperties)category.worlds.get(world);
        if (flag.equals(CommonFlags.PLACE.getForRedProtect()) || flag.equals(CommonFlags.BREAK.getForRedProtect()) || flag.equals(CommonFlags.BUILD.getForRedProtect())) {
            return FlagState.fromBoolean(properties.build);
        }
        for (Field f : field = GlobalFlagsCategory.WorldProperties.class.getDeclaredFields()) {
            if (!f.getName().equals(flag)) continue;
            try {
                Object value = f.get(properties);
                if (value instanceof Boolean) {
                    Boolean b = (Boolean)value;
                    return FlagState.fromNullableBoolean(b);
                }
                return FlagState.of(value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return FlagState.UNSUPPORTED;
    }

    @Override
    public IFlagState<?> getGlobalFlag(@NotNull CommonFlags flag, @NotNull String world) {
        if (flag.getForRedProtect() == null) {
            return FlagState.UNSUPPORTED;
        }
        return this.getGlobalFlag(flag.getForRedProtect(), world);
    }

    @Override
    public void setGlobalFlag(@NotNull String world, @NotNull String flag, Object value) {
        Field[] field;
        GlobalFlagsCategory category = RedProtect.get().getConfigManager().globalFlagsRoot();
        GlobalFlagsCategory.WorldProperties properties = (GlobalFlagsCategory.WorldProperties)category.worlds.get(world);
        for (Field f : field = GlobalFlagsCategory.WorldProperties.class.getDeclaredFields()) {
            if (!f.getName().equals(flag)) continue;
            try {
                if (!f.getType().isInstance(value)) {
                    throw new IllegalArgumentException("Value type mismatch");
                }
                f.set(properties, value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setGlobalFlag(@NotNull String world, @NotNull CommonFlags flag, Object value) {
        if (flag.getForRedProtect() == null) {
            return;
        }
        this.setGlobalFlag(world, flag.getForRedProtect(), value);
    }
}

