/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.impl.redprotect;

import br.net.fabiozumbi12.RedProtect.Bukkit.Region;
import io.github.lijinhong11.protector.api.convertions.FlagMap;
import io.github.lijinhong11.protector.api.flag.CommonFlags;
import io.github.lijinhong11.protector.api.flag.FlagState;
import io.github.lijinhong11.protector.api.flag.IFlagState;
import io.github.lijinhong11.protector.api.protection.ProtectionRangeInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedProtectRegionInfo
implements ProtectionRangeInfo {
    private final Region region;

    public RedProtectRegionInfo(Region region) {
        this.region = region;
    }

    @Override
    @NotNull
    public Map<String, IFlagState<?>> getFlags() {
        return Collections.unmodifiableMap(new FlagMap(this.region.getFlags(), o -> {
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                return FlagState.fromNullableBoolean(b);
            }
            return FlagState.of(o);
        }));
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull String flag) {
        return this.getFlagState(flag, null);
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull String flag, OfflinePlayer player) {
        return Objects.requireNonNullElse(this.getFlags().get(flag), FlagState.UNSUPPORTED);
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull CommonFlags flag) {
        return this.getFlagState(flag.getForRedProtect(), null);
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull CommonFlags flag, OfflinePlayer player) {
        return this.getFlagState(flag.getForRedProtect(), player);
    }

    @Override
    public List<OfflinePlayer> getAdmins() {
        return this.region.getAdmins().stream().map(r -> Bukkit.getOfflinePlayer((String)r.getUUID())).toList();
    }

    @Override
    public List<OfflinePlayer> getMembers() {
        return this.region.getMembers().stream().map(r -> Bukkit.getOfflinePlayer((String)r.getUUID())).toList();
    }

    @Override
    @Nullable
    public OfflinePlayer getOwner() {
        return this.region.getLeaders().stream().map(r -> Bukkit.getOfflinePlayer((String)r.getUUID())).findFirst().orElse(null);
    }
}

