/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.impl.residence;

import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import io.github.lijinhong11.protector.api.convertions.FlagMap;
import io.github.lijinhong11.protector.api.flag.CommonFlags;
import io.github.lijinhong11.protector.api.flag.FlagState;
import io.github.lijinhong11.protector.api.flag.IFlagState;
import io.github.lijinhong11.protector.api.protection.ProtectionRangeInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResidenceInfo
implements ProtectionRangeInfo {
    private final ClaimedResidence residence;
    private final ResidencePermissions permissions;

    public ResidenceInfo(ClaimedResidence residence) {
        this.residence = residence;
        this.permissions = residence.getPermissions();
    }

    @Override
    @NotNull
    public Map<String, IFlagState<?>> getFlags() {
        return Collections.unmodifiableMap(new FlagMap(this.permissions.getFlags(), FlagState::fromNullableBoolean));
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull String flag) {
        return FlagState.fromNullableBoolean((Boolean)this.permissions.getFlags().get(flag));
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull String flag, OfflinePlayer player) {
        return FlagState.fromNullableBoolean((Boolean)this.permissions.getPlayerFlags(player.getName()).get(flag));
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull CommonFlags flag) {
        return this.getFlagState(flag.getForResidence());
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull CommonFlags flag, OfflinePlayer player) {
        return this.getFlagState(flag.getForResidence(), player);
    }

    @Override
    public List<OfflinePlayer> getAdmins() {
        return this.getMembers().stream().filter(r -> this.permissions.playerHas(r.getName(), Flags.admin, false)).toList();
    }

    @Override
    public List<OfflinePlayer> getMembers() {
        return this.residence.getTrustedPlayers().stream().map(r -> Bukkit.getOfflinePlayer((UUID)r.getUniqueId())).toList();
    }

    @Override
    @Nullable
    public OfflinePlayer getOwner() {
        return Bukkit.getOfflinePlayer((String)this.residence.getOwner());
    }
}

