/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.impl.residence;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.ResidenceApi;
import com.bekvon.bukkit.residence.api.ResidenceInterface;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import io.github.lijinhong11.protector.api.flag.CommonFlags;
import io.github.lijinhong11.protector.api.flag.CustomFlag;
import io.github.lijinhong11.protector.api.flag.FlagRegisterable;
import io.github.lijinhong11.protector.api.flag.FlagState;
import io.github.lijinhong11.protector.api.flag.IFlagState;
import io.github.lijinhong11.protector.api.protection.IProtectionModule;
import io.github.lijinhong11.protector.api.protection.ProtectionRangeInfo;
import io.github.lijinhong11.protector.impl.residence.ResidenceInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResidenceProtectionModule
implements IProtectionModule,
FlagRegisterable {
    @Override
    @NotNull
    public String getPluginName() {
        return "Residence";
    }

    @Override
    public List<? extends ProtectionRangeInfo> getProtectionRangeInfos(@NotNull OfflinePlayer player) {
        ArrayList list = ResidenceApi.getPlayerManager().getResidenceList(player.getName(), true);
        return list.stream().map(arg_0 -> ((ResidenceInterface)ResidenceApi.getResidenceManager()).getByName(arg_0)).map(ResidenceInfo::new).toList();
    }

    @Override
    public boolean isInProtectionRange(@NotNull Location location) {
        return ResidenceApi.getResidenceManager().getByLoc(location) != null;
    }

    @Override
    @Nullable
    public ProtectionRangeInfo getProtectionRangeInfo(@NotNull Location location) {
        ClaimedResidence res = ResidenceApi.getResidenceManager().getByLoc(location);
        if (res == null) {
            return null;
        }
        return new ResidenceInfo(res);
    }

    @Override
    public void registerFlag(CustomFlag flag) {
        FlagPermissions.addFlag((String)flag.id());
        Residence.getInstance().getPermissionManager().getAllFlags().setFlag(flag.id(), flag.defaultValue() ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
    }

    @Override
    public boolean isSupportGlobalFlags() {
        return true;
    }

    @Override
    public IFlagState<?> getGlobalFlag(@NotNull String flag, @NotNull String world) {
        Map flags = Residence.getInstance().wmanager.getPerms(world).getFlags();
        return FlagState.fromNullableBoolean((Boolean)flags.get(flag));
    }

    @Override
    public IFlagState<?> getGlobalFlag(@NotNull CommonFlags flag, @NotNull String world) {
        return this.getGlobalFlag(flag.getForResidence(), world);
    }

    @Override
    public void setGlobalFlag(@NotNull String world, @NotNull String flag, Object value) {
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("value must be a boolean in Residence");
        }
        Boolean b = (Boolean)value;
        Residence.getInstance().wmanager.getPerms(world).getFlags().put(flag, b);
    }

    @Override
    public void setGlobalFlag(@NotNull String world, @NotNull CommonFlags flag, Object value) {
        this.setGlobalFlag(world, flag.getForResidence(), value);
    }
}

