/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.impl.worldguard;

import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import io.github.lijinhong11.protector.api.convertions.FlagMap;
import io.github.lijinhong11.protector.api.flag.CommonFlags;
import io.github.lijinhong11.protector.api.flag.FlagState;
import io.github.lijinhong11.protector.api.flag.IFlagState;
import io.github.lijinhong11.protector.api.protection.ProtectionRangeInfo;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldGuardProtectedRegionInfo
implements ProtectionRangeInfo {
    private final ProtectedRegion protectedRegion;

    public WorldGuardProtectedRegionInfo(ProtectedRegion protectedRegion) {
        this.protectedRegion = protectedRegion;
    }

    @Override
    @NotNull
    public Map<String, IFlagState<?>> getFlags() {
        FlagMap flagMap = new FlagMap();
        for (Map.Entry entry : this.protectedRegion.getFlags().entrySet()) {
            Flag flag = (Flag)entry.getKey();
            Object object = flag.getDefault();
            if (object instanceof Boolean) {
                Boolean b = (Boolean)object;
                flagMap.put(flag.getName(), FlagState.fromNullableBoolean(b));
                continue;
            }
            flagMap.put(((Flag)entry.getKey()).getName(), FlagState.of(entry.getValue()));
        }
        return flagMap;
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull String flag) {
        return this.getFlagState(flag, null);
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull String flag, OfflinePlayer player) {
        return this.getFlags().get(flag);
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull CommonFlags flag) {
        return this.getFlagState(flag, null);
    }

    @Override
    public IFlagState<?> getFlagState(@NotNull CommonFlags flag, OfflinePlayer player) {
        if (flag.getForWorldGuard() == null) {
            return FlagState.UNSUPPORTED;
        }
        return this.getFlagState(flag.getForWorldGuard());
    }

    @Override
    public List<OfflinePlayer> getAdmins() {
        return this.protectedRegion.getOwners().getPlayers().stream().map(Bukkit::getOfflinePlayer).toList();
    }

    @Override
    public List<OfflinePlayer> getMembers() {
        return this.protectedRegion.getMembers().getPlayers().stream().map(Bukkit::getOfflinePlayer).toList();
    }

    @Override
    @Nullable
    public OfflinePlayer getOwner() {
        return this.getAdmins().get(0);
    }
}

