/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.protector.impl.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitWorldConfiguration;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import io.github.lijinhong11.protector.api.flag.CommonFlags;
import io.github.lijinhong11.protector.api.flag.CustomFlag;
import io.github.lijinhong11.protector.api.flag.FlagRegisterable;
import io.github.lijinhong11.protector.api.flag.FlagState;
import io.github.lijinhong11.protector.api.flag.IFlagState;
import io.github.lijinhong11.protector.api.protection.IProtectionModule;
import io.github.lijinhong11.protector.api.protection.ProtectionRangeInfo;
import io.github.lijinhong11.protector.impl.worldguard.WorldGuardProtectedRegionInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldGuardProtectionModule
implements IProtectionModule,
FlagRegisterable {
    private final RegionContainer api = WorldGuard.getInstance().getPlatform().getRegionContainer();
    private final ConfigurationManager globalFlags = WorldGuard.getInstance().getPlatform().getGlobalStateManager();

    @Override
    @NotNull
    public String getPluginName() {
        return "WorldGuard";
    }

    @Override
    public List<? extends ProtectionRangeInfo> getProtectionRangeInfos(@NotNull OfflinePlayer player) {
        return new ArrayList();
    }

    @Override
    public boolean isInProtectionRange(@NotNull Location location) {
        return !this.api.createQuery().getApplicableRegions(this.toWELocation(location)).getRegions().isEmpty();
    }

    @Override
    @Nullable
    public ProtectionRangeInfo getProtectionRangeInfo(@NotNull Location location) {
        ProtectedRegion[] regions = (ProtectedRegion[])this.api.createQuery().getApplicableRegions(this.toWELocation(location)).getRegions().toArray(ProtectedRegion[]::new);
        if (regions.length > 0) {
            return new WorldGuardProtectedRegionInfo(regions[0]);
        }
        return null;
    }

    @Override
    public void registerFlag(CustomFlag flag) {
        WorldGuard.getInstance().getFlagRegistry().register((Flag)new StateFlag(flag.id(), flag.defaultValue()));
    }

    @Override
    public boolean isSupportGlobalFlags() {
        return true;
    }

    @Override
    public IFlagState<?> getGlobalFlag(@NotNull String flag, @NotNull String world) {
        World w = Bukkit.getWorld((String)world);
        if (w == null) {
            return FlagState.UNSUPPORTED;
        }
        BukkitWorldConfiguration bwc = (BukkitWorldConfiguration)this.globalFlags.get(BukkitAdapter.adapt((World)w));
        Object o = bwc.getProperty(flag);
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return FlagState.fromNullableBoolean(b);
        }
        return FlagState.of(o);
    }

    @Override
    public IFlagState<?> getGlobalFlag(@NotNull CommonFlags flag, @NotNull String world) {
        if (flag.getForWorldGuard() == null) {
            return FlagState.UNSUPPORTED;
        }
        return this.getGlobalFlag(flag.getForWorldGuard(), world);
    }

    @Override
    public void setGlobalFlag(@NotNull String world, @NotNull String flag, Object value) {
        World w = Bukkit.getWorld((String)world);
        if (w == null) {
            return;
        }
        Location loc = new Location(w, 0.0, 0.0, 0.0);
        Set regions = this.api.createQuery().getApplicableRegions(this.toWELocation(loc)).getRegions();
        regions.stream().filter(region -> Objects.equals(region.getId(), "__global__")).findFirst().ifPresent(region -> {
            Flag flag1 = WorldGuard.getInstance().getFlagRegistry().get(flag);
            if (flag1 == null) {
                return;
            }
            region.getFlags().put(flag1, flag1.unmarshal(value));
        });
    }

    @Override
    public void setGlobalFlag(@NotNull String world, @NotNull CommonFlags flag, Object value) {
        if (flag.getForWorldGuard() == null) {
            return;
        }
        this.setGlobalFlag(world, flag.getForWorldGuard(), value);
    }

    private com.sk89q.worldedit.util.Location toWELocation(Location location) {
        return BukkitAdapter.adapt((Location)location);
    }
}

