/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamictooltips.config;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public class DynamicTooltipsConfig {
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    private static final Pattern HEX_COLOR_PATTERN;

    static {
        HEX_COLOR_PATTERN = Pattern.compile("^#([a-fA-F0-9]{6})$");
        ModConfigSpec.Builder clientBuilder = new ModConfigSpec.Builder();
        CLIENT = new Client(clientBuilder);
        CLIENT_SPEC = clientBuilder.build();
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue appendBlockInteractionRangeTooltip;
        public final ModConfigSpec.ConfigValue<List<? extends String>> blockInteractionRangeItemTags;
        public final ModConfigSpec.BooleanValue appendEntityInteractionRangeTooltip;
        public final ModConfigSpec.ConfigValue<List<? extends String>> entityInteractionRangeItemTags;
        public final ModConfigSpec.BooleanValue showUsabilityHint;
        public final ModConfigSpec.BooleanValue collapseEnchantmentTooltipsOnGear;
        public final ModConfigSpec.ConfigValue<String> enchantmentDescriptionColor;
        public final ModConfigSpec.ConfigValue<String> superLeveledEnchantmentColor;
        public final ModConfigSpec.BooleanValue colorEnchantmentNames;
        public final ModConfigSpec.ConfigValue<String> enchantmentNameColor;
        public final ModConfigSpec.ConfigValue<List<? extends String>> attributeColorOverrides;

        Client(ModConfigSpec.Builder builder) {
            this.appendBlockInteractionRangeTooltip = builder.comment("Append Block Interaction Range attribute line to relevant tooltips (pickaxes, shovels, etc.)").define("appendBlockInteractionRangeTooltip", true);
            this.blockInteractionRangeItemTags = builder.comment(new String[]{"Items or tags that should display Block Interaction Range tooltips.", "Format: \"namespace:path\" for item IDs, or \"#namespace:path\" for tags.", "Default includes common mining tools (pickaxes, axes, shovels, hoes, shears).", "Examples:", "  \"minecraft:diamond_pickaxe\" - specific item", "  \"#minecraft:enchantable/mining\" - all items in tag"}).defineListAllowEmpty("blockInteractionRangeItemTags", (List)Lists.newArrayList((Object[])new String[]{"#minecraft:enchantable/mining"}), Client::validateItemOrTag);
            this.appendEntityInteractionRangeTooltip = builder.comment("Append Entity Interaction Range attribute line to relevant tooltips (swords, etc.)").define("appendEntityInteractionRangeTooltip", true);
            this.entityInteractionRangeItemTags = builder.comment(new String[]{"Items or tags that should display Entity Interaction Range tooltips.", "Format: \"namespace:path\" for item IDs, or \"#namespace:path\" for tags.", "Default includes weapon-related enchantable tags.", "Examples:", "  \"minecraft:diamond_sword\" - specific item", "  \"#minecraft:enchantable/weapon\" - all items in tag"}).defineListAllowEmpty("entityInteractionRangeItemTags", (List)Lists.newArrayList((Object[])new String[]{"#minecraft:enchantable/weapon", "#minecraft:enchantable/trident", "#minecraft:enchantable/fire_aspect", "#minecraft:enchantable/sharp_weapon"}), Client::validateItemOrTag);
            this.showUsabilityHint = builder.comment("Show the 'Hold [Shift] to expand...' hint in tooltips that have merged attributes or collapsed enchantments.").define("showUsabilityHint", false);
            this.collapseEnchantmentTooltipsOnGear = builder.comment("Collapse enchantment descriptions on gear, requiring Shift to be held to view them. \n\nEnchanted Books always show descriptions.").define("collapseEnchantmentTooltipsOnGear", true);
            this.colorEnchantmentNames = builder.comment("Enable custom coloring of enchantments in tooltips.").define("colorEnchantmentNames", true);
            this.enchantmentNameColor = builder.comment("Hex color code (#RRGGBB) for regular enchantment names (if colorEnchantmentNames is true). Curses are always red.").define("enchantmentNameColor", (Object)"#AAAAAA", Client::validateHexColor);
            this.enchantmentDescriptionColor = builder.comment("Hex color code (#RRGGBB) for enchantment description text.").define("enchantmentDescriptionColor", (Object)"#808080", Client::validateHexColor);
            this.superLeveledEnchantmentColor = builder.comment("Hex color code (#RRGGBB) for enchantments above their max level (excluding curses) if colorEnchantmentNames is true.").define("superLeveledEnchantmentColor", (Object)"#FF55FF", Client::validateHexColor);
            this.attributeColorOverrides = builder.comment(new String[]{"Define custom color rules for specific attributes in tooltips.", "Format: \"attribute_id:LOGIC[:#HEXCOLOR]\"", "  attribute_id: The Identifier of the attribute (e.g., minecraft:generic.movement_speed).", "  LOGIC: How to color the modifier value. Options: INVERTED, FIXED.", "    INVERTED: Use the opposite of the attribute's default sentiment coloring (e.g., positive value = red).", "    FIXED: Always use the specified hex color, regardless of value.", "  :#HEXCOLOR: Required only if LOGIC is FIXED. The hex color code (e.g., #RRGGBB).", "  (If no rule is specified for an attribute, vanilla default coloring is used)."}).defineListAllowEmpty("attributeColorOverrides", (List)Lists.newArrayList((Object[])new String[]{"additionalentityattributes:generic.hitbox_height:FIXED:#808080", "additionalentityattributes:generic.hitbox_width:FIXED:#808080", "additionalentityattributes:generic.model_height:FIXED:#808080", "additionalentityattributes:generic.model_width:FIXED:#808080", "additionalentityattributes:generic.height:FIXED:#808080", "additionalentityattributes:generic.width:FIXED:#808080", "additionalentityattributes:generic.model_scale:FIXED:#808080", "additionalentityattributes:generic.mob_detection_range:INVERTED", "ranged_weapon:pull_time:INVERTED"}), Client::validateAttributeColorRule);
        }

        private static boolean validateHexColor(Object obj) {
            if (!(obj instanceof String)) {
                return false;
            }
            String str = (String)obj;
            return HEX_COLOR_PATTERN.matcher(str).matches();
        }

        private static boolean validateIdentifier(Object obj) {
            if (!(obj instanceof String)) {
                return false;
            }
            String str = (String)obj;
            return class_2960.method_12829((String)str) != null;
        }

        private static boolean validateItemOrTag(Object obj) {
            if (!(obj instanceof String)) {
                return false;
            }
            String str = (String)obj;
            String toValidate = str.startsWith("#") ? str.substring(1) : str;
            return class_2960.method_12829((String)toValidate) != null;
        }

        public static boolean matchesItemOrTag(class_1799 stack, String entry) {
            if (entry.startsWith("#")) {
                class_2960 tagId = class_2960.method_12829((String)entry.substring(1));
                if (tagId != null) {
                    class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId);
                    return stack.method_31573(tag);
                }
            } else {
                Optional holderOptional;
                class_2960 itemId = class_2960.method_12829((String)entry);
                if (itemId != null && (holderOptional = class_7923.field_41178.method_10223(itemId)).isPresent()) {
                    return stack.method_41406((class_6880)holderOptional.get());
                }
            }
            return false;
        }

        private static boolean validateAttributeColorRule(Object obj) {
            ColorLogic parsedLogic;
            if (!(obj instanceof String)) {
                return false;
            }
            String rule = (String)obj;
            String[] parts = rule.split(":");
            if (parts.length < 3 || parts.length > 4) {
                return false;
            }
            String potentialId = parts[0] + ":" + parts[1];
            if (class_2960.method_12829((String)potentialId) == null) {
                return false;
            }
            String logicStr = parts[2].toUpperCase();
            try {
                if (logicStr.equals("DEFAULT")) {
                    return false;
                }
                parsedLogic = ColorLogic.valueOf(logicStr);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            if (parsedLogic == ColorLogic.FIXED) {
                return parts.length == 4 && Client.validateHexColor(parts[3]);
            }
            return parts.length == 3;
        }

        @Nullable
        public static AttributeColorRule parseRuleString(String rule) {
            ColorLogic parsedLogic;
            String[] parts = rule.split(":");
            if (parts.length < 3 || parts.length > 4) {
                return null;
            }
            class_2960 attributeId = class_2960.method_12829((String)(parts[0] + ":" + parts[1]));
            if (attributeId == null) {
                return null;
            }
            String logicStr = parts[2].toUpperCase();
            try {
                if (logicStr.equals("DEFAULT")) {
                    return null;
                }
                parsedLogic = ColorLogic.valueOf(logicStr);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            String hexColor = null;
            if (parsedLogic == ColorLogic.FIXED) {
                if (parts.length != 4) {
                    return null;
                }
                hexColor = parts[3];
                if (!Client.validateHexColor(hexColor)) {
                    return null;
                }
            } else if (parts.length != 3) {
                return null;
            }
            return new AttributeColorRule(attributeId, parsedLogic, null, hexColor);
        }

        public record AttributeColorRule(class_2960 attributeId, ColorLogic logic, @Nullable class_124 fixedColor, @Nullable String hexColor) {
        }
    }

    public static enum ColorLogic {
        INVERTED,
        FIXED;

    }
}

