/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamictooltips.handlers;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import dev.muon.dynamictooltips.DynamicTooltips;
import dev.muon.dynamictooltips.Keybindings;
import dev.muon.dynamictooltips.config.DynamicTooltipsConfig;
import dev.muon.dynamictooltips.handlers.BlockRangeTooltipHandler;
import dev.muon.dynamictooltips.handlers.EntityRangeTooltipHandler;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AttributeTooltipHandler {
    private static final Logger LOGGER = DynamicTooltips.LOGGER;
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ROOT));
    private static final class_2960 FAKE_MERGED_ID = class_2960.method_60655((String)"dynamictooltips", (String)"fake_merged_modifier");
    static final class_124 BASE_COLOR = class_124.field_1077;
    public static final int MERGE_BASE_MODIFIER_COLOR = 16758784;
    public static final int MERGED_MODIFIER_COLOR = 7699710;
    private static Map<class_2960, DynamicTooltipsConfig.Client.AttributeColorRule> parsedAttributeColorRules = null;
    public static final Comparator<class_1322> ATTRIBUTE_MODIFIER_COMPARATOR = Comparator.comparing(class_1322::comp_2450).thenComparing(a -> -Math.abs(a.comp_2449())).thenComparing(class_1322::comp_2447);
    private static final Set<class_2960> BASE_ATTRIBUTE_IDS = (Set)class_156.method_654(new HashSet(), set -> {
        set.add(class_7923.field_41190.method_10221((Object)((class_1320)class_5134.field_23721.comp_349())));
        set.add(class_7923.field_41190.method_10221((Object)((class_1320)class_5134.field_23723.comp_349())));
        set.add(class_7923.field_41190.method_10221((Object)((class_1320)class_5134.field_47759.comp_349())));
        set.add(class_2960.method_60655((String)"ranged_weapon", (String)"damage"));
        set.add(class_2960.method_60655((String)"ranged_weapon", (String)"pull_time"));
        set.remove(null);
    });
    private static final Map<class_2960, class_2960> BASE_MODIFIER_IDS = (Map)class_156.method_654(new HashMap(), map -> {
        map.put(class_7923.field_41190.method_10221((Object)((class_1320)class_5134.field_23721.comp_349())), class_1792.field_8006);
        map.put(class_7923.field_41190.method_10221((Object)((class_1320)class_5134.field_23723.comp_349())), class_1792.field_8001);
        map.put(class_2960.method_60655((String)"ranged_weapon", (String)"damage"), class_2960.method_60655((String)"ranged_weapon", (String)"base_damage"));
        map.put(class_2960.method_60655((String)"ranged_weapon", (String)"pull_time"), class_2960.method_60655((String)"ranged_weapon", (String)"base_pull_time"));
        map.remove(null);
    });
    private static final List<class_9274> SLOT_PRIORITY_ORDER = List.of(class_9274.field_49223, class_9274.field_49222, class_9274.field_49221, class_9274.field_49220, class_9274.field_49217, class_9274.field_49219, class_9274.field_49224, class_9274.field_50127);

    private static Map<class_2960, DynamicTooltipsConfig.Client.AttributeColorRule> getParsedAttributeColorRules() {
        if (parsedAttributeColorRules == null) {
            parsedAttributeColorRules = new HashMap<class_2960, DynamicTooltipsConfig.Client.AttributeColorRule>();
            List ruleStrings = (List)DynamicTooltipsConfig.CLIENT.attributeColorOverrides.get();
            for (String ruleStr : ruleStrings) {
                DynamicTooltipsConfig.Client.AttributeColorRule parsedRule = DynamicTooltipsConfig.Client.parseRuleString(ruleStr);
                if (parsedRule != null) {
                    parsedAttributeColorRules.put(parsedRule.attributeId(), parsedRule);
                    continue;
                }
                LOGGER.warn("Failed to parse attribute color rule from config: {}", (Object)ruleStr);
            }
        }
        return parsedAttributeColorRules;
    }

    @Nullable
    private static DynamicTooltipsConfig.Client.AttributeColorRule getAttributeColorRule(class_1320 attribute) {
        class_2960 attrId = class_7923.field_41190.method_10221((Object)attribute);
        if (attrId == null) {
            return null;
        }
        return AttributeTooltipHandler.getParsedAttributeColorRules().get(attrId);
    }

    private static Set<String> getModifierIdKeys(Multimap<class_6880<class_1320>, class_1322> map) {
        HashSet<String> keys = new HashSet<String>();
        map.forEach((attrHolder, mod) -> {
            class_2960 attrId = class_7923.field_41190.method_10221((Object)((class_1320)attrHolder.comp_349()));
            if (attrId != null) {
                keys.add(String.valueOf(attrId) + ":" + String.valueOf(mod.comp_2447()));
            }
        });
        return keys;
    }

    private static boolean containsExclusiveModifiers(Multimap<class_6880<class_1320>, class_1322> source, Multimap<class_6880<class_1320>, class_1322> target) {
        Set<String> sourceKeys = AttributeTooltipHandler.getModifierIdKeys(source);
        Set<String> targetKeys = AttributeTooltipHandler.getModifierIdKeys(target);
        return !targetKeys.containsAll(sourceKeys);
    }

    public static ProcessingResult processTooltip(class_1799 stack, List<class_2561> tooltip, @Nullable class_1657 player) {
        List<AttributeSection> sections = AttributeTooltipHandler.findAttributeSections(tooltip);
        if (sections.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("No attribute sections found in tooltip for item: {}", (Object)stack.method_7909());
            LOGGER.debug("Tooltip contents:");
            for (int i = 0; i < tooltip.size(); ++i) {
                LOGGER.debug("  [{}]: '{}'", (Object)i, (Object)tooltip.get(i).getString());
            }
        }
        if (sections.isEmpty()) {
            return ProcessingResult.NO_CHANGE;
        }
        class_9274 initialPrimaryGroup = AttributeTooltipHandler.findPrimarySlotGroup(sections);
        if (initialPrimaryGroup == null) {
            return ProcessingResult.NO_CHANGE;
        }
        Multimap<class_6880<class_1320>, class_1322> combinedModifiers = AttributeTooltipHandler.buildCombinedModifiers(stack, initialPrimaryGroup);
        if (combinedModifiers.isEmpty()) {
            return ProcessingResult.NO_CHANGE;
        }
        class_9274 finalGroup = AttributeTooltipHandler.determineFinalPrimaryGroup(stack, initialPrimaryGroup);
        boolean needsShiftPrompt = AttributeTooltipHandler.rebuildTooltipWithMergedAttributes(stack, tooltip, sections, combinedModifiers, finalGroup, player);
        return new ProcessingResult(true, AttributeTooltipHandler.getHeaderForSlotGroup(finalGroup), needsShiftPrompt);
    }

    @Nullable
    private static class_9274 findPrimarySlotGroup(List<AttributeSection> sections) {
        for (class_9274 potentialPrimary : SLOT_PRIORITY_ORDER) {
            for (AttributeSection section : sections) {
                if (section.slot != potentialPrimary) continue;
                return potentialPrimary;
            }
        }
        return null;
    }

    private static class_9274 determineFinalPrimaryGroup(class_1799 stack, class_9274 initialGroup) {
        Set<String> offKeys;
        boolean offhandHasExclusives;
        if (initialGroup != class_9274.field_49219) {
            return initialGroup;
        }
        Multimap<class_6880<class_1320>, class_1322> handMods = AttributeTooltipHandler.getSortedModifiers(stack, class_9274.field_49219);
        Multimap<class_6880<class_1320>, class_1322> mainhandMods = AttributeTooltipHandler.getSortedModifiers(stack, class_9274.field_49217);
        Multimap<class_6880<class_1320>, class_1322> offhandMods = AttributeTooltipHandler.getSortedModifiers(stack, class_9274.field_49218);
        boolean mainhandHasExclusives = !mainhandMods.isEmpty() && AttributeTooltipHandler.containsExclusiveModifiers(mainhandMods, handMods);
        boolean bl = offhandHasExclusives = !offhandMods.isEmpty() && AttributeTooltipHandler.containsExclusiveModifiers(offhandMods, handMods);
        if (mainhandHasExclusives) {
            return class_9274.field_49217;
        }
        if (offhandHasExclusives) {
            return class_9274.field_49218;
        }
        Set<String> mainKeys = AttributeTooltipHandler.getModifierIdKeys(mainhandMods);
        if (!mainKeys.equals(offKeys = AttributeTooltipHandler.getModifierIdKeys(offhandMods))) {
            if (!mainhandMods.isEmpty()) {
                return class_9274.field_49217;
            }
            if (!offhandMods.isEmpty()) {
                return class_9274.field_49218;
            }
        }
        return class_9274.field_49219;
    }

    private static Multimap<class_6880<class_1320>, class_1322> buildCombinedModifiers(class_1799 stack, class_9274 primaryGroup) {
        LinkedListMultimap combined = LinkedListMultimap.create();
        if (primaryGroup == class_9274.field_49219) {
            combined.putAll(AttributeTooltipHandler.getSortedModifiers(stack, class_9274.field_49219));
            AttributeTooltipHandler.addNonDuplicateModifiers((Multimap<class_6880<class_1320>, class_1322>)combined, AttributeTooltipHandler.getSortedModifiers(stack, class_9274.field_49217));
        } else if (primaryGroup == class_9274.field_49217) {
            combined.putAll(AttributeTooltipHandler.getSortedModifiers(stack, class_9274.field_49217));
            AttributeTooltipHandler.addNonDuplicateModifiers((Multimap<class_6880<class_1320>, class_1322>)combined, AttributeTooltipHandler.getSortedModifiers(stack, class_9274.field_49219));
        } else if (primaryGroup == class_9274.field_49218) {
            combined.putAll(AttributeTooltipHandler.getSortedModifiers(stack, class_9274.field_49218));
            AttributeTooltipHandler.addNonDuplicateModifiers((Multimap<class_6880<class_1320>, class_1322>)combined, AttributeTooltipHandler.getSortedModifiers(stack, class_9274.field_49219));
        } else {
            combined.putAll(AttributeTooltipHandler.getSortedModifiers(stack, primaryGroup));
        }
        if (AttributeTooltipHandler.isArmorSlot(primaryGroup)) {
            AttributeTooltipHandler.addNonDuplicateModifiers((Multimap<class_6880<class_1320>, class_1322>)combined, AttributeTooltipHandler.getSortedModifiers(stack, class_9274.field_49224));
        }
        return combined;
    }

    private static boolean isArmorSlot(class_9274 group) {
        return group == class_9274.field_49223 || group == class_9274.field_49222 || group == class_9274.field_49221 || group == class_9274.field_49220 || group == class_9274.field_50127;
    }

    private static boolean rebuildTooltipWithMergedAttributes(class_1799 stack, List<class_2561> tooltip, List<AttributeSection> sections, Multimap<class_6880<class_1320>, class_1322> combinedModifiers, class_9274 finalGroup, @Nullable class_1657 player) {
        ArrayList<AttributeSection> sortedSections = new ArrayList<AttributeSection>(sections);
        sortedSections.sort(Comparator.comparingInt(s -> s.startIndex));
        AttributeSection firstSection = (AttributeSection)sortedSections.get(0);
        AttributeSection lastSection = (AttributeSection)sortedSections.get(sortedSections.size() - 1);
        int firstAttributeIndex = firstSection.startIndex;
        int lastAttributeIndex = lastSection.startIndex + lastSection.lineCount;
        ArrayList<class_2561> newTooltip = new ArrayList<class_2561>();
        for (int i = 0; i < firstAttributeIndex; ++i) {
            newTooltip.add(tooltip.get(i));
        }
        class_2561 finalHeader = AttributeTooltipHandler.getHeaderForSlotGroup(finalGroup);
        newTooltip.add(finalHeader);
        TooltipApplyResult applyResult = AttributeTooltipHandler.applyTextFor(stack, newTooltip::add, combinedModifiers, player);
        for (int i = lastAttributeIndex + 1; i < tooltip.size(); ++i) {
            newTooltip.add(tooltip.get(i));
        }
        tooltip.clear();
        tooltip.addAll(newTooltip);
        return applyResult.needsShiftPrompt;
    }

    private static void addNonDuplicateModifiers(Multimap<class_6880<class_1320>, class_1322> target, Multimap<class_6880<class_1320>, class_1322> source) {
        HashSet existingIds = new HashSet();
        target.forEach((attrHolder, mod) -> {
            class_2960 attrId = class_7923.field_41190.method_10221((Object)((class_1320)attrHolder.comp_349()));
            if (attrId != null) {
                existingIds.add(String.valueOf(attrId) + ":" + String.valueOf(mod.comp_2447()));
            }
        });
        source.forEach((attrHolder, mod) -> {
            String key;
            class_2960 attrId = class_7923.field_41190.method_10221((Object)((class_1320)attrHolder.comp_349()));
            if (attrId != null && !existingIds.contains(key = String.valueOf(attrId) + ":" + String.valueOf(mod.comp_2447()))) {
                target.put(attrHolder, mod);
            }
        });
    }

    private static class_2561 getHeaderForSlotGroup(class_9274 group) {
        String key = "item.modifiers." + group.method_15434();
        return class_2561.method_43471((String)key).method_27692(class_124.field_1080);
    }

    private static Multimap<class_6880<class_1320>, class_1322> getSortedModifiers(class_1799 stack, class_9274 slotGroup) {
        LinkedListMultimap map = LinkedListMultimap.create();
        stack.method_60617(slotGroup, (arg_0, arg_1, arg_2) -> AttributeTooltipHandler.lambda$getSortedModifiers$7((Multimap)map, arg_0, arg_1, arg_2));
        return map;
    }

    private static TooltipApplyResult applyTextFor(class_1799 stack, Consumer<class_2561> tooltip, Multimap<class_6880<class_1320>, class_1322> modifierMap, @Nullable class_1657 player) {
        TooltipApplyResult result = new TooltipApplyResult();
        if (modifierMap.isEmpty()) {
            return result;
        }
        Reference2ReferenceLinkedOpenHashMap baseModifiers = new Reference2ReferenceLinkedOpenHashMap();
        LinkedListMultimap remainingModifiers = LinkedListMultimap.create();
        AttributeTooltipHandler.separateBaseModifiers(modifierMap, (Map<class_6880<class_1320>, BaseModifier>)baseModifiers, (Multimap<class_6880<class_1320>, class_1322>)remainingModifiers);
        AttributeTooltipHandler.processBaseModifiers(stack, tooltip, player, (Map<class_6880<class_1320>, BaseModifier>)baseModifiers, result);
        AttributeTooltipHandler.processRemainingModifiers(stack, tooltip, player, modifierMap, (Multimap<class_6880<class_1320>, class_1322>)remainingModifiers, baseModifiers.keySet(), result);
        return result;
    }

    private static void separateBaseModifiers(Multimap<class_6880<class_1320>, class_1322> modifierMap, Map<class_6880<class_1320>, BaseModifier> baseModifiersOutput, Multimap<class_6880<class_1320>, class_1322> remainingModifiersOutput) {
        class_1322 modifier;
        class_6880 attr;
        Map.Entry entry;
        remainingModifiersOutput.putAll(modifierMap);
        Iterator it = remainingModifiersOutput.entries().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            attr = (class_6880)entry.getKey();
            modifier = (class_1322)entry.getValue();
            if (attr == null || modifier == null || !AttributeTooltipHandler.isBaseModifier((class_1320)attr.comp_349(), modifier)) continue;
            baseModifiersOutput.put((class_6880<class_1320>)attr, new BaseModifier(modifier, new ArrayList<class_1322>()));
            it.remove();
        }
        it = remainingModifiersOutput.entries().iterator();
        while (it.hasNext()) {
            BaseModifier base;
            entry = (Map.Entry)it.next();
            attr = (class_6880)entry.getKey();
            modifier = (class_1322)entry.getValue();
            if (attr == null || modifier == null || (base = baseModifiersOutput.get(attr)) == null || !AttributeTooltipHandler.isBaseAttribute((class_1320)attr.comp_349())) continue;
            base.children.add(modifier);
            it.remove();
        }
    }

    private static void processBaseModifiers(class_1799 stack, Consumer<class_2561> tooltip, @Nullable class_1657 player, Map<class_6880<class_1320>, BaseModifier> baseModifiers, TooltipApplyResult result) {
        for (Map.Entry<class_6880<class_1320>, BaseModifier> entry : baseModifiers.entrySet()) {
            double rawBaseValue;
            class_6880<class_1320> attr = entry.getKey();
            BaseModifier baseModifier = entry.getValue();
            if (attr == null || baseModifier == null) continue;
            double entityBase = player == null ? 0.0 : player.method_45326(attr);
            double baseValueFromModifier = baseModifier.base.comp_2449();
            double finalValue = rawBaseValue = baseValueFromModifier + entityBase;
            baseModifier.children.sort(ATTRIBUTE_MODIFIER_COMPARATOR);
            for (class_1322 childModifier : baseModifier.children) {
                finalValue = AttributeTooltipHandler.applyModifier(finalValue, rawBaseValue, childModifier);
            }
            boolean isMerged = !baseModifier.children.isEmpty();
            result.needsShiftPrompt |= isMerged;
            class_5250 text = AttributeTooltipHandler.createBaseComponent((class_1320)attr.comp_349(), finalValue, entityBase, isMerged);
            class_124 color = isMerged ? null : BASE_COLOR;
            Integer intColor = isMerged ? Integer.valueOf(16758784) : null;
            tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)text.method_27694(style -> {
                if (intColor != null) {
                    return style.method_36139(intColor.intValue());
                }
                if (color != null) {
                    return style.method_27706(color);
                }
                return style;
            })));
            if (Keybindings.isDetailedView() && isMerged) {
                text = AttributeTooltipHandler.createBaseComponent((class_1320)attr.comp_349(), rawBaseValue, entityBase, false);
                tooltip.accept((class_2561)AttributeTooltipHandler.listHeader().method_10852((class_2561)text.method_27692(BASE_COLOR)));
                for (class_1322 modifier : baseModifier.children) {
                    tooltip.accept((class_2561)AttributeTooltipHandler.listHeader().method_10852((class_2561)AttributeTooltipHandler.createModifierComponent((class_1320)attr.comp_349(), modifier)));
                }
            }
            result.handledAttributes.add(attr);
        }
        BlockRangeTooltipHandler.appendBlockRangeLines(stack, tooltip, player, result);
        EntityRangeTooltipHandler.appendEntityRangeLines(stack, tooltip, player, result);
    }

    private static double applyModifier(double currentValue, double baseValue, class_1322 modifier) {
        return switch (modifier.comp_2450()) {
            default -> throw new MatchException(null, null);
            case class_1322.class_1323.field_6328 -> currentValue + modifier.comp_2449();
            case class_1322.class_1323.field_6330 -> currentValue + modifier.comp_2449() * baseValue;
            case class_1322.class_1323.field_6331 -> currentValue * (1.0 + modifier.comp_2449());
        };
    }

    private static void processRemainingModifiers(class_1799 stack, Consumer<class_2561> tooltip, @Nullable class_1657 player, Multimap<class_6880<class_1320>, class_1322> originalModifierMap, Multimap<class_6880<class_1320>, class_1322> remainingModifiers, Set<class_6880<class_1320>> processedBaseAttributes, TooltipApplyResult result) {
        TreeMap sortedRemaining = new TreeMap(Comparator.comparing(h -> class_7923.field_41190.method_10221((Object)((class_1320)h.comp_349())), Comparator.nullsLast(Comparator.naturalOrder())));
        for (class_6880 class_68802 : remainingModifiers.keySet()) {
            if (processedBaseAttributes.contains(class_68802)) continue;
            ArrayList<class_1322> mods = new ArrayList<class_1322>(remainingModifiers.get((Object)class_68802));
            mods.sort(ATTRIBUTE_MODIFIER_COMPARATOR);
            sortedRemaining.put(class_68802, mods);
        }
        for (Map.Entry entry : sortedRemaining.entrySet()) {
            class_6880 attr = (class_6880)entry.getKey();
            Collection modifiers = (Collection)entry.getValue();
            if (attr == null || modifiers == null || result.handledAttributes.contains(attr) || attr.comp_349() == class_5134.field_47758.comp_349() || attr.comp_349() == class_5134.field_47759.comp_349() || modifiers.isEmpty()) continue;
            AttributeTooltipHandler.handleNonBaseMerging((class_6880<class_1320>)attr, modifiers, tooltip, result);
            result.handledAttributes.add((class_6880<class_1320>)attr);
        }
    }

    private static void handleNonBaseMerging(class_6880<class_1320> attr, Collection<class_1322> modifiers, Consumer<class_2561> tooltip, TooltipApplyResult result) {
        EnumMap<class_1322.class_1323, MergedModifierData> mergeData = new EnumMap<class_1322.class_1323, MergedModifierData>(class_1322.class_1323.class);
        ArrayList<class_1322> nonMergeable = new ArrayList<class_1322>();
        for (class_1322 modifier : modifiers) {
            boolean canMerge;
            if (modifier.comp_2449() == 0.0) continue;
            boolean bl = canMerge = modifier.comp_2450() == class_1322.class_1323.field_6328 || modifier.comp_2450() == class_1322.class_1323.field_6330 || modifier.comp_2450() == class_1322.class_1323.field_6331;
            if (AttributeTooltipHandler.isBaseModifier((class_1320)attr.comp_349(), modifier)) {
                canMerge = false;
            }
            if (canMerge) {
                MergedModifierData data = mergeData.computeIfAbsent(modifier.comp_2450(), op -> new MergedModifierData());
                if (!data.children.isEmpty()) {
                    data.isMerged = true;
                    result.needsShiftPrompt = true;
                }
                data.sum += modifier.comp_2449();
                data.children.add(modifier);
                continue;
            }
            nonMergeable.add(modifier);
        }
        for (class_1322.class_1323 op2 : class_1322.class_1323.values()) {
            MergedModifierData data = (MergedModifierData)mergeData.get(op2);
            if (data == null || data.sum == 0.0) continue;
            class_1322 fakeModifier = new class_1322(FAKE_MERGED_ID, data.sum, op2);
            class_5250 modComponent = AttributeTooltipHandler.createModifierComponent((class_1320)attr.comp_349(), fakeModifier);
            if (data.isMerged) {
                tooltip.accept((class_2561)modComponent.method_27694(style -> style.method_36139(7699710)));
                if (!Keybindings.isDetailedView()) continue;
                data.children.sort(ATTRIBUTE_MODIFIER_COMPARATOR);
                for (class_1322 mod : data.children) {
                    tooltip.accept((class_2561)AttributeTooltipHandler.listHeader().method_10852((class_2561)AttributeTooltipHandler.createModifierComponent((class_1320)attr.comp_349(), mod)));
                }
                continue;
            }
            if (data.children.isEmpty()) continue;
            tooltip.accept((class_2561)AttributeTooltipHandler.createModifierComponent((class_1320)attr.comp_349(), data.children.get(0)));
        }
        nonMergeable.sort(ATTRIBUTE_MODIFIER_COMPARATOR);
        for (class_1322 modifier : nonMergeable) {
            tooltip.accept((class_2561)AttributeTooltipHandler.createModifierComponent((class_1320)attr.comp_349(), modifier));
        }
    }

    private static class_5250 createBaseComponent(class_1320 attribute, double value, double entityBase, boolean merged) {
        return class_2561.method_43469((String)"attribute.modifier.equals.0", (Object[])new Object[]{FORMAT.format(value), class_2561.method_43471((String)attribute.method_26830())});
    }

    public static class_5250 createModifierComponent(class_1320 attribute, class_1322 modifier) {
        Integer finalFixedColorInt;
        double value = modifier.comp_2449();
        boolean isPositive = value > 0.0;
        String key = isPositive ? "attribute.modifier.plus." + modifier.comp_2450().method_56082() : "attribute.modifier.take." + modifier.comp_2450().method_56082();
        String formattedValue = AttributeTooltipHandler.formatValue(attribute, value, modifier.comp_2450());
        class_5250 component = class_2561.method_43469((String)key, (Object[])new Object[]{formattedValue, class_2561.method_43471((String)attribute.method_26830())});
        if (!AttributeTooltipHandler.isBaseAttribute(attribute) && modifier.comp_2447().equals((Object)FAKE_MERGED_ID)) {
            return component.method_27694(style -> style.method_36139(7699710));
        }
        class_124 color = class_124.field_1068;
        class_2960 attrId = class_7923.field_41190.method_10221((Object)attribute);
        boolean handledByRule = false;
        Integer fixedColorInt = null;
        DynamicTooltipsConfig.Client.AttributeColorRule rule = AttributeTooltipHandler.getAttributeColorRule(attribute);
        if (rule != null) {
            handledByRule = true;
            switch (rule.logic()) {
                case FIXED: {
                    try {
                        if (rule.hexColor() != null) {
                            fixedColorInt = Integer.parseInt(rule.hexColor().substring(1), 16);
                            break;
                        }
                        LOGGER.warn("FIXED color rule for {} missing hex color string.", (Object)rule.attributeId());
                        handledByRule = false;
                    }
                    catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                        LOGGER.warn("Invalid hex color format in config rule for {}: '{}'", new Object[]{rule.attributeId(), rule.hexColor(), e});
                        handledByRule = false;
                    }
                    break;
                }
                case INVERTED: {
                    color = attribute.method_60494(!isPositive);
                }
            }
        }
        if (!handledByRule) {
            color = attribute.method_60494(isPositive);
        }
        if ((finalFixedColorInt = fixedColorInt) != null) {
            return component.method_27694(style -> style.method_36139(finalFixedColorInt.intValue()));
        }
        class_124 finalColor = color;
        return component.method_27694(style -> style.method_27706(finalColor));
    }

    private static String formatValue(class_1320 attribute, double value, class_1322.class_1323 operation) {
        double absValue = Math.abs(value);
        if (operation == class_1322.class_1323.field_6328) {
            if (attribute == class_5134.field_23718.comp_349()) {
                return FORMAT.format(absValue * 100.0) + "%";
            }
            return FORMAT.format(absValue);
        }
        return FORMAT.format(absValue * 100.0);
    }

    private static boolean isBaseAttribute(class_1320 attribute) {
        class_2960 id = class_7923.field_41190.method_10221((Object)attribute);
        return id != null && BASE_ATTRIBUTE_IDS.contains(id);
    }

    private static boolean isBaseModifier(class_1320 attribute, class_1322 modifier) {
        class_2960 baseId = AttributeTooltipHandler.getBaseModifierId(attribute);
        return modifier.comp_2447().equals((Object)baseId);
    }

    @Nullable
    private static class_2960 getBaseModifierId(class_1320 attribute) {
        class_2960 id = class_7923.field_41190.method_10221((Object)attribute);
        return id != null ? BASE_MODIFIER_IDS.get(id) : null;
    }

    public static class_5250 listHeader() {
        return class_2561.method_43470((String)" \u2507 ").method_27692(class_124.field_1080);
    }

    private static List<AttributeSection> findAttributeSections(List<class_2561> tooltip) {
        ArrayList<AttributeSection> result = new ArrayList<AttributeSection>();
        for (int i = 0; i < tooltip.size(); ++i) {
            int numLines;
            class_2561 line = tooltip.get(i);
            class_9274 slot = AttributeTooltipHandler.getSlotFromText(line);
            if (slot == null || (numLines = AttributeTooltipHandler.countAttributeLines(tooltip, i + 1)) <= 0) continue;
            result.add(new AttributeSection(i, numLines, slot));
        }
        return result;
    }

    @Nullable
    public static class_9274 getSlotFromText(class_2561 text) {
        class_7417 class_74172 = text.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatableContents = (class_2588)class_74172;
            String key = translatableContents.method_11022();
            String serializedName = null;
            if (key.startsWith("item.modifiers.")) {
                serializedName = key.substring("item.modifiers.".length());
            } else if (key.startsWith("tiered.slot.")) {
                serializedName = key.substring("tiered.slot.".length());
            }
            if (serializedName != null) {
                for (class_9274 group : class_9274.values()) {
                    if (!group.method_15434().equals(serializedName)) continue;
                    return group;
                }
            }
        }
        return null;
    }

    private static int countAttributeLines(List<class_2561> tooltip, int startIndex) {
        String trimmedLine;
        class_2561 lineComp;
        String line;
        int count = 0;
        for (int i = startIndex; i < tooltip.size() && !(line = (lineComp = tooltip.get(i)).getString()).isEmpty() && AttributeTooltipHandler.getSlotFromText(lineComp) == null && !(trimmedLine = line.trim()).isEmpty(); ++i) {
            boolean looksLikeModifier;
            char firstChar = trimmedLine.charAt(0);
            boolean bl = looksLikeModifier = line.startsWith(" ") || firstChar == '+' || firstChar == '-' || Character.isDigit(firstChar) || firstChar == '(';
            if (!looksLikeModifier) break;
            ++count;
        }
        return count;
    }

    private static /* synthetic */ void lambda$getSortedModifiers$7(Multimap map, class_6880 attributeHolder, class_1322 modifier, class_9285.class_11193 display) {
        if (attributeHolder != null && modifier != null && display != class_9285.class_11193.method_70733()) {
            map.put((Object)attributeHolder, (Object)modifier);
        }
    }

    public record ProcessingResult(boolean modified, @Nullable class_2561 finalHeader, boolean needsShiftPrompt) {
        static final ProcessingResult NO_CHANGE = new ProcessingResult(false, null, false);
    }

    private static class AttributeSection {
        final int startIndex;
        final int lineCount;
        final class_9274 slot;

        AttributeSection(int startIndex, int lineCount, class_9274 slot) {
            this.startIndex = startIndex;
            this.lineCount = lineCount;
            this.slot = slot;
        }
    }

    public static class TooltipApplyResult {
        boolean needsShiftPrompt = false;
        Set<class_6880<class_1320>> handledAttributes = new HashSet<class_6880<class_1320>>();
    }

    public static class BaseModifier {
        final class_1322 base;
        final List<class_1322> children;

        BaseModifier(class_1322 base, List<class_1322> children) {
            this.base = base;
            this.children = children;
        }
    }

    private static class MergedModifierData {
        double sum = 0.0;
        boolean isMerged = false;
        List<class_1322> children = new ArrayList<class_1322>();

        private MergedModifierData() {
        }
    }
}

