/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamictooltips.mixin;

import com.bawnorton.mixinsquared.adjuster.tools.AdjustableAnnotationNode;
import com.bawnorton.mixinsquared.api.MixinAnnotationAdjuster;
import dev.muon.dynamictooltips.DynamicTooltips;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.Inject;

public class DynamicTooltipsMixinAdjuster
implements MixinAnnotationAdjuster {
    private static final List<String> TIERED_METHODS_TO_DISABLE = Arrays.asList("appendAttributeModifiersTooltipTwoMixin", "appendAttributeModifierTooltipMixin", "appendAttributeModifierTooltipTwoMixin", "appendAttributeModifierTooltipThreeMixin");

    public AdjustableAnnotationNode adjust(List<String> targetClassNames, String mixinClassName, MethodNode method, AdjustableAnnotationNode annotation) {
        String methodName;
        if (!mixinClassName.equals("draylar.tiered.mixin.client.ItemStackClientMixin")) {
            return annotation;
        }
        if (annotation.is(Inject.class) && TIERED_METHODS_TO_DISABLE.contains(methodName = method.name)) {
            DynamicTooltips.LOGGER.info("Adjuster: Disabling @Inject in TieredZ mixin {}.{}", (Object)mixinClassName, (Object)methodName);
            return null;
        }
        return annotation;
    }
}

