/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamictooltips.handlers;

import dev.muon.dynamictooltips.EnchantmentContext;
import dev.muon.dynamictooltips.Keybindings;
import dev.muon.dynamictooltips.config.DynamicTooltipsConfig;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class EnchantmentTooltipHandler {
    private static final String[] KEY_TYPES = new String[]{"desc", "description", "info"};
    private static EnchantmentTooltipHandler instance;

    public static EnchantmentTooltipHandler getInstance() {
        if (instance == null) {
            instance = new EnchantmentTooltipHandler();
        }
        return instance;
    }

    public void setupContext(class_1799 stack) {
        if (this.shouldDisplayDescription(stack)) {
            EnchantmentContext provider;
            Object object = stack.method_58657();
            if (object instanceof EnchantmentContext) {
                provider = (EnchantmentContext)object;
                provider.dynamictooltips$setStack(stack);
            }
            if ((object = stack.method_58694(class_9334.field_49643)) instanceof EnchantmentContext) {
                provider = (EnchantmentContext)object;
                provider.dynamictooltips$setStack(stack);
            }
        }
    }

    public void revertContext(class_1799 stack) {
        EnchantmentContext provider;
        Object object = stack.method_58657();
        if (object instanceof EnchantmentContext) {
            provider = (EnchantmentContext)object;
            provider.dynamictooltips$setStack(class_1799.field_8037);
        }
        if ((object = stack.method_58694(class_9334.field_49643)) instanceof EnchantmentContext) {
            provider = (EnchantmentContext)object;
            provider.dynamictooltips$setStack(class_1799.field_8037);
        }
    }

    public static boolean hasEnchantments(class_1799 stack) {
        return !((class_9304)stack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385)).method_57543() || !((class_9304)stack.method_58695(class_9334.field_49643, (Object)class_9304.field_49385)).method_57543();
    }

    public static boolean itemHasExpandableEnchantments(class_1799 stack) {
        return (Boolean)DynamicTooltipsConfig.CLIENT.collapseEnchantmentTooltipsOnGear.get() != false && EnchantmentTooltipHandler.hasEnchantments(stack) && stack.method_7909() != class_1802.field_8598;
    }

    public boolean shouldDisplayDescription(class_1799 stack) {
        if (!EnchantmentTooltipHandler.hasEnchantments(stack)) {
            return false;
        }
        if (stack.method_7909() == class_1802.field_8598) {
            return true;
        }
        return (Boolean)DynamicTooltipsConfig.CLIENT.collapseEnchantmentTooltipsOnGear.get() == false || Keybindings.isDetailedView();
    }

    public void insertDescriptions(class_6880<class_1887> enchantment, int level, Consumer<class_2561> lines) {
        class_2561 description = this.getDescription(enchantment, ((class_5321)enchantment.method_40230().orElseThrow()).method_29177(), level);
        if (description != null) {
            String hexColor = (String)DynamicTooltipsConfig.CLIENT.enchantmentDescriptionColor.get();
            int color = Integer.parseInt(hexColor.substring(1), 16);
            class_2583 descriptionStyle = class_2583.field_24360.method_36139(color).method_10978(Boolean.valueOf(true));
            class_5250 styledDescription = description.method_27661().method_27696(descriptionStyle);
            lines.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)styledDescription));
        }
    }

    @Nullable
    private class_2561 getDescription(class_6880<class_1887> enchantment, class_2960 id, int level) {
        class_7417 class_74172;
        class_2561 description = this.findTranslation("enchantment." + id.method_12836() + "." + id.method_12832() + ".", level);
        if (description == null && (class_74172 = ((class_1887)enchantment.comp_349()).comp_2686().method_10851()) instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            description = this.findTranslation(translatable.method_11022() + ".", level);
        }
        return description;
    }

    @Nullable
    private class_2561 findTranslation(String baseKey, int level) {
        for (String keyType : KEY_TYPES) {
            String key = baseKey + keyType;
            if (class_1074.method_4663((String)key)) {
                return class_2561.method_43471((String)key);
            }
            if (!class_1074.method_4663((String)(key = key + "." + level))) continue;
            return class_2561.method_43471((String)key);
        }
        return null;
    }
}

