/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamictooltips.handlers;

import dev.muon.dynamictooltips.Keybindings;
import dev.muon.dynamictooltips.config.DynamicTooltipsConfig;
import dev.muon.dynamictooltips.handlers.AttributeTooltipHandler;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9274;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRangeTooltipHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"DynamicTooltips-EntityRange");
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ROOT));
    private static final class_6880<class_1320> ENTITY_RANGE_ATTR_HOLDER = class_5134.field_47759;

    public static void appendEntityRangeLines(class_1799 stack, Consumer<class_2561> tooltipConsumer, @Nullable class_1657 player, AttributeTooltipHandler.TooltipApplyResult result) {
        if (!((Boolean)DynamicTooltipsConfig.CLIENT.appendEntityInteractionRangeTooltip.get()).booleanValue()) {
            return;
        }
        if (!(player instanceof class_746)) {
            return;
        }
        class_746 localPlayer = (class_746)player;
        boolean isRelevantWeapon = ((List)DynamicTooltipsConfig.CLIENT.entityInteractionRangeItemTags.get()).stream().anyMatch(entry -> DynamicTooltipsConfig.Client.matchesItemOrTag(stack, entry));
        if (!isRelevantWeapon) {
            return;
        }
        class_1324 entityRangeInstance = localPlayer.method_5996(ENTITY_RANGE_ATTR_HOLDER);
        if (entityRangeInstance == null) {
            LOGGER.warn("Player {} missing attribute instance for {}", (Object)localPlayer.method_5477().getString(), (Object)((class_1320)ENTITY_RANGE_ATTR_HOLDER.comp_349()).method_26830());
            return;
        }
        double baseValue = entityRangeInstance.method_6201();
        ArrayList<class_1322> relevantModifiers = new ArrayList<class_1322>();
        ArrayList allCurrentModifiers = new ArrayList(entityRangeInstance.method_6195());
        ArrayList viewedItemModifiers = new ArrayList();
        stack.method_60617(class_9274.field_49217, (attrHolder, modifier, display) -> {
            if (attrHolder == ENTITY_RANGE_ATTR_HOLDER) {
                viewedItemModifiers.add(modifier);
            }
        });
        class_1799 equippedStack = localPlayer.method_6047();
        ArrayList equippedItemModifiers = new ArrayList();
        if (!equippedStack.method_7960()) {
            equippedStack.method_60617(class_9274.field_49217, (attrHolder, modifier, display) -> {
                if (attrHolder == ENTITY_RANGE_ATTR_HOLDER) {
                    equippedItemModifiers.add(modifier);
                }
            });
        }
        Set equippedIds = equippedItemModifiers.stream().map(class_1322::comp_2447).collect(Collectors.toSet());
        for (class_1322 mod : allCurrentModifiers) {
            if (equippedIds.contains(mod.comp_2447())) continue;
            relevantModifiers.add(mod);
        }
        relevantModifiers.addAll(viewedItemModifiers);
        relevantModifiers.sort(AttributeTooltipHandler.ATTRIBUTE_MODIFIER_COMPARATOR);
        double finalValue = EntityRangeTooltipHandler.getMergedValue(baseValue, relevantModifiers);
        boolean hasModifications = Math.abs(finalValue - baseValue) > 1.0E-4;
        result.needsShiftPrompt |= hasModifications;
        if (Keybindings.isDetailedView() && hasModifications) {
            tooltipConsumer.accept((class_2561)EntityRangeTooltipHandler.createRangeLine(finalValue, true));
            tooltipConsumer.accept((class_2561)AttributeTooltipHandler.listHeader().method_10852((class_2561)EntityRangeTooltipHandler.createRangeLine(baseValue, false).method_27692(AttributeTooltipHandler.BASE_COLOR)));
            for (class_1322 modifier2 : relevantModifiers) {
                if (modifier2.comp_2449() == 0.0) continue;
                tooltipConsumer.accept((class_2561)AttributeTooltipHandler.listHeader().method_10852((class_2561)AttributeTooltipHandler.createModifierComponent((class_1320)ENTITY_RANGE_ATTR_HOLDER.comp_349(), modifier2)));
            }
        } else {
            tooltipConsumer.accept((class_2561)EntityRangeTooltipHandler.createRangeLine(finalValue, hasModifications));
        }
        result.handledAttributes.add(ENTITY_RANGE_ATTR_HOLDER);
    }

    private static double getMergedValue(double baseValue, List<class_1322> relevantModifiers) {
        double finalValue = baseValue;
        for (class_1322 modifier : relevantModifiers) {
            if (modifier.comp_2450() != class_1322.class_1323.field_6328) continue;
            finalValue += modifier.comp_2449();
        }
        double valueToAddFromBase = 0.0;
        for (class_1322 modifier : relevantModifiers) {
            if (modifier.comp_2450() != class_1322.class_1323.field_6330) continue;
            valueToAddFromBase += baseValue * modifier.comp_2449();
        }
        finalValue += valueToAddFromBase;
        for (class_1322 modifier : relevantModifiers) {
            if (modifier.comp_2450() != class_1322.class_1323.field_6331) continue;
            finalValue *= 1.0 + modifier.comp_2449();
        }
        return finalValue;
    }

    private static class_5250 createRangeLine(double value, boolean isModified) {
        class_5250 text = class_2561.method_43469((String)"attribute.modifier.equals.0", (Object[])new Object[]{FORMAT.format(value), class_2561.method_43471((String)((class_1320)ENTITY_RANGE_ATTR_HOLDER.comp_349()).method_26830())});
        class_124 baseColor = isModified ? null : AttributeTooltipHandler.BASE_COLOR;
        Integer customColor = isModified ? Integer.valueOf(16758784) : null;
        return class_2561.method_43470((String)" ").method_10852((class_2561)text.method_27694(style -> {
            if (customColor != null) {
                return style.method_36139(customColor.intValue());
            }
            if (baseColor != null) {
                return style.method_27706(baseColor);
            }
            return style;
        }));
    }
}

