/*
 * Decompiled with CFR 0.152.
 */
package robotgiggle.hierophantics.blocks;

import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.lib.HexItems;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import robotgiggle.hierophantics.Hierophantics;
import robotgiggle.hierophantics.HierophanticsVillagers;
import robotgiggle.hierophantics.blocks.FlayBedBlockEntity;
import robotgiggle.hierophantics.data.HieroPlayerState;
import robotgiggle.hierophantics.data.HieroServerState;
import robotgiggle.hierophantics.inits.HierophanticsAdvancements;
import robotgiggle.hierophantics.networking.msg.MsgOwnedMindsS2C;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ%\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010$\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!\u00a2\u0006\u0004\b$\u0010%R\u001f\u0010'\u001a\n &*\u0004\u0018\u00010\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u001f\u0010+\u001a\n &*\u0004\u0018\u00010\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b+\u0010(\u001a\u0004\b,\u0010*\u00a8\u0006-"}, d2={"Lrobotgiggle/hierophantics/blocks/FlayBedBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/server/level/ServerLevel;", "world", "Lnet/minecraft/world/entity/Mob;", "sacrifice", "Lat/petrak/hexcasting/api/pigment/FrozenPigment;", "pigment", "", "activate", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/Mob;Lat/petrak/hexcasting/api/pigment/FrozenPigment;)V", "Lnet/minecraft/world/entity/npc/VillagerProfession;", "prof1", "prof2", "", "canSubjectKeepProfession", "(Lnet/minecraft/world/entity/npc/VillagerProfession;Lnet/minecraft/world/entity/npc/VillagerProfession;)I", "Lnet/minecraft/world/item/DyeColor;", "color", "dyeColor", "(Lnet/minecraft/world/item/DyeColor;)Lat/petrak/hexcasting/api/pigment/FrozenPigment;", "Lnet/minecraft/world/entity/Entity;", "getSleeper", "(Lnet/minecraft/server/level/ServerLevel;)Lnet/minecraft/world/entity/Entity;", "amount", "makeParticles", "(Lnet/minecraft/server/level/ServerLevel;Lat/petrak/hexcasting/api/pigment/FrozenPigment;I)V", "Lnet/minecraft/world/item/trading/MerchantOffers;", "existingList", "incomingList", "mergeTradeLists", "(Lnet/minecraft/world/item/trading/MerchantOffers;Lnet/minecraft/world/item/trading/MerchantOffers;)V", "kotlin.jvm.PlatformType", "headPos", "Lnet/minecraft/core/BlockPos;", "getHeadPos", "()Lnet/minecraft/core/BlockPos;", "otherPartPos", "getOtherPartPos", "hierophantics-common"})
@SourceDebugExtension(value={"SMAP\nFlayBedBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlayBedBlockEntity.kt\nrobotgiggle/hierophantics/blocks/FlayBedBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public final class FlayBedBlockEntity
extends BlockEntity {
    private final BlockPos otherPartPos;
    private final BlockPos headPos;

    public FlayBedBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super((BlockEntityType)Hierophantics.INSTANCE.getFLAY_BED_BLOCK_ENTITY().get(), pos, state);
        this.otherPartPos = pos.m_121945_(BedBlock.m_49557_((BlockState)state));
        Comparable comparable = state.m_61143_((Property)BedBlock.f_49440_);
        Intrinsics.checkNotNull((Object)comparable);
        this.headPos = switch (WhenMappings.$EnumSwitchMapping$0[((BedPart)comparable).ordinal()]) {
            case 1 -> pos;
            case 2 -> this.otherPartPos;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final BlockPos getOtherPartPos() {
        return this.otherPartPos;
    }

    public final BlockPos getHeadPos() {
        return this.headPos;
    }

    public final void activate(@NotNull ServerLevel world, @NotNull BlockState state, @NotNull Mob sacrifice, @NotNull FrozenPigment pigment) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)sacrifice, (String)"sacrifice");
        Intrinsics.checkNotNullParameter((Object)pigment, (String)"pigment");
        Comparable comparable = state.m_61143_((Property)BedBlock.f_49441_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"get(...)");
        if (((Boolean)comparable).booleanValue()) {
            Entity subject = this.getSleeper(world);
            if (subject instanceof ServerPlayer && sacrifice instanceof Villager) {
                Component component = sacrifice.m_7770_();
                String villagerName = component != null ? component.getString() : null;
                HieroPlayerState hieroPlayerState = HieroServerState.Companion.getPlayerState((Player)subject);
                MinecraftServer minecraftServer = world.m_7654_();
                Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
                int newTotal = hieroPlayerState.addMind(minecraftServer, villagerName);
                new MsgOwnedMindsS2C(newTotal).sendToPlayer((ServerPlayer)subject);
                HierophanticsAdvancements.INSTANCE.getEMBED_MIND().trigger((ServerPlayer)subject);
                world.m_5594_(null, this.headPos, SoundEvents.f_12616_, SoundSource.BLOCKS, 1.2f, 1.0f);
                this.makeParticles(world, pigment, 60);
            } else if (subject instanceof ServerPlayer && sacrifice instanceof Allay) {
                if (((ServerPlayer)subject).m_21023_((MobEffect)Hierophantics.MEDIA_DISCOUNT_EFFECT.get())) {
                    MobEffectInstance mobEffectInstance = ((ServerPlayer)subject).m_21124_((MobEffect)Hierophantics.MEDIA_DISCOUNT_EFFECT.get());
                    Intrinsics.checkNotNull((Object)mobEffectInstance);
                    int oldTicks = mobEffectInstance.m_19557_();
                    int newTicks = (int)((double)6000 * Math.pow(Math.E, -oldTicks / 12000));
                    ((ServerPlayer)subject).m_21195_((MobEffect)Hierophantics.MEDIA_DISCOUNT_EFFECT.get());
                    ((ServerPlayer)subject).m_7292_(new MobEffectInstance((MobEffect)Hierophantics.MEDIA_DISCOUNT_EFFECT.get(), newTicks + oldTicks));
                } else {
                    ((ServerPlayer)subject).m_7292_(new MobEffectInstance((MobEffect)Hierophantics.MEDIA_DISCOUNT_EFFECT.get(), 6000));
                }
                HierophanticsAdvancements.INSTANCE.getEMBED_MIND().trigger((ServerPlayer)subject);
                world.m_5594_(null, this.headPos, SoundEvents.f_12616_, SoundSource.BLOCKS, 1.2f, 1.0f);
                this.makeParticles(world, pigment, 60);
            } else if (subject instanceof Villager && sacrifice instanceof Villager) {
                Player nearestPlayer;
                VillagerData data = ((Villager)subject).m_7141_();
                MerchantOffers trades = ((Villager)subject).m_6616_();
                int newLevel = Math.min(data.m_35576_() + 1, 5);
                VillagerProfession villagerProfession = data.m_35571_();
                Intrinsics.checkNotNullExpressionValue((Object)villagerProfession, (String)"getProfession(...)");
                VillagerProfession villagerProfession2 = ((Villager)sacrifice).m_7141_().m_35571_();
                Intrinsics.checkNotNullExpressionValue((Object)villagerProfession2, (String)"getProfession(...)");
                switch (this.canSubjectKeepProfession(villagerProfession, villagerProfession2)) {
                    case 0: {
                        ((Villager)subject).m_34375_(data.m_35561_(newLevel));
                        break;
                    }
                    case 1: {
                        ((Villager)subject).m_34375_(data.m_35561_(newLevel).m_35565_(((Villager)sacrifice).m_7141_().m_35571_()));
                        break;
                    }
                    case 2: {
                        ((Villager)subject).m_34375_(data.m_35561_(newLevel).m_35565_(HierophanticsVillagers.QUILTMIND.get()));
                    }
                }
                Intrinsics.checkNotNull((Object)trades);
                MerchantOffers merchantOffers = ((Villager)sacrifice).m_6616_();
                Intrinsics.checkNotNullExpressionValue((Object)merchantOffers, (String)"getOffers(...)");
                this.mergeTradeLists(trades, merchantOffers);
                ((Villager)subject).m_35476_(trades);
                ((Villager)subject).m_35546_(VillagerData.m_35572_((int)newLevel));
                Player player = nearestPlayer = world.m_45924_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 10.0, false);
                if (player != null) {
                    Player it = player;
                    boolean bl = false;
                    HierophanticsAdvancements.INSTANCE.getFUSE_VILLAGERS().trigger((ServerPlayer)it);
                }
                world.m_5594_(null, this.headPos, SoundEvents.f_12616_, SoundSource.BLOCKS, 1.2f, 1.0f);
                this.makeParticles(world, pigment, 60);
            } else {
                Hierophantics.LOGGER.warn("Imbuement Bed couldn't find sleeping player or villager");
                this.makeParticles(world, this.dyeColor(DyeColor.GRAY), 80);
            }
        } else {
            Player nearestPlayer;
            Player player = nearestPlayer = world.m_45924_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 10.0, false);
            if (player != null) {
                Player it = player;
                boolean bl = false;
                HierophanticsAdvancements.INSTANCE.getWASTE_MIND().trigger((ServerPlayer)it);
            }
            this.makeParticles(world, this.dyeColor(DyeColor.RED), 80);
        }
    }

    @Nullable
    public final Entity getSleeper(@NotNull ServerLevel world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        List entities2 = world.m_6443_(Entity.class, new AABB(this.headPos), arg_0 -> FlayBedBlockEntity.getSleeper$lambda$2(getSleeper.entities.1.INSTANCE, arg_0));
        if (entities2.isEmpty()) {
            return null;
        }
        return (Entity)entities2.get(0);
    }

    public final int canSubjectKeepProfession(@NotNull VillagerProfession prof1, @NotNull VillagerProfession prof2) {
        Intrinsics.checkNotNullParameter((Object)prof1, (String)"prof1");
        Intrinsics.checkNotNullParameter((Object)prof2, (String)"prof2");
        if (Intrinsics.areEqual((Object)prof1, (Object)prof2) && Intrinsics.areEqual((Object)prof1, (Object)VillagerProfession.f_35585_)) {
            return 2;
        }
        if (Intrinsics.areEqual((Object)prof1, (Object)prof2) || Intrinsics.areEqual((Object)prof2, (Object)VillagerProfession.f_35585_)) {
            return 0;
        }
        if (Intrinsics.areEqual((Object)prof1, (Object)VillagerProfession.f_35585_)) {
            return 1;
        }
        return 2;
    }

    public final void mergeTradeLists(@NotNull MerchantOffers existingList, @NotNull MerchantOffers incomingList) {
        Intrinsics.checkNotNullParameter((Object)existingList, (String)"existingList");
        Intrinsics.checkNotNullParameter((Object)incomingList, (String)"incomingList");
        for (MerchantOffer newOffer : incomingList) {
            boolean merged = false;
            int n = existingList.size();
            for (int i = 0; i < n; ++i) {
                if (!ItemStack.m_41728_((ItemStack)((MerchantOffer)existingList.get(i)).m_45352_(), (ItemStack)newOffer.m_45352_()) || !ItemStack.m_41728_((ItemStack)((MerchantOffer)existingList.get(i)).m_45364_(), (ItemStack)newOffer.m_45364_()) || !ItemStack.m_41728_((ItemStack)((MerchantOffer)existingList.get(i)).m_45368_(), (ItemStack)newOffer.m_45368_())) continue;
                existingList.set(i, (Object)new MerchantOffer(((MerchantOffer)existingList.get(i)).m_45352_(), ((MerchantOffer)existingList.get(i)).m_45364_(), ((MerchantOffer)existingList.get(i)).m_45368_(), ((MerchantOffer)existingList.get(i)).m_45373_() + newOffer.m_45373_(), ((MerchantOffer)existingList.get(i)).m_45379_(), ((MerchantOffer)existingList.get(i)).m_45378_()));
                merged = true;
                break;
            }
            if (merged) continue;
            existingList.add((Object)newOffer);
        }
    }

    @NotNull
    public final FrozenPigment dyeColor(@NotNull DyeColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Object v = HexItems.DYE_PIGMENTS.get(color);
        Intrinsics.checkNotNull(v);
        return new FrozenPigment(new ItemStack((ItemLike)v), Util.f_137441_);
    }

    public final void makeParticles(@NotNull ServerLevel world, @NotNull FrozenPigment color, int amount) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Vec3 adjust = new Vec3(0.0, -0.17, 0.0);
        Vec3 vec3 = this.f_58858_.m_252807_().m_82549_(adjust);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        new ParticleSpray(vec3, new Vec3(0.0, 0.5, 0.0), 1.3, 0.0, amount).sprayParticles(world, color);
        Vec3 vec32 = this.otherPartPos.m_252807_().m_82549_(adjust);
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
        new ParticleSpray(vec32, new Vec3(0.0, 0.5, 0.0), 1.3, 0.0, amount).sprayParticles(world, color);
    }

    private static final boolean getSleeper$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BedPart.values().length];
            try {
                nArray[BedPart.HEAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BedPart.FOOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

