/*
 * Decompiled with CFR 0.152.
 */
package robotgiggle.hierophantics.mixin;

import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import robotgiggle.hierophantics.HierophanticsClient;
import robotgiggle.hierophantics.blocks.FlayBedBlock;
import robotgiggle.hierophantics.data.HieroServerState;

@Mixin(value={Player.class})
public class PlayerEntityMixin {
    @Inject(method={"applyDamage"}, at={@At(value="TAIL")})
    private void fireDamageTriggers(DamageSource source, float amount, CallbackInfo ci) {
        Player player = (Player)this;
        if (player.m_9236_().f_46443_ || player.m_6673_(source)) {
            return;
        }
        String dmgType = source.m_19385_();
        DoubleIota initialIota = new DoubleIota((double)amount);
        if (!dmgType.equals("genericKill")) {
            if (!dmgType.equals("hexcasting.overcast")) {
                HieroServerState.getPlayerState(player).triggerMinds((ServerPlayer)player, "damage", (Iota)initialIota);
            }
            HieroServerState.getPlayerState(player).checkTypedDamage((ServerPlayer)player, dmgType, (Iota)initialIota);
        }
    }

    @Inject(method={"jump"}, at={@At(value="TAIL")})
    private void fireJumpTriggers(CallbackInfo ci) {
        Player player = (Player)this;
        if (player.m_9236_().f_46443_) {
            return;
        }
        HieroServerState.getPlayerState(player).triggerMinds((ServerPlayer)player, "jump");
    }

    @Inject(method={"getHurtSound"}, at={@At(value="TAIL")}, cancellable=true)
    private void playVillagerHurtNoise(CallbackInfoReturnable<SoundEvent> ci) {
        if (ci.getReturnValue() == SoundEvents.f_12323_) {
            Player player = (Player)this;
            int minds = 0;
            minds = player.m_9236_().m_5776_() ? HierophanticsClient.getClientOwnedMinds() : HieroServerState.getPlayerState(player).getOwnedMinds();
            if (player.m_217043_().m_188500_() < 0.3 - 1.0 / (double)(minds + 3)) {
                ci.setReturnValue((Object)SoundEvents.f_12506_);
            }
        }
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;isSleeping()Z")})
    private boolean notSleepingIfOnFlayBed(Player instance, Operation<Boolean> original) {
        Block sleepingOn = instance.m_9236_().m_8055_(instance.m_20183_()).m_60734_();
        if (sleepingOn instanceof FlayBedBlock) {
            return false;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @Inject(method={"canResetTimeBySleeping"}, at={@At(value="HEAD")}, cancellable=true)
    private void cantResetTimeIfOnFlayBed(CallbackInfoReturnable<Boolean> ci) {
        Player player = (Player)this;
        Block sleepingOn = player.m_9236_().m_8055_(player.m_20183_()).m_60734_();
        if (sleepingOn instanceof FlayBedBlock) {
            ci.setReturnValue((Object)false);
        }
    }
}

