/*
 * Decompiled with CFR 0.152.
 */
package robotgiggle.hierophantics.mixin;

import at.petrak.hexcasting.api.casting.iota.EntityIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import robotgiggle.hierophantics.blocks.FlayBedBlock;
import robotgiggle.hierophantics.data.HieroPlayerState;
import robotgiggle.hierophantics.data.HieroServerState;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin
extends Player {
    ServerPlayerEntityMixin(Level world, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(world, blockPos, f, gameProfile);
    }

    @Inject(method={"dropItem"}, at={@At(value="TAIL")})
    private void fireDropTriggers(ItemStack itemStack, boolean throwRandomly, boolean retainOwnership, CallbackInfoReturnable<ItemStack> ci, @Local ItemEntity droppedEntity) {
        if (!throwRandomly && retainOwnership) {
            ServerPlayer player = (ServerPlayer)this;
            HieroServerState.getPlayerState((Player)player).triggerMinds(player, "drop", (Iota)new EntityIota((Entity)droppedEntity));
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void checkThresholdTriggers(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        HieroServerState.getPlayerState((Player)player).tick(player);
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void disableMindsOnDeath(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        HieroPlayerState state = HieroServerState.getPlayerState((Player)player);
        if (state.getOwnedMinds() > 0) {
            state.setDisabled(true);
            state.setSkipTeleTrigger(5);
        }
    }

    @Inject(method={"worldChanged"}, at={@At(value="HEAD")})
    private void skipTeleTriggerWhenChangingDims(CallbackInfo ci) {
        this.skipTeleTrigger();
    }

    @Inject(method={"startRiding"}, at={@At(value="RETURN")})
    private void skipTeleTriggerWhenMountingEntity(CallbackInfoReturnable<Boolean> ci) {
        if (((Boolean)ci.getReturnValue()).booleanValue()) {
            this.skipTeleTrigger();
        }
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD")})
    private void skipTeleTriggerWhenDismountingEntity(CallbackInfo ci) {
        this.skipTeleTrigger();
    }

    @Inject(method={"sleep"}, at={@At(value="HEAD")})
    private void skipTeleTriggerWhenGettingIntoBed(CallbackInfo ci) {
        this.skipTeleTrigger();
    }

    @Inject(method={"wakeUp"}, at={@At(value="HEAD")})
    private void skipTeleTriggerWhenGettingOutOfBed(CallbackInfo ci) {
        this.skipTeleTrigger();
    }

    private void skipTeleTrigger() {
        ServerPlayer player = (ServerPlayer)this;
        HieroPlayerState state = HieroServerState.getPlayerState((Player)player);
        if (state.getOwnedMinds() > 0) {
            state.setSkipTeleTrigger(5);
        }
    }

    @Inject(method={"trySleep"}, at={@At(value="HEAD")}, cancellable=true)
    private void trySleepInFlayBed(BlockPos blockPos, CallbackInfoReturnable<Either<Player.BedSleepingProblem, Unit>> ci) {
        ServerPlayer player = (ServerPlayer)this;
        Block block = player.m_9236_().m_8055_(blockPos).m_60734_();
        if (block instanceof FlayBedBlock) {
            ci.setReturnValue(this.trimmedTrySleep(player, blockPos));
        }
    }

    @Shadow
    private boolean m_9116_(BlockPos blockPos, Direction direction) {
        return false;
    }

    @Shadow
    private boolean m_9191_(BlockPos blockPos, Direction direction) {
        return false;
    }

    private Either<Player.BedSleepingProblem, Unit> trimmedTrySleep(ServerPlayer player, BlockPos blockPos) {
        Direction direction = (Direction)player.m_9236_().m_8055_(blockPos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        if (player.m_5803_() || !player.m_6084_()) {
            return Either.left((Object)Player.BedSleepingProblem.OTHER_PROBLEM);
        }
        if (!this.m_9116_(blockPos, direction)) {
            return Either.left((Object)Player.BedSleepingProblem.TOO_FAR_AWAY);
        }
        if (this.m_9191_(blockPos, direction)) {
            return Either.left((Object)Player.BedSleepingProblem.OBSTRUCTED);
        }
        return super.m_7720_(blockPos);
    }
}

