/*
 * Decompiled with CFR 0.152.
 */
package robotgiggle.hierophantics.mixin.client;

import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import robotgiggle.hierophantics.Hierophantics;
import robotgiggle.hierophantics.HierophanticsClient;
import robotgiggle.hierophantics.inits.HierophanticsConfig;

@Mixin(value={AbstractClientPlayer.class})
public class AbstractClientPlayerEntityMixin {
    @Unique
    int hallucinationCooldown = 70;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void hallucinateAudio(CallbackInfo ci) {
        AbstractClientPlayer cPlayer = (AbstractClientPlayer)this;
        RandomSource rand = cPlayer.m_217043_();
        HierophanticsConfig.ClientConfig.AudioHallucinations config = HierophanticsConfig.getClient().getAudioHallucinations();
        if (this.hallucinationCooldown > 0) {
            --this.hallucinationCooldown;
            return;
        }
        double villagerChance = Math.min(config.getBaseVillagerRate() * (double)HierophanticsClient.getClientOwnedMinds(), config.getMaxVillagerRate());
        if (rand.m_188500_() < villagerChance) {
            Vec3 source = this.randomSpherePoint(rand.m_188500_() * 2.5 + 3.5, rand).m_82549_(cPlayer.m_20182_());
            cPlayer.f_108545_.m_7785_(source.f_82479_, source.f_82480_, source.f_82481_, SoundEvents.f_12503_, SoundSource.PLAYERS, 0.5f, 1.0f, true);
            this.hallucinationCooldown = config.getCooldown();
            return;
        }
        if (rand.m_188500_() < config.getAllayRate() && cPlayer.m_21023_((MobEffect)Hierophantics.MEDIA_DISCOUNT_EFFECT.get())) {
            Vec3 source = this.randomSpherePoint(rand.m_188500_() * 2.5 + 3.0, rand).m_82549_(cPlayer.m_20182_());
            if (rand.m_188500_() < 0.5) {
                cPlayer.f_108545_.m_7785_(source.f_82479_, source.f_82480_, source.f_82481_, SoundEvents.f_144243_, SoundSource.PLAYERS, 1.0f, 0.5f + rand.m_188501_() * 1.2f, true);
            } else {
                cPlayer.f_108545_.m_7785_(source.f_82479_, source.f_82480_, source.f_82481_, SoundEvents.f_215671_, SoundSource.PLAYERS, 0.3f, 1.0f, true);
            }
            this.hallucinationCooldown = config.getCooldown();
        }
    }

    private Vec3 randomSpherePoint(double radius, RandomSource rand) {
        double x = rand.m_188583_();
        double y = rand.m_188583_();
        double z = rand.m_188583_();
        return new Vec3(x, y, z).m_82541_().m_82490_(radius);
    }
}

