/*
 * Decompiled with CFR 0.152.
 */
package robotgiggle.hierophantics.patterns;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.entity.schedule.ScheduleBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import robotgiggle.hierophantics.Hierophantics;
import robotgiggle.hierophantics.data.HieroServerState;
import robotgiggle.hierophantics.inits.HierophanticsConfig;
import robotgiggle.hierophantics.minterface.VillagerEntityMinterface;
import robotgiggle.hierophantics.mixin.accessor.PlayerEntityAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u00118\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lrobotgiggle/hierophantics/patterns/OpVillagerSleep;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "<init>", "()V", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "args", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "execute", "(Ljava/util/List;Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "Lnet/minecraft/world/entity/player/Player;", "player", "", "playerIsSleepable", "(Lnet/minecraft/world/entity/player/Player;)Z", "", "argc", "I", "getArgc", "()I", "Spell", "hierophantics-common"})
public final class OpVillagerSleep
implements SpellAction {
    private final int argc;

    public OpVillagerSleep() {
        this.argc = 1;
    }

    public int getArgc() {
        return this.argc;
    }

    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        LivingEntity target = OperatorUtils.getLivingEntityButNotArmorStand(args, (int)0, (int)this.getArgc());
        env.assertEntityInRange((Entity)target);
        if (!(target instanceof Villager || target instanceof Player && this.playerIsSleepable((Player)target))) {
            Entity entity = (Entity)target;
            MutableComponent mutableComponent = Component.m_237115_((String)"hexcasting.mishap.invalid_value.class.entity.villager");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            throw new MishapBadEntity(entity, (Component)mutableComponent);
        }
        return new SpellAction.Result((RenderedSpell)new Spell(target), 100000L, CollectionsKt.emptyList(), 0L, 8, null);
    }

    public final boolean playerIsSleepable(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return HierophanticsConfig.getServer().getPlayerSleepSpell() && HieroServerState.Companion.getPlayerState(player).getOwnedMinds() > 0;
    }

    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata((SpellAction)this, args, (CastingEnvironment)env, (CompoundTag)userData);
    }

    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate((SpellAction)this, (CastingEnvironment)env, (CastingImage)image, (SpellContinuation)continuation);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\f\u00a8\u0006\u001c"}, d2={"Lrobotgiggle/hierophantics/patterns/OpVillagerSleep$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "Lnet/minecraft/world/entity/LivingEntity;", "target", "<init>", "(Lnet/minecraft/world/entity/LivingEntity;)V", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "", "cast", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)V", "component1", "()Lnet/minecraft/world/entity/LivingEntity;", "copy", "(Lnet/minecraft/world/entity/LivingEntity;)Lrobotgiggle/hierophantics/patterns/OpVillagerSleep$Spell;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/world/entity/LivingEntity;", "getTarget", "hierophantics-common"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final LivingEntity target;

        public Spell(@NotNull LivingEntity target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.target = target;
        }

        @NotNull
        public final LivingEntity getTarget() {
            return this.target;
        }

        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (this.target instanceof Villager) {
                int now = (int)(env.getWorld().m_46468_() % (long)24000);
                Schedule forcedSleepSched = new ScheduleBuilder(new Schedule()).m_38040_(now, Activity.f_37982_).m_38040_(now + 300, Activity.f_37979_).m_38039_();
                ((Villager)this.target).m_6274_().m_21912_(forcedSleepSched);
                LivingEntity livingEntity = this.target;
                Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type robotgiggle.hierophantics.minterface.VillagerEntityMinterface");
                ((VillagerEntityMinterface)livingEntity).setForcedSleepStatus(this.target.m_6162_() ? 2 : 1);
            } else if (this.target instanceof Player && env.getWorld().m_46462_()) {
                this.target.m_5802_(this.target.m_20183_());
                LivingEntity livingEntity = this.target;
                Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type robotgiggle.hierophantics.mixin.accessor.PlayerEntityAccessor");
                ((PlayerEntityAccessor)livingEntity).setSleepTimer(0);
                this.target.m_7292_(new MobEffectInstance((MobEffect)Hierophantics.SLEEP_ANYWHERE_EFFECT.get(), 300, 0, false, false));
                env.getWorld().m_8878_();
            }
        }

        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast((RenderedSpell)this, (CastingEnvironment)env, (CastingImage)image);
        }

        @NotNull
        public final LivingEntity component1() {
            return this.target;
        }

        @NotNull
        public final Spell copy(@NotNull LivingEntity target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new Spell(target);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, LivingEntity livingEntity, int n, Object object) {
            if ((n & 1) != 0) {
                livingEntity = spell.target;
            }
            return spell.copy(livingEntity);
        }

        @NotNull
        public String toString() {
            return "Spell(target=" + this.target + ")";
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            return Intrinsics.areEqual((Object)this.target, (Object)spell.target);
        }
    }
}

