/*
 * Decompiled with CFR 0.152.
 */
package robotgiggle.hierophantics.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import robotgiggle.hierophantics.data.HieroServerState;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001d\u00a8\u0006 "}, d2={"Lrobotgiggle/hierophantics/data/MindNamer;", "", "<init>", "()V", "", "generateNumberOfSyllables", "()I", "Lnet/minecraft/server/MinecraftServer;", "server", "", "generateRandomName", "(Lnet/minecraft/server/MinecraftServer;)Ljava/lang/String;", "", "wasNasal", "generateSyllable", "(Z)Ljava/lang/String;", "number", "numToRoman", "(I)Ljava/lang/String;", "baseName", "processCustomName", "(Lnet/minecraft/server/MinecraftServer;Ljava/lang/String;)Ljava/lang/String;", "", "consonants", "[C", "peak", "I", "", "scanned", "Ljava/util/List;", "vowels", "weights", "hierophantics-common"})
@SourceDebugExtension(value={"SMAP\nMindNamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MindNamer.kt\nrobotgiggle/hierophantics/data/MindNamer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n350#2,7:80\n2847#2,3:87\n2850#2,6:91\n1#3:90\n*S KotlinDebug\n*F\n+ 1 MindNamer.kt\nrobotgiggle/hierophantics/data/MindNamer\n*L\n35#1:80,7\n14#1:87,3\n14#1:91,6\n14#1:90\n*E\n"})
public final class MindNamer {
    @NotNull
    public static final MindNamer INSTANCE;
    @NotNull
    private static final char[] consonants;
    @NotNull
    private static final char[] vowels;
    @NotNull
    private static final List<Integer> weights;
    @NotNull
    private static final List<Integer> scanned;
    private static final int peak;

    private MindNamer() {
    }

    @NotNull
    public final String generateRandomName(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        HieroServerState sState = HieroServerState.Companion.getServerState(server);
        String name = null;
        do {
            StringBuilder word = new StringBuilder();
            int numberOfSyllables = this.generateNumberOfSyllables();
            int n = 0;
            while (n < numberOfSyllables) {
                int it = n++;
                boolean bl = false;
                String syllable = INSTANCE.generateSyllable(StringsKt.endsWith$default((CharSequence)word, (char)'n', (boolean)false, (int)2, null));
                word.append(syllable);
            }
            String string = word.substring(0, 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            word.replace(0, 1, string2);
            Intrinsics.checkNotNullExpressionValue((Object)word.toString(), (String)"toString(...)");
        } while (sState.nameUsed(name));
        return name;
    }

    private final int generateNumberOfSyllables() {
        int n;
        block2: {
            int index = Random.Default.nextInt(1, peak + 1);
            List<Integer> $this$indexOfFirst$iv = scanned;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Integer item$iv : $this$indexOfFirst$iv) {
                int it = ((Number)item$iv).intValue();
                boolean bl = false;
                if (index <= it) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n + 1;
    }

    private final String generateSyllable(boolean wasNasal) {
        char consonant = ArraysKt.random((char[])consonants, (Random)((Random)Random.Default));
        char vowel = ArraysKt.random((char[])vowels, (Random)((Random)Random.Default));
        String syllable = "" + consonant + vowel;
        while (wasNasal && (consonant == 'm' || consonant == 'n')) {
            consonant = ArraysKt.random((char[])consonants, (Random)((Random)Random.Default));
            vowel = ArraysKt.random((char[])vowels, (Random)((Random)Random.Default));
            syllable = "" + consonant + vowel;
        }
        if (Random.Default.nextBoolean() && !StringsKt.startsWith$default((CharSequence)syllable, (char)'n', (boolean)false, (int)2, null)) {
            syllable = syllable + "n";
        }
        return syllable;
    }

    @NotNull
    public final String processCustomName(@NotNull MinecraftServer server, @NotNull String baseName) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        HieroServerState sState = HieroServerState.Companion.getServerState(server);
        Object name = baseName;
        int suffix = 2;
        while (sState.nameUsed((String)name)) {
            name = baseName + " " + this.numToRoman(suffix);
            ++suffix;
        }
        return name;
    }

    private final String numToRoman(int number) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.repeat((CharSequence)"I", (int)number), (String)"IIIII", (String)"V", (boolean)false, (int)4, null), (String)"IIII", (String)"IV", (boolean)false, (int)4, null), (String)"VV", (String)"X", (boolean)false, (int)4, null), (String)"VIV", (String)"IX", (boolean)false, (int)4, null), (String)"XXXXX", (String)"L", (boolean)false, (int)4, null), (String)"XXXX", (String)"XL", (boolean)false, (int)4, null), (String)"LL", (String)"C", (boolean)false, (int)4, null), (String)"LXL", (String)"XC", (boolean)false, (int)4, null), (String)"CCCCC", (String)"D", (boolean)false, (int)4, null), (String)"CCCC", (String)"CD", (boolean)false, (int)4, null), (String)"DD", (String)"M", (boolean)false, (int)4, null), (String)"DCD", (String)"CM", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        List list2;
        void $this$runningFold$iv;
        INSTANCE = new MindNamer();
        Object object = new char[]{'b', 'k', 'l', 'm', 'n', 'p', 'r', 't', 'd', 'f'};
        consonants = object;
        object = new char[]{'a', 'e', 'i', 'o', 'u'};
        vowels = object;
        object = new Integer[3];
        object[0] = (char)0;
        object[1] = (char)5;
        object[2] = (char)3;
        weights = CollectionsKt.listOf((Object[])object);
        object = weights;
        Integer initial$iv = 0;
        boolean $i$f$runningFold = false;
        int estimatedSize$iv = CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningFold$iv, (int)9);
        if (estimatedSize$iv == 0) {
            list2 = CollectionsKt.listOf((Object)initial$iv);
        } else {
            ArrayList<Integer> arrayList;
            ArrayList<Integer> $this$runningFold_u24lambda_u2418$iv = arrayList = new ArrayList<Integer>(estimatedSize$iv + 1);
            boolean bl = false;
            $this$runningFold_u24lambda_u2418$iv.add(initial$iv);
            ArrayList<Integer> result$iv = arrayList;
            Integer accumulator$iv = initial$iv;
            for (Object element$iv : $this$runningFold$iv) {
                void weight;
                int n = ((Number)element$iv).intValue();
                int sum = ((Number)accumulator$iv).intValue();
                boolean bl2 = false;
                accumulator$iv = sum + weight;
                result$iv.add(accumulator$iv);
            }
            list2 = result$iv;
        }
        scanned = CollectionsKt.drop((Iterable)list2, (int)1);
        peak = ((Number)CollectionsKt.last(scanned)).intValue();
    }
}

