/*
 * Decompiled with CFR 0.152.
 */
package robotgiggle.hierophantics.mixin;

import at.petrak.hexcasting.api.casting.iota.EntityIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import robotgiggle.hierophantics.blocks.FlayBedBlock;
import robotgiggle.hierophantics.data.HieroPlayerState;
import robotgiggle.hierophantics.data.HieroServerState;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657 {
    ServerPlayerEntityMixin(class_1937 world, class_2338 blockPos, float f, GameProfile gameProfile) {
        super(world, blockPos, f, gameProfile);
    }

    @Inject(method={"dropItem"}, at={@At(value="TAIL")})
    private void fireDropTriggers(class_1799 itemStack, boolean throwRandomly, boolean retainOwnership, CallbackInfoReturnable<class_1799> ci, @Local class_1542 droppedEntity) {
        if (!throwRandomly && retainOwnership) {
            class_3222 player = (class_3222)this;
            HieroServerState.getPlayerState((class_1657)player).triggerMinds(player, "drop", (Iota)new EntityIota((class_1297)droppedEntity));
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void checkThresholdTriggers(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        HieroServerState.getPlayerState((class_1657)player).tick(player);
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void disableMindsOnDeath(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        HieroPlayerState state = HieroServerState.getPlayerState((class_1657)player);
        if (state.getOwnedMinds() > 0) {
            state.setDisabled(true);
            state.setSkipTeleTrigger(5);
        }
    }

    @Inject(method={"worldChanged"}, at={@At(value="HEAD")})
    private void skipTeleTriggerWhenChangingDims(CallbackInfo ci) {
        this.skipTeleTrigger();
    }

    @Inject(method={"startRiding"}, at={@At(value="RETURN")})
    private void skipTeleTriggerWhenMountingEntity(CallbackInfoReturnable<Boolean> ci) {
        if (((Boolean)ci.getReturnValue()).booleanValue()) {
            this.skipTeleTrigger();
        }
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD")})
    private void skipTeleTriggerWhenDismountingEntity(CallbackInfo ci) {
        this.skipTeleTrigger();
    }

    @Inject(method={"sleep"}, at={@At(value="HEAD")})
    private void skipTeleTriggerWhenGettingIntoBed(CallbackInfo ci) {
        this.skipTeleTrigger();
    }

    @Inject(method={"wakeUp"}, at={@At(value="HEAD")})
    private void skipTeleTriggerWhenGettingOutOfBed(CallbackInfo ci) {
        this.skipTeleTrigger();
    }

    private void skipTeleTrigger() {
        class_3222 player = (class_3222)this;
        HieroPlayerState state = HieroServerState.getPlayerState((class_1657)player);
        if (state.getOwnedMinds() > 0) {
            state.setSkipTeleTrigger(5);
        }
    }

    @Inject(method={"trySleep"}, at={@At(value="HEAD")}, cancellable=true)
    private void trySleepInFlayBed(class_2338 blockPos, CallbackInfoReturnable<Either<class_1657.class_1658, class_3902>> ci) {
        class_3222 player = (class_3222)this;
        class_2248 block = player.method_37908().method_8320(blockPos).method_26204();
        if (block instanceof FlayBedBlock) {
            ci.setReturnValue(this.trimmedTrySleep(player, blockPos));
        }
    }

    @Shadow
    private boolean method_26285(class_2338 blockPos, class_2350 direction) {
        return false;
    }

    @Shadow
    private boolean method_26286(class_2338 blockPos, class_2350 direction) {
        return false;
    }

    private Either<class_1657.class_1658, class_3902> trimmedTrySleep(class_3222 player, class_2338 blockPos) {
        class_2350 direction = (class_2350)player.method_37908().method_8320(blockPos).method_11654((class_2769)class_2383.field_11177);
        if (player.method_6113() || !player.method_5805()) {
            return Either.left((Object)class_1657.class_1658.field_7531);
        }
        if (!this.method_26285(blockPos, direction)) {
            return Either.left((Object)class_1657.class_1658.field_7530);
        }
        if (this.method_26286(blockPos, direction)) {
            return Either.left((Object)class_1657.class_1658.field_18592);
        }
        return super.method_7269(blockPos);
    }
}

