/*
 * Decompiled with CFR 0.152.
 */
package robotgiggle.hierophantics.patterns;

import at.petrak.hexcasting.api.casting.castables.ConstMediaAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.ListIota;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import robotgiggle.hierophantics.data.HieroPlayerState;
import robotgiggle.hierophantics.data.HieroServerState;
import robotgiggle.hierophantics.iotas.MindReferenceIota;
import robotgiggle.hierophantics.iotas.MindReferenceIotaKt;
import robotgiggle.hierophantics.mishaps.MindFreedMishap;
import robotgiggle.hierophantics.mishaps.MindsDisabledMishap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\u00020\u000b8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lrobotgiggle/hierophantics/patterns/OpGetMindHex;", "Lat/petrak/hexcasting/api/casting/castables/ConstMediaAction;", "<init>", "()V", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "args", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "execute", "(Ljava/util/List;Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Ljava/util/List;", "", "argc", "I", "getArgc", "()I", "hierophantics-common"})
public final class OpGetMindHex
implements ConstMediaAction {
    private final int argc;

    public OpGetMindHex() {
        this.argc = 1;
    }

    public int getArgc() {
        return this.argc;
    }

    @NotNull
    public List<Iota> execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        MindReferenceIota mindRef = MindReferenceIotaKt.getMindReference(args, 0, this.getArgc());
        HieroPlayerState state = HieroServerState.Companion.getPlayerState(mindRef.getHost());
        if (!state.hasMind(mindRef.getName())) {
            throw new MindFreedMishap();
        }
        if (state.getDisabled()) {
            throw new MindsDisabledMishap("read", Intrinsics.areEqual((Object)mindRef.getHost(), (Object)env.getCastingEntity()));
        }
        Iota storedHex = IotaType.deserialize((class_2487)state.getMind(mindRef.getName()).getHex(), (class_3218)env.getWorld());
        if (storedHex instanceof ListIota) {
            return CollectionsKt.listOf((Object)storedHex);
        }
        return CollectionsKt.listOf((Object)new NullIota());
    }

    public long getMediaCost() {
        return ConstMediaAction.DefaultImpls.getMediaCost((ConstMediaAction)this);
    }

    @NotNull
    public ConstMediaAction.CostMediaActionResult executeWithOpCount(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        return ConstMediaAction.DefaultImpls.executeWithOpCount((ConstMediaAction)this, args, (CastingEnvironment)env);
    }

    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return ConstMediaAction.DefaultImpls.operate((ConstMediaAction)this, (CastingEnvironment)env, (CastingImage)image, (SpellContinuation)continuation);
    }
}

