/*
 * Decompiled with CFR 0.152.
 */
package robotgiggle.hierophantics.patterns;

import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import robotgiggle.hierophantics.data.HieroMind;
import robotgiggle.hierophantics.data.HieroPlayerState;
import robotgiggle.hierophantics.data.HieroServerState;
import robotgiggle.hierophantics.inits.HierophanticsAdvancements;
import robotgiggle.hierophantics.iotas.MindReferenceIota;
import robotgiggle.hierophantics.iotas.MindReferenceIotaKt;
import robotgiggle.hierophantics.iotas.TriggerIota;
import robotgiggle.hierophantics.iotas.TriggerIotaKt;
import robotgiggle.hierophantics.mishaps.MindFreedMishap;
import robotgiggle.hierophantics.mishaps.MindsDisabledMishap;
import robotgiggle.hierophantics.mishaps.NotYourMindMishap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\u00020\f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lrobotgiggle/hierophantics/patterns/OpSetMindTrigger;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "<init>", "()V", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "args", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "execute", "(Ljava/util/List;Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "", "argc", "I", "getArgc", "()I", "Spell", "hierophantics-common"})
public final class OpSetMindTrigger
implements SpellAction {
    private final int argc;

    public OpSetMindTrigger() {
        this.argc = 2;
    }

    public int getArgc() {
        return this.argc;
    }

    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        class_1309 caster = env.getCastingEntity();
        MindReferenceIota mindRef = MindReferenceIotaKt.getMindReference(args, 0, this.getArgc());
        if (caster == null || !(caster instanceof class_3222) || !Intrinsics.areEqual((Object)mindRef.getHost(), (Object)caster)) {
            throw new NotYourMindMishap();
        }
        HieroPlayerState state = HieroServerState.Companion.getPlayerState((class_1657)caster);
        if (!state.hasMind(mindRef.getName())) {
            throw new MindFreedMishap();
        }
        if (state.getDisabled()) {
            throw new MindsDisabledMishap("write", false, 2, null);
        }
        if (!(args.get(1) instanceof NullIota)) {
            TriggerIotaKt.getTrigger(args, 1, this.getArgc());
        }
        return new SpellAction.Result((RenderedSpell)new Spell(state, mindRef.getName(), args.get(1), (class_3222)caster), 50000L, CollectionsKt.emptyList(), 0L, 8, null);
    }

    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata((SpellAction)this, args, (CastingEnvironment)env, (class_2487)userData);
    }

    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate((SpellAction)this, (CastingEnvironment)env, (CastingImage)image, (SpellContinuation)continuation);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J8\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010!\u001a\u00020 H\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010#\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b#\u0010\u0014R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010$\u001a\u0004\b%\u0010\u0018R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010&\u001a\u0004\b'\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010(\u001a\u0004\b)\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010*\u001a\u0004\b+\u0010\u0016\u00a8\u0006,"}, d2={"Lrobotgiggle/hierophantics/patterns/OpSetMindTrigger$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "Lrobotgiggle/hierophantics/data/HieroPlayerState;", "state", "", "mindName", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "triggerOrNull", "Lnet/minecraft/class_3222;", "caster", "<init>", "(Lrobotgiggle/hierophantics/data/HieroPlayerState;Ljava/lang/String;Lat/petrak/hexcasting/api/casting/iota/Iota;Lnet/minecraft/class_3222;)V", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "", "cast", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)V", "component1", "()Lrobotgiggle/hierophantics/data/HieroPlayerState;", "component2", "()Ljava/lang/String;", "component3", "()Lat/petrak/hexcasting/api/casting/iota/Iota;", "component4", "()Lnet/minecraft/class_3222;", "copy", "(Lrobotgiggle/hierophantics/data/HieroPlayerState;Ljava/lang/String;Lat/petrak/hexcasting/api/casting/iota/Iota;Lnet/minecraft/class_3222;)Lrobotgiggle/hierophantics/patterns/OpSetMindTrigger$Spell;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Lnet/minecraft/class_3222;", "getCaster", "Ljava/lang/String;", "getMindName", "Lrobotgiggle/hierophantics/data/HieroPlayerState;", "getState", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "getTriggerOrNull", "hierophantics-common"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final HieroPlayerState state;
        @NotNull
        private final String mindName;
        @NotNull
        private final Iota triggerOrNull;
        @NotNull
        private final class_3222 caster;

        public Spell(@NotNull HieroPlayerState state, @NotNull String mindName, @NotNull Iota triggerOrNull, @NotNull class_3222 caster) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)mindName, (String)"mindName");
            Intrinsics.checkNotNullParameter((Object)triggerOrNull, (String)"triggerOrNull");
            Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
            this.state = state;
            this.mindName = mindName;
            this.triggerOrNull = triggerOrNull;
            this.caster = caster;
        }

        @NotNull
        public final HieroPlayerState getState() {
            return this.state;
        }

        @NotNull
        public final String getMindName() {
            return this.mindName;
        }

        @NotNull
        public final Iota getTriggerOrNull() {
            return this.triggerOrNull;
        }

        @NotNull
        public final class_3222 getCaster() {
            return this.caster;
        }

        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            HieroMind mind = this.state.getMind(this.mindName);
            if (this.triggerOrNull instanceof NullIota) {
                mind.setTrigger(TriggerIota.Trigger.Companion.none());
            } else {
                Iota iota = this.triggerOrNull;
                Intrinsics.checkNotNull((Object)iota, (String)"null cannot be cast to non-null type robotgiggle.hierophantics.iotas.TriggerIota");
                TriggerIota triggerIota = (TriggerIota)iota;
                mind.setTrigger(triggerIota.getTrigger());
                if (this.state.allTriggersUsed()) {
                    HierophanticsAdvancements.INSTANCE.getALL_TRIGGERS().trigger(this.caster);
                }
            }
        }

        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast((RenderedSpell)this, (CastingEnvironment)env, (CastingImage)image);
        }

        @NotNull
        public final HieroPlayerState component1() {
            return this.state;
        }

        @NotNull
        public final String component2() {
            return this.mindName;
        }

        @NotNull
        public final Iota component3() {
            return this.triggerOrNull;
        }

        @NotNull
        public final class_3222 component4() {
            return this.caster;
        }

        @NotNull
        public final Spell copy(@NotNull HieroPlayerState state, @NotNull String mindName, @NotNull Iota triggerOrNull, @NotNull class_3222 caster) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)mindName, (String)"mindName");
            Intrinsics.checkNotNullParameter((Object)triggerOrNull, (String)"triggerOrNull");
            Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
            return new Spell(state, mindName, triggerOrNull, caster);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, HieroPlayerState hieroPlayerState, String string, Iota iota, class_3222 class_32222, int n, Object object) {
            if ((n & 1) != 0) {
                hieroPlayerState = spell.state;
            }
            if ((n & 2) != 0) {
                string = spell.mindName;
            }
            if ((n & 4) != 0) {
                iota = spell.triggerOrNull;
            }
            if ((n & 8) != 0) {
                class_32222 = spell.caster;
            }
            return spell.copy(hieroPlayerState, string, iota, class_32222);
        }

        @NotNull
        public String toString() {
            return "Spell(state=" + this.state + ", mindName=" + this.mindName + ", triggerOrNull=" + this.triggerOrNull + ", caster=" + this.caster + ")";
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = result * 31 + this.mindName.hashCode();
            result = result * 31 + this.triggerOrNull.hashCode();
            result = result * 31 + this.caster.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.state, (Object)spell.state)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mindName, (Object)spell.mindName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.triggerOrNull, (Object)spell.triggerOrNull)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.caster, (Object)spell.caster);
        }
    }
}

