/*
 * Decompiled with CFR 0.152.
 */
package com.lukarbonite.autopickup;

import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public final class AutoPickupSessions {
    private static final ConcurrentHashMap<Integer, Session> SESSIONS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, ArrayDeque<DropGuard>> DROP_GUARDS = new ConcurrentHashMap();
    private static final int MAX_RECENT_POSITIONS = 64;
    private static final double INTERCEPT_RADIUS2 = 36.0;
    private static final double DROP_CONTEXT_RADIUS2 = 9.0;
    private static final double LINK_RADIUS2 = 36.0;
    private static final int SESSION_TTL_TICKS = 8;
    private static int CURRENT_TICK = 0;
    private static final ThreadLocal<ArrayDeque<Integer>> OPEN_LINKED_CONTEXT = ThreadLocal.withInitial(ArrayDeque::new);
    private static final double SAME_TICK_RADIUS2 = 2.25;

    private AutoPickupSessions() {
    }

    public static void begin(class_1657 player) {
        if (player == null) {
            return;
        }
        SESSIONS.computeIfAbsent(player.method_5628(), id -> new Session(player)).touch();
    }

    public static void addBreak(class_1657 player, class_2338 pos) {
        if (player == null || pos == null) {
            return;
        }
        Session s = SESSIONS.computeIfAbsent(player.method_5628(), id -> new Session(player));
        s.touch();
        s.addPos(pos);
    }

    public static void beginDropContext(class_1657 player, class_2338 pos) {
        if (player == null || pos == null) {
            return;
        }
        ArrayDeque stack = DROP_GUARDS.computeIfAbsent(player.method_5628(), id -> new ArrayDeque());
        stack.push(new DropGuard(pos));
    }

    public static void endDropContext(class_1657 player) {
        if (player == null) {
            return;
        }
        ArrayDeque<DropGuard> stack = DROP_GUARDS.get(player.method_5628());
        if (stack != null && !stack.isEmpty()) {
            stack.pop();
        }
    }

    public static class_1657 findOwner(class_243 spawnPos) {
        class_1657 best = null;
        double bestD2 = Double.MAX_VALUE;
        for (Map.Entry<Integer, Session> e : SESSIONS.entrySet()) {
            double d2;
            Session s = e.getValue();
            class_1657 p = (class_1657)s.playerRef.get();
            if (p == null || p.method_7325() || !((d2 = s.minDist2(spawnPos)) <= 36.0) || !(d2 < bestD2)) continue;
            bestD2 = d2;
            best = p;
        }
        return best;
    }

    public static class_1657 findOwnerInDropContext(class_243 spawnPos) {
        class_1657 best = null;
        double bestD2 = Double.MAX_VALUE;
        for (Map.Entry<Integer, ArrayDeque<DropGuard>> e : DROP_GUARDS.entrySet()) {
            double dz;
            double dy;
            double dx;
            double d2;
            DropGuard g;
            class_1657 p;
            Session s;
            ArrayDeque<DropGuard> stack = e.getValue();
            if (stack == null || stack.isEmpty() || (s = SESSIONS.get(e.getKey())) == null || (p = (class_1657)s.playerRef.get()) == null || p.method_7325() || (g = stack.peek()) == null || !((d2 = (dx = spawnPos.field_1352 - ((double)g.origin.method_10263() + 0.5)) * dx + (dy = spawnPos.field_1351 - ((double)g.origin.method_10264() + 0.5)) * dy + (dz = spawnPos.field_1350 - ((double)g.origin.method_10260() + 0.5)) * dz) <= 9.0) || !(d2 < bestD2)) continue;
            bestD2 = d2;
            best = p;
        }
        return best;
    }

    public static class_1657 findLinkedOwnerForBreak(class_2338 pos) {
        class_243 center = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        class_1657 best = null;
        double bestD2 = Double.MAX_VALUE;
        for (Map.Entry<Integer, Session> e : SESSIONS.entrySet()) {
            double d2;
            Session s = e.getValue();
            class_1657 p = (class_1657)s.playerRef.get();
            if (p == null || p.method_7325() || !((d2 = s.minDist2(center)) <= 36.0) || !(d2 < bestD2)) continue;
            bestD2 = d2;
            best = p;
        }
        return best;
    }

    public static void openLinkedDropContext(class_2338 pos) {
        class_1657 owner = AutoPickupSessions.findLinkedOwnerForBreak(pos);
        if (owner != null) {
            AutoPickupSessions.beginDropContext(owner, pos);
            OPEN_LINKED_CONTEXT.get().push(owner.method_5628());
        } else {
            OPEN_LINKED_CONTEXT.get().push(-1);
        }
    }

    public static void closeLinkedDropContext() {
        ArrayDeque<Integer> stack = OPEN_LINKED_CONTEXT.get();
        if (stack.isEmpty()) {
            return;
        }
        int id = stack.pop();
        if (id >= 0) {
            class_1657 p;
            Session s = SESSIONS.get(id);
            class_1657 class_16572 = p = s != null ? (class_1657)s.playerRef.get() : null;
            if (p != null) {
                AutoPickupSessions.endDropContext(p);
            }
        }
    }

    public static class_1657 findOwnerSameTickTight(class_243 spawnPos) {
        class_1657 best = null;
        double bestD2 = Double.MAX_VALUE;
        for (Map.Entry<Integer, Session> e : SESSIONS.entrySet()) {
            Session s = e.getValue();
            class_1657 p = (class_1657)s.playerRef.get();
            if (p == null || p.method_7325() || s.recent.isEmpty() || s.lastTouchedTick != CURRENT_TICK) continue;
            double sx = spawnPos.field_1352;
            double sy = spawnPos.field_1351;
            double sz = spawnPos.field_1350;
            Iterator<class_2338> itPos = s.recent.descendingIterator();
            for (int checked = 0; itPos.hasNext() && checked < 6; ++checked) {
                double dz;
                double dy;
                class_2338 b = itPos.next();
                double dx = sx - ((double)b.method_10263() + 0.5);
                double d2 = dx * dx + (dy = sy - ((double)b.method_10264() + 0.5)) * dy + (dz = sz - ((double)b.method_10260() + 0.5)) * dz;
                if (!(d2 <= 2.25) || !(d2 < bestD2)) continue;
                bestD2 = d2;
                best = p;
            }
        }
        return best;
    }

    public static void onServerTickEnd() {
        ++CURRENT_TICK;
        if (SESSIONS.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Integer, Session>> it = SESSIONS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Session> e = it.next();
            Session s = e.getValue();
            Integer id = e.getKey();
            if (s.playerRef.get() == null) {
                it.remove();
                DROP_GUARDS.remove(id);
                continue;
            }
            --s.ticksToLive;
            if (s.ticksToLive > 0) continue;
            it.remove();
            DROP_GUARDS.remove(id);
        }
    }

    private static final class Session {
        final WeakReference<class_1657> playerRef;
        final ArrayDeque<class_2338> recent = new ArrayDeque();
        int ticksToLive = 8;
        int lastTouchedTick = 0;

        Session(class_1657 p) {
            this.playerRef = new WeakReference<class_1657>(p);
        }

        void touch() {
            this.ticksToLive = 8;
            this.lastTouchedTick = CURRENT_TICK;
        }

        void addPos(class_2338 pos) {
            this.recent.addLast(pos.method_10062());
            while (this.recent.size() > 64) {
                this.recent.removeFirst();
            }
        }

        double minDist2(class_243 v) {
            if (this.recent.isEmpty()) {
                return Double.MAX_VALUE;
            }
            double sx = v.field_1352;
            double sy = v.field_1351;
            double sz = v.field_1350;
            double best = Double.MAX_VALUE;
            for (class_2338 b : this.recent) {
                double dz;
                double dy;
                double dx = sx - ((double)b.method_10263() + 0.5);
                double d2 = dx * dx + (dy = sy - ((double)b.method_10264() + 0.5)) * dy + (dz = sz - ((double)b.method_10260() + 0.5)) * dz;
                if (!(d2 < best)) continue;
                best = d2;
            }
            return best;
        }
    }

    private static final class DropGuard {
        final class_2338 origin;

        DropGuard(class_2338 origin) {
            this.origin = origin.method_10062();
        }
    }
}

