/*
 * Decompiled with CFR 0.152.
 */
package com.lukarbonite.autopickup;

import com.lukarbonite.autopickup.AutoPickupApi;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class ExperienceCache {
    private static final ConcurrentHashMap<UUID, PlayerExperience> activeSessions = new ConcurrentHashMap();

    public static void add(class_1657 player, int experience) {
        PlayerExperience session = activeSessions.computeIfAbsent(player.method_5667(), k -> new PlayerExperience());
        session.addExperience(experience);
    }

    public static void onServerTick(MinecraftServer server) {
        if (activeSessions.isEmpty()) {
            return;
        }
        activeSessions.forEach((uuid, session) -> {
            --session.ticksUntilFinalize;
            if (session.ticksUntilFinalize <= 0) {
                activeSessions.remove(uuid);
                class_3222 player = server.method_3760().method_14602(uuid);
                if (player != null && session.experience > 0) {
                    AutoPickupApi.tryPickupExperience((class_1657)player, session.experience);
                }
            }
        });
    }

    private static class PlayerExperience {
        int experience = 0;
        int ticksUntilFinalize = 2;

        private PlayerExperience() {
        }

        void addExperience(int amount) {
            this.experience += amount;
            this.ticksUntilFinalize = 2;
        }
    }
}

