/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.wac.client.render.block;

import com.blamejared.wac.block.entity.DeepslateBasinBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;

public class DeepslateBasinRenderer
implements BlockEntityRenderer<DeepslateBasinBlockEntity> {
    private final ItemRenderer itemRenderer;

    public DeepslateBasinRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(DeepslateBasinBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float yOffset = ((float)blockEntity.getLevel().getGameTime() + partialTick) / 64.0f;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        BlockPos pos = blockEntity.getBlockPos();
        PerlinNoise perlinNoise = PerlinNoise.create((RandomSource)new LegacyRandomSource(2906L), (IntStream)IntStream.range(0, 1));
        if (!blockEntity.isEmpty()) {
            for (int i = 0; i < blockEntity.items().size(); ++i) {
                double value = perlinNoise.getValue((double)(pos.getX() + i), (double)yOffset, (double)(pos.getZ() + i)) * 0.5;
                poseStack.translate((double)(0.5f * (float)(i % 3)), value, 0.5 * Math.floor((float)i / 3.0f));
                float rotation = (float)(Math.round(value * 360.0) + blockEntity.getLevel().getGameTime()) + partialTick;
                poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
                ItemStack item = blockEntity.getItem(i);
                this.itemRenderer.renderStatic(item, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, blockEntity.getLevel(), i);
                poseStack.mulPose(Axis.YP.rotationDegrees(-rotation));
                poseStack.translate((double)(-0.5f * (float)(i % 3)), -value, -0.5 * Math.floor((float)i / 3.0f));
            }
        }
        poseStack.popPose();
    }
}

