/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.wac.block;

import com.blamejared.wac.block.entity.MossyPodiumBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MossyPodiumBlock
extends BaseEntityBlock {
    public static final MapCodec<MossyPodiumBlock> CODEC = MossyPodiumBlock.simpleCodec(MossyPodiumBlock::new);
    public static final VoxelShape SHAPE_BASE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);
    public static final VoxelShape SHAPE_POST = Block.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    public static final VoxelShape SHAPE_TOP = Block.box((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    public static final VoxelShape SHAPE_STAND = Block.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0);
    public static final VoxelShape SHAPE_COMMON = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_POST, SHAPE_TOP, SHAPE_STAND});
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public MapCodec<MossyPodiumBlock> codec() {
        return CODEC;
    }

    public MossyPodiumBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.DEEPSLATE).strength(2.5f).sound(SoundType.STONE));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_COMMON;
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return SHAPE_COMMON;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_COMMON;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MossyPodiumBlockEntity(pos, state);
    }
}

