/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.wac.client;

import com.blamejared.wac.Util;
import com.blamejared.wac.block.entity.WACBlockEntityTypes;
import com.blamejared.wac.client.render.block.DeepslateBasinRenderer;
import com.blamejared.wac.client.render.block.MossyPodiumRenderer;
import com.blamejared.wac.client.render.shader.WACRenderTypes;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ClientEvents {
    public static void registerShaders(ResourceProvider resourceManager, BiConsumer<ShaderInstance, Consumer<ShaderInstance>> registerFunc) {
        try {
            for (WACRenderTypes.ShaderRenderType type : WACRenderTypes.getRenderTypes().values()) {
                type.register(resourceManager, registerFunc);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends BlockEntity> void registerEntityRenderers(BiConsumer<BlockEntityType<T>, BlockEntityRendererProvider<T>> registrar) {
        registrar.accept(WACBlockEntityTypes.MOSSY_PODIUM.get(), context -> (BlockEntityRenderer)Util.uncheck(new MossyPodiumRenderer(context)));
        registrar.accept(WACBlockEntityTypes.DEEPSLATE_BASIN.get(), context -> (BlockEntityRenderer)Util.uncheck(new DeepslateBasinRenderer(context)));
    }
}

