/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.wac.compat.jei;

import com.blamejared.wac.compat.jei.WACJEIPlugin;
import com.blamejared.wac.item.WACItems;
import com.blamejared.wac.recipe.ritual.Ritual;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RitualCategory
implements IRecipeCategory<Ritual> {
    private static final ResourceLocation EFFECT_BACKGROUND_SMALL_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/inventory/effect_background_small");
    private final Component title = Component.translatable((String)"gui.jei.category.wac.ritual");
    private final IDrawable icon;
    private final IDrawableStatic background;
    private final IDrawableStatic blankSlot;
    private final ICraftingGridHelper craftingGridHelper;
    private final IGuiHelper guiHelper;
    private final Minecraft mc;

    public RitualCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(WACItems.DEEPSLATE_BASIN.get().getDefaultInstance());
        this.background = guiHelper.createBlankDrawable(116, 80);
        this.blankSlot = guiHelper.getSlotDrawable();
        this.craftingGridHelper = guiHelper.createCraftingGridHelper();
        this.guiHelper = guiHelper;
        this.mc = Minecraft.getInstance();
    }

    @NotNull
    public RecipeType<Ritual> getRecipeType() {
        return WACJEIPlugin.RITUAL;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull Ritual recipe, @NotNull IFocusGroup focuses) {
        this.craftingGridHelper.createAndSetIngredients(builder, recipe.ingredients(), 3, 3);
        builder.setShapeless();
    }

    public void draw(@NotNull Ritual recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        graphics.drawCenteredString(this.mc.font, (Component)Component.translatable((String)"gui.jei.category.wac.enchantment_power", (Object[])new Object[]{recipe.requiredEnchantingPower()}), 58, 70, -1);
        IDrawableStatic recipeArrow = this.guiHelper.getRecipeArrow();
        recipeArrow.draw(graphics, 58, (54 - recipeArrow.getHeight()) / 2);
        graphics.blitSprite(EFFECT_BACKGROUND_SMALL_SPRITE, 83, 13, 32, 32);
        MobEffectTextureManager mobeffecttexturemanager = this.mc.getMobEffectTextures();
        Holder holder = recipe.output().getEffect();
        TextureAtlasSprite textureatlassprite = mobeffecttexturemanager.get(holder);
        graphics.blit(89, 20, 0, 18, 18, textureatlassprite);
        if (mouseX > 83.0 && mouseX < 101.0 && mouseY > 13.0 && mouseY < 31.0) {
            List<Component> list = List.of(this.getEffectName(recipe.output()), MobEffectUtil.formatDuration((MobEffectInstance)recipe.output(), (float)1.0f, (float)this.mc.level.tickRateManager().tickrate()));
            graphics.renderTooltip(this.mc.font, list, Optional.empty(), (int)mouseX, (int)mouseY);
        }
    }

    private Component getEffectName(MobEffectInstance effect) {
        MutableComponent mutablecomponent = ((MobEffect)effect.getEffect().value()).getDisplayName().copy();
        if (effect.getAmplifier() >= 1 && effect.getAmplifier() <= 9) {
            mutablecomponent.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + (effect.getAmplifier() + 1))));
        }
        return mutablecomponent;
    }
}

