/*
 * Decompiled with CFR 0.152.
 */
package com.example.mixin.client;

import com.example.TemplateModClient;
import java.util.Queue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2394;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_702.class})
public class ParticleManagerMixin {
    @Shadow
    private Queue<class_703>[] particles;

    @Inject(method={"addParticle(Lnet/minecraft/particle/ParticleEffect;DDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="HEAD")}, cancellable=true)
    private void veltiumOptimizeParticleCreation(class_2394 parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ, CallbackInfoReturnable<class_703> cir) {
        int maxParticles;
        int currentParticleCount = this.veltiumGetCurrentParticleCount();
        if (currentParticleCount >= (maxParticles = TemplateModClient.config.getEffectiveParticleLimit())) {
            cir.setReturnValue(null);
            return;
        }
        if (TemplateModClient.config.optimizeRendering && (double)currentParticleCount > (double)maxParticles * 0.8 && Math.random() < 0.3) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void veltiumOptimizeParticleTick(CallbackInfo ci) {
        int maxParticles;
        int currentParticleCount;
        if (!TemplateModClient.config.reduceLag || (double)(currentParticleCount = this.veltiumGetCurrentParticleCount()) > (double)(maxParticles = TemplateModClient.config.getEffectiveParticleLimit()) * 0.9) {
            // empty if block
        }
    }

    private int veltiumGetCurrentParticleCount() {
        if (this.particles == null) {
            return 0;
        }
        int count = 0;
        for (Queue<class_703> queue : this.particles) {
            if (queue == null) continue;
            count += queue.size();
        }
        return count;
    }
}

