/*
 * Decompiled with CFR 0.152.
 */
package com.example.render;

import com.example.config.YACLConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class ChunkOptimizer {
    private final YACLConfig config;
    private final Map<Long, ChunkData> chunkCache = new ConcurrentHashMap<Long, ChunkData>();
    private final Set<Long> emptyChunks = ConcurrentHashMap.newKeySet();
    private final Set<Long> culledChunks = ConcurrentHashMap.newKeySet();
    private final Map<Long, Integer> chunkPriority = new ConcurrentHashMap<Long, Integer>();
    private final Map<Long, Long> lastUpdateTime = new ConcurrentHashMap<Long, Long>();
    private final Map<Long, Integer> chunkLOD = new ConcurrentHashMap<Long, Integer>();
    private final int[] LOD_DISTANCES = new int[]{4, 8, 16, 24, 32};
    private final float[] LOD_DETAIL = new float[]{1.0f, 0.8f, 0.6f, 0.4f, 0.2f};
    private class_4184 lastCamera;
    private class_243 cameraPos;
    private class_243 cameraDirection;
    private final double fovRadians = Math.toRadians(70.0);
    private int totalChunks = 0;
    private int culledCount = 0;
    private int emptyCount = 0;
    private long lastCleanup = 0L;
    private long lastStatsUpdate = 0L;
    private int lastPlayerChunkX = Integer.MAX_VALUE;
    private int lastPlayerChunkZ = Integer.MAX_VALUE;

    public ChunkOptimizer(YACLConfig config) {
        this.config = config;
    }

    public void optimizeChunks(class_310 client) {
        if (!this.config.shouldOptimizeChunks() || client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        this.updateCamera(client);
        int playerChunkX = (int)client.field_1724.method_23317() >> 4;
        int playerChunkZ = (int)client.field_1724.method_23321() >> 4;
        if (playerChunkX != this.lastPlayerChunkX || playerChunkZ != this.lastPlayerChunkZ) {
            this.lastPlayerChunkX = playerChunkX;
            this.lastPlayerChunkZ = playerChunkZ;
            this.performChunkAnalysis(client.field_1687, playerChunkX, playerChunkZ, currentTime);
        }
        if (this.shouldUseFrustumCulling()) {
            this.performFrustumCulling(playerChunkX, playerChunkZ);
        }
        if (this.shouldUseOcclusionCulling() && currentTime % 3L == 0L) {
            this.performOcclusionCulling(client.field_1687, playerChunkX, playerChunkZ);
        }
        if (currentTime - this.lastCleanup > this.getCleanupInterval()) {
            this.cleanupCache(playerChunkX, playerChunkZ);
            this.lastCleanup = currentTime;
        }
        this.updateStatistics(currentTime);
    }

    private void updateCamera(class_310 client) {
        class_4184 camera = client.field_1773.method_19418();
        if (camera != this.lastCamera) {
            this.lastCamera = camera;
            this.cameraPos = camera.method_19326();
            float yaw = camera.method_19330();
            float pitch = camera.method_19329();
            double x = -Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
            double y = -Math.sin(Math.toRadians(pitch));
            double z = Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
            this.cameraDirection = new class_243(x, y, z).method_1029();
        }
    }

    private void performChunkAnalysis(class_638 world, int playerX, int playerZ, long currentTime) {
        int renderDistance = this.getRenderDistance();
        HashSet<Long> activeChunks = new HashSet<Long>();
        for (int x = playerX - renderDistance; x <= playerX + renderDistance; ++x) {
            for (int z = playerZ - renderDistance; z <= playerZ + renderDistance; ++z) {
                long chunkPos = class_1923.method_8331((int)x, (int)z);
                activeChunks.add(chunkPos);
                int distance = Math.max(Math.abs(x - playerX), Math.abs(z - playerZ));
                this.analyzeChunk(world, x, z, distance, currentTime);
            }
        }
        this.chunkCache.keySet().retainAll(activeChunks);
        this.emptyChunks.retainAll(activeChunks);
        this.culledChunks.retainAll(activeChunks);
        this.chunkPriority.keySet().retainAll(activeChunks);
        this.chunkLOD.keySet().retainAll(activeChunks);
        this.lastUpdateTime.keySet().retainAll(activeChunks);
        this.totalChunks = activeChunks.size();
    }

    private void analyzeChunk(class_638 world, int chunkX, int chunkZ, int distance, long currentTime) {
        long chunkPos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        Long lastUpdate = this.lastUpdateTime.get(chunkPos);
        int updateInterval = this.getUpdateInterval(distance);
        if (lastUpdate != null && currentTime - lastUpdate < (long)updateInterval) {
            return;
        }
        this.lastUpdateTime.put(chunkPos, currentTime);
        try {
            class_2818 chunk = world.method_8497(chunkX, chunkZ);
            if (chunk == null) {
                this.culledChunks.add(chunkPos);
                return;
            }
            ChunkData data = this.analyzeChunkData(chunk, world, distance);
            this.chunkCache.put(chunkPos, data);
            if (this.shouldUseLOD()) {
                int lodLevel = this.calculateLODLevel(distance);
                this.chunkLOD.put(chunkPos, lodLevel);
            }
            int priority = this.calculateChunkPriority(data, distance);
            this.chunkPriority.put(chunkPos, priority);
            float emptyThreshold = this.getEmptyChunkThreshold();
            if (data.isEmpty || data.airBlockPercentage > emptyThreshold) {
                this.emptyChunks.add(chunkPos);
            } else {
                this.emptyChunks.remove(chunkPos);
            }
        }
        catch (Exception e) {
            this.culledChunks.add(chunkPos);
        }
    }

    private ChunkData analyzeChunkData(class_2818 chunk, class_638 world, int distance) {
        ChunkData data = new ChunkData();
        data.isEmpty = chunk.method_12223();
        if (data.isEmpty) {
            data.airBlockPercentage = 100.0f;
            return data;
        }
        int baseSampleRate = this.getAnalysisSampleRate();
        int sampleRate = Math.max(1, baseSampleRate + distance / 4);
        int totalBlocks = 0;
        int airBlocks = 0;
        int solidBlocks = 0;
        int transparentBlocks = 0;
        int complexBlocks = 0;
        int minY = world.method_31607();
        int maxY = minY + world.method_31605();
        for (int y = minY; y < maxY; y += sampleRate * 2) {
            for (int x = 0; x < 16; x += sampleRate) {
                for (int z = 0; z < 16; z += sampleRate) {
                    class_2338 pos = new class_2338((chunk.method_12004().field_9181 << 4) + x, y, (chunk.method_12004().field_9180 << 4) + z);
                    class_2680 state = chunk.method_8320(pos);
                    ++totalBlocks;
                    if (state.method_26215()) {
                        ++airBlocks;
                    } else if (state.method_26225()) {
                        ++solidBlocks;
                    } else {
                        ++transparentBlocks;
                    }
                    if (!state.method_31709() && state.method_26204() != class_2246.field_10382 && state.method_26204() != class_2246.field_10164 && state.method_26220((class_1922)world, pos).method_1110()) continue;
                    ++complexBlocks;
                }
            }
        }
        if (totalBlocks > 0) {
            data.airBlockPercentage = (float)airBlocks * 100.0f / (float)totalBlocks;
            data.solidBlockPercentage = (float)solidBlocks * 100.0f / (float)totalBlocks;
            data.transparentBlockPercentage = (float)transparentBlocks * 100.0f / (float)totalBlocks;
            data.complexBlockPercentage = (float)complexBlocks * 100.0f / (float)totalBlocks;
        }
        if (this.shouldCountEntities() && distance <= this.getEntityCountDistance()) {
            data.entityCount = this.countEntities(world, chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        }
        data.lastAnalysis = System.currentTimeMillis();
        return data;
    }

    private int countEntities(class_638 world, int chunkX, int chunkZ) {
        int minY = world.method_31607();
        int maxY = minY + world.method_31605();
        class_238 chunkBox = new class_238((double)(chunkX * 16), (double)minY, (double)(chunkZ * 16), (double)(chunkX * 16 + 16), (double)maxY, (double)(chunkZ * 16 + 16));
        List entities = world.method_8335(null, chunkBox);
        return entities.size();
    }

    private void performFrustumCulling(int playerX, int playerZ) {
        if (this.cameraPos == null || this.cameraDirection == null) {
            return;
        }
        this.culledCount = 0;
        double fovExtension = this.getFrustumCullingFOV();
        for (Map.Entry<Long, ChunkData> entry : this.chunkCache.entrySet()) {
            int chunkZ;
            long chunkPos = entry.getKey();
            int chunkX = class_1923.method_8325((long)chunkPos);
            if (this.isChunkInFrustum(chunkX, chunkZ = class_1923.method_8332((long)chunkPos), fovExtension)) {
                this.culledChunks.remove(chunkPos);
                continue;
            }
            this.culledChunks.add(chunkPos);
            ++this.culledCount;
        }
    }

    private boolean isChunkInFrustum(int chunkX, int chunkZ, double fovExtension) {
        double threshold;
        double chunkCenterX = chunkX * 16 + 8;
        double chunkCenterZ = chunkZ * 16 + 8;
        class_243 toChunk = new class_243(chunkCenterX - this.cameraPos.field_1352, 0.0, chunkCenterZ - this.cameraPos.field_1350).method_1029();
        class_243 cameraHorizontal = new class_243(this.cameraDirection.field_1352, 0.0, this.cameraDirection.field_1350).method_1029();
        double dotProduct = cameraHorizontal.method_1026(toChunk);
        return dotProduct >= (threshold = Math.cos(this.fovRadians / 2.0 + fovExtension));
    }

    private void performOcclusionCulling(class_638 world, int playerX, int playerZ) {
        float solidThreshold = this.getOcclusionSolidThreshold();
        int minDistance = this.getOcclusionMinDistance();
        for (Map.Entry<Long, ChunkData> entry : this.chunkCache.entrySet()) {
            long chunkPos = entry.getKey();
            ChunkData data = entry.getValue();
            int chunkX = class_1923.method_8325((long)chunkPos);
            int chunkZ = class_1923.method_8332((long)chunkPos);
            int distance = Math.max(Math.abs(chunkX - playerX), Math.abs(chunkZ - playerZ));
            if (distance > 16 && data.solidBlockPercentage < solidThreshold) {
                this.culledChunks.add(chunkPos);
                continue;
            }
            if (distance <= minDistance || !this.isChunkOccluded(chunkX, chunkZ, playerX, playerZ)) continue;
            this.culledChunks.add(chunkPos);
        }
    }

    private boolean isChunkOccluded(int chunkX, int chunkZ, int playerX, int playerZ) {
        int dx = chunkX - playerX;
        int dz = chunkZ - playerZ;
        int steps = Math.max(Math.abs(dx), Math.abs(dz));
        if (steps <= 1) {
            return false;
        }
        float occlusionThreshold = this.getOcclusionThreshold();
        for (int i = 1; i < steps; ++i) {
            int midX = playerX + dx * i / steps;
            int midZ = playerZ + dz * i / steps;
            long midChunkPos = class_1923.method_8331((int)midX, (int)midZ);
            ChunkData midData = this.chunkCache.get(midChunkPos);
            if (midData == null || !(midData.solidBlockPercentage > occlusionThreshold)) continue;
            return true;
        }
        return false;
    }

    private int calculateLODLevel(int distance) {
        for (int i = 0; i < this.LOD_DISTANCES.length; ++i) {
            if (distance > this.LOD_DISTANCES[i]) continue;
            return i;
        }
        return this.LOD_DISTANCES.length - 1;
    }

    private int calculateChunkPriority(ChunkData data, int distance) {
        int priority = 100 - distance;
        if (data.entityCount > 0) {
            priority += this.getEntityPriorityBonus();
        }
        if (data.complexBlockPercentage > 20.0f) {
            priority += this.getComplexBlockPriorityBonus();
        }
        if (data.transparentBlockPercentage > 30.0f) {
            priority += this.getTransparentBlockPriorityBonus();
        }
        return Math.max(1, priority);
    }

    private int getUpdateInterval(int distance) {
        int baseInterval = this.getBaseUpdateInterval();
        if (distance <= 4) {
            return baseInterval;
        }
        if (distance <= 8) {
            return baseInterval * 2;
        }
        if (distance <= 16) {
            return baseInterval * 4;
        }
        return baseInterval * 10;
    }

    private void cleanupCache(int playerX, int playerZ) {
        int maxDistance = this.getRenderDistance() + this.getCleanupExtraDistance();
        this.chunkCache.entrySet().removeIf(entry -> {
            long chunkPos = (Long)entry.getKey();
            int x = class_1923.method_8325((long)chunkPos);
            int z = class_1923.method_8332((long)chunkPos);
            return Math.max(Math.abs(x - playerX), Math.abs(z - playerZ)) > maxDistance;
        });
        this.emptyChunks.removeIf(this::isChunkTooFar);
        this.culledChunks.removeIf(this::isChunkTooFar);
        this.chunkPriority.keySet().removeIf(this::isChunkTooFar);
        this.chunkLOD.keySet().removeIf(this::isChunkTooFar);
        this.lastUpdateTime.keySet().removeIf(this::isChunkTooFar);
    }

    private boolean isChunkTooFar(long chunkPos) {
        int x = class_1923.method_8325((long)chunkPos);
        int z = class_1923.method_8332((long)chunkPos);
        int distance = Math.max(Math.abs(x - this.lastPlayerChunkX), Math.abs(z - this.lastPlayerChunkZ));
        return distance > this.getRenderDistance() + this.getCleanupExtraDistance();
    }

    private void updateStatistics(long currentTime) {
        if (currentTime - this.lastStatsUpdate > 1000L) {
            this.emptyCount = this.emptyChunks.size();
            this.lastStatsUpdate = currentTime;
        }
    }

    private int getRenderDistance() {
        return switch (this.config.optimizationLevel) {
            case 0 -> 32;
            case 1 -> 24;
            case 2 -> 16;
            case 3 -> 12;
            default -> 16;
        };
    }

    private boolean shouldUseFrustumCulling() {
        return this.config.modEnabled && this.config.optimizeRendering && this.config.optimizationLevel > 0;
    }

    private boolean shouldUseOcclusionCulling() {
        return this.config.modEnabled && this.config.optimizeRendering && this.config.optimizationLevel > 1;
    }

    private boolean shouldUseLOD() {
        return this.config.modEnabled && this.config.optimizeRendering && this.config.optimizationLevel > 0;
    }

    private boolean shouldCountEntities() {
        return this.config.modEnabled && this.config.enableEntityCulling;
    }

    private long getCleanupInterval() {
        return switch (this.config.optimizationLevel) {
            case 0 -> 10000L;
            case 1 -> 5000L;
            case 2 -> 2000L;
            case 3 -> 1000L;
            default -> 2000L;
        };
    }

    private float getEmptyChunkThreshold() {
        return switch (this.config.optimizationLevel) {
            case 0 -> 95.0f;
            case 1 -> 85.0f;
            case 2 -> 75.0f;
            case 3 -> 65.0f;
            default -> 75.0f;
        };
    }

    private int getAnalysisSampleRate() {
        return switch (this.config.optimizationLevel) {
            case 0 -> 1;
            case 1 -> 2;
            case 2 -> 4;
            case 3 -> 8;
            default -> 4;
        };
    }

    private int getBaseUpdateInterval() {
        return switch (this.config.optimizationLevel) {
            case 0 -> 50;
            case 1 -> 100;
            case 2 -> 200;
            case 3 -> 500;
            default -> 200;
        };
    }

    private double getFrustumCullingFOV() {
        return this.config.optimizationLevel >= 2 ? Math.toRadians(15.0) : Math.toRadians(10.0);
    }

    private float getOcclusionSolidThreshold() {
        return switch (this.config.optimizationLevel) {
            case 0, 1 -> 90.0f;
            case 2 -> 80.0f;
            case 3 -> 70.0f;
            default -> 80.0f;
        };
    }

    private int getOcclusionMinDistance() {
        return this.config.optimizationLevel >= 2 ? 8 : 12;
    }

    private float getOcclusionThreshold() {
        return switch (this.config.optimizationLevel) {
            case 0, 1 -> 85.0f;
            case 2 -> 75.0f;
            case 3 -> 65.0f;
            default -> 75.0f;
        };
    }

    private int getEntityCountDistance() {
        return switch (this.config.optimizationLevel) {
            case 0 -> 16;
            case 1 -> 12;
            case 2 -> 8;
            case 3 -> 4;
            default -> 8;
        };
    }

    private int getCleanupExtraDistance() {
        return this.config.optimizationLevel >= 2 ? 4 : 8;
    }

    private int getEntityPriorityBonus() {
        return this.config.enableEntityCulling ? 5 : 0;
    }

    private int getComplexBlockPriorityBonus() {
        return this.config.optimizeRendering ? 3 : 0;
    }

    private int getTransparentBlockPriorityBonus() {
        return this.config.optimizeRendering ? 2 : 0;
    }

    public boolean shouldSkipChunkRender(long chunkPos) {
        return this.culledChunks.contains(chunkPos) || this.emptyChunks.contains(chunkPos);
    }

    public boolean isChunkEmpty(long chunkPos) {
        return this.emptyChunks.contains(chunkPos);
    }

    public float getChunkLODDetail(long chunkPos) {
        if (!this.shouldUseLOD()) {
            return 1.0f;
        }
        Integer lod = this.chunkLOD.get(chunkPos);
        if (lod == null) {
            return 1.0f;
        }
        return this.LOD_DETAIL[Math.min(lod, this.LOD_DETAIL.length - 1)];
    }

    public int getChunkPriority(long chunkPos) {
        return this.chunkPriority.getOrDefault(chunkPos, 50);
    }

    public boolean shouldThrottleChunkUpdate(long chunkPos, long currentTime) {
        Long lastUpdate = this.lastUpdateTime.get(chunkPos);
        if (lastUpdate == null) {
            return false;
        }
        ChunkData data = this.chunkCache.get(chunkPos);
        if (data == null) {
            return false;
        }
        int priority = this.chunkPriority.getOrDefault(chunkPos, 50);
        int baseInterval = this.getBaseUpdateInterval();
        int interval = Math.max(16, baseInterval + (100 - priority) * 2);
        return currentTime - lastUpdate < (long)interval;
    }

    public String getOptimizationStats() {
        return String.format("\u0427\u0430\u043d\u043a\u0438: %d | \u041f\u043e\u0440\u043e\u0436\u043d\u0456: %d | \u041e\u0431\u0440\u0456\u0437\u0430\u043d\u0456: %d | \u041a\u0435\u0448: %d", this.totalChunks, this.emptyCount, this.culledCount, this.chunkCache.size());
    }

    @Environment(value=EnvType.CLIENT)
    public static class ChunkData {
        public boolean isEmpty = false;
        public float airBlockPercentage = 0.0f;
        public float solidBlockPercentage = 0.0f;
        public float transparentBlockPercentage = 0.0f;
        public float complexBlockPercentage = 0.0f;
        public int entityCount = 0;
        public long lastAnalysis = 0L;
    }
}

