/*
 * Decompiled with CFR 0.152.
 */
package com.example.mixin.client;

import com.example.TemplateModClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_898;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_898.class})
public class EntityRenderMixin {
    private static final Map<class_1297, VeltiumEntityRenderData> veltiumEntityData = new ConcurrentHashMap<class_1297, VeltiumEntityRenderData>();
    private static long veltiumLastCleanup = 0L;

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void veltiumOptimizeEntityRender(class_1297 entity, double x, double y, double z, float yaw, float tickDelta, CallbackInfo ci) {
        VeltiumEntityRenderData data;
        if (!TemplateModClient.config.shouldCullEntities()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1773 == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        double distanceSquared = client.field_1724.method_5858(entity);
        if (this.veltiumShouldCullEntity(entity, client, distanceSquared, currentTime, data = veltiumEntityData.computeIfAbsent(entity, e -> new VeltiumEntityRenderData()))) {
            ci.cancel();
            return;
        }
        data.veltiumLastRenderTime = currentTime;
        this.veltiumCleanupOldEntities(currentTime);
    }

    private boolean veltiumShouldCullEntity(class_1297 entity, class_310 client, double distanceSquared, long currentTime, VeltiumEntityRenderData data) {
        int optimizationLevel = TemplateModClient.config.optimizationLevel;
        if (entity instanceof class_1657) {
            return this.veltiumShouldCullPlayer(entity, distanceSquared, currentTime, data, optimizationLevel);
        }
        if (entity instanceof class_1309) {
            return this.veltiumShouldCullLivingEntity((class_1309)entity, client, distanceSquared, currentTime, data, optimizationLevel);
        }
        return this.veltiumShouldCullGenericEntity(entity, client, distanceSquared, currentTime, data, optimizationLevel);
    }

    private boolean veltiumShouldCullPlayer(class_1297 entity, double distanceSquared, long currentTime, VeltiumEntityRenderData data, int optimizationLevel) {
        if (optimizationLevel < 2) {
            return false;
        }
        if (distanceSquared > 16384.0) {
            return currentTime - data.veltiumLastRenderTime < 200L;
        }
        if (distanceSquared > 4096.0 && optimizationLevel >= 3) {
            return currentTime - data.veltiumLastRenderTime < 100L;
        }
        return false;
    }

    private boolean veltiumShouldCullLivingEntity(class_1309 entity, class_310 client, double distanceSquared, long currentTime, VeltiumEntityRenderData data, int optimizationLevel) {
        if (entity.method_5851() || entity.method_16914()) {
            return false;
        }
        if (optimizationLevel >= 2 && distanceSquared > 1024.0) {
            boolean recentlyMoved;
            boolean isMoving = entity.method_18798().method_1027() > 0.01;
            boolean bl = recentlyMoved = currentTime - data.veltiumLastMovementTime < 1000L;
            if (!isMoving && !recentlyMoved) {
                return currentTime - data.veltiumLastRenderTime < (long)this.veltiumGetUpdateInterval(distanceSquared, optimizationLevel);
            }
            if (isMoving) {
                data.veltiumLastMovementTime = currentTime;
            }
        }
        if (optimizationLevel >= 3) {
            class_1308 mob;
            if (distanceSquared > 256.0 && entity instanceof class_1429) {
                if (!entity.method_24828() && entity.method_18798().field_1351 < -0.5) {
                    return false;
                }
                return currentTime - data.veltiumLastRenderTime < 150L;
            }
            if (distanceSquared > 64.0 && entity instanceof class_1308 && (mob = (class_1308)entity).method_5968() == null && mob.method_18798().method_1027() < 0.001) {
                return currentTime - data.veltiumLastRenderTime < 250L;
            }
        }
        if (optimizationLevel >= 4 && distanceSquared > 2304.0 && !this.veltiumIsEntityVisible((class_1297)entity, client)) {
            return currentTime - data.veltiumLastRenderTime < 500L;
        }
        return false;
    }

    private boolean veltiumShouldCullGenericEntity(class_1297 entity, class_310 client, double distanceSquared, long currentTime, VeltiumEntityRenderData data, int optimizationLevel) {
        if (optimizationLevel < 2) {
            return false;
        }
        if (entity.method_16914() || entity.method_5851()) {
            return false;
        }
        if (distanceSquared > 2048.0) {
            boolean isMoving;
            boolean bl = isMoving = entity.method_18798().method_1027() > 0.001;
            if (!isMoving) {
                return currentTime - data.veltiumLastRenderTime < (long)this.veltiumGetUpdateInterval(distanceSquared, optimizationLevel);
            }
        }
        if (optimizationLevel >= 3 && distanceSquared > 512.0 && !this.veltiumIsEntityVisible(entity, client)) {
            return currentTime - data.veltiumLastRenderTime < 400L;
        }
        return false;
    }

    private int veltiumGetUpdateInterval(double distanceSquared, int optimizationLevel) {
        if (distanceSquared > 16384.0) {
            return 400 + optimizationLevel * 100;
        }
        if (distanceSquared > 4096.0) {
            return 200 + optimizationLevel * 50;
        }
        if (distanceSquared > 1024.0) {
            return 100 + optimizationLevel * 25;
        }
        return 50;
    }

    private boolean veltiumIsEntityVisible(class_1297 entity, class_310 client) {
        if (client.field_1773 == null || client.field_1773.method_19418() == null) {
            return true;
        }
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        class_243 entityPos = entity.method_19538();
        class_243 direction = entityPos.method_1020(cameraPos).method_1029();
        float yaw = client.field_1773.method_19418().method_19330();
        float pitch = client.field_1773.method_19418().method_19329();
        double cameraYawRad = Math.toRadians(-yaw);
        double cameraPitchRad = Math.toRadians(-pitch);
        class_243 cameraDirection = new class_243(Math.sin(cameraYawRad) * Math.cos(cameraPitchRad), Math.sin(cameraPitchRad), -Math.cos(cameraYawRad) * Math.cos(cameraPitchRad));
        double dotProduct = direction.method_1026(cameraDirection);
        return dotProduct > 0.3;
    }

    private void veltiumCleanupOldEntities(long currentTime) {
        if (currentTime - veltiumLastCleanup < 5000L) {
            return;
        }
        veltiumEntityData.entrySet().removeIf(entry -> {
            class_1297 entity = (class_1297)entry.getKey();
            return entity.method_31481() || currentTime - ((VeltiumEntityRenderData)entry.getValue()).veltiumLastRenderTime > 30000L;
        });
        veltiumLastCleanup = currentTime;
    }

    @Environment(value=EnvType.CLIENT)
    private static class VeltiumEntityRenderData {
        long veltiumLastRenderTime = 0L;
        long veltiumLastMovementTime = 0L;

        private VeltiumEntityRenderData() {
        }
    }
}

