/*
 * Decompiled with CFR 0.152.
 */
package com.example.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import java.awt.Color;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class YACLConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("veltium-config.json");
    private static YACLConfig INSTANCE = null;
    public boolean modEnabled = true;
    public boolean showNotifications = true;
    public boolean cornerSnap = false;
    public int optimizationLevel = 2;
    public int maxParticles = 100;
    public boolean reduceLag = true;
    public boolean optimizeRendering = true;
    public boolean cullParticles = true;
    public boolean enableEntityCulling = true;
    public boolean optimizeChunks = true;
    public boolean fastMath = true;
    public boolean smartMemoryManagement = true;
    public int tickOptimizationLevel = 1;
    public boolean showFpsCounter = true;
    public boolean showMemoryUsage = false;
    public boolean showPing = false;
    public boolean showCoordinates = true;
    public boolean showTime = false;
    public boolean showAdvancedFps = false;
    public boolean showAdvancedMemory = false;
    public boolean showAdvancedPing = false;
    public String hudPosition = "top-left";
    public int hudX = 10;
    public int hudY = 10;
    public int hudUpdateInterval = 25;
    public boolean hudShadow = true;
    public boolean hudBold = false;
    public float hudScale = 1.0f;
    public float hudTextOpacity = 1.0f;
    public float hudBackgroundOpacity = 0.8f;
    public int hudBackgroundColor = 0;
    public int fpsGoodColor = 0x55FF55;
    public int fpsMediumColor = 0xFFFF55;
    public int fpsBadColor = 0xFF5555;
    public int memoryGoodColor = 0x55FF55;
    public int memoryMediumColor = 0xFFFF55;
    public int memoryBadColor = 0xFF5555;
    public int pingGoodColor = 0x55FF55;
    public int pingMediumColor = 0xFFFF55;
    public int pingBadColor = 0xFF5555;
    public boolean enableCoordinateColors = false;
    public int coordinatesColor = 0xFFFFFF;
    public int coordinatesXColor = 0xFF5555;
    public int coordinatesYColor = 0x55FF55;
    public int coordinatesZColor = 0x5555FF;
    public int timeColor = 0xFFFFFF;

    public static YACLConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new YACLConfig();
            INSTANCE.load();
        }
        return INSTANCE;
    }

    private static Color intToColor(int color) {
        return new Color(color);
    }

    private static int colorToInt(Color color) {
        return color.getRGB() & 0xFFFFFF;
    }

    public int getFpsColor(int fps) {
        if (fps >= 60) {
            return this.fpsGoodColor;
        }
        if (fps >= 30) {
            return this.fpsMediumColor;
        }
        return this.fpsBadColor;
    }

    public int getMemoryColor(double memoryUsagePercentage) {
        if (memoryUsagePercentage < 70.0) {
            return this.memoryGoodColor;
        }
        if (memoryUsagePercentage < 90.0) {
            return this.memoryMediumColor;
        }
        return this.memoryBadColor;
    }

    public int getPingColor(int ping) {
        if (ping < 50) {
            return this.pingGoodColor;
        }
        if (ping < 100) {
            return this.pingMediumColor;
        }
        return this.pingBadColor;
    }

    public boolean shouldReduceLag() {
        return this.modEnabled && this.reduceLag && this.optimizationLevel > 0;
    }

    public boolean shouldCullEntities() {
        return this.modEnabled && this.enableEntityCulling && this.optimizationLevel > 0;
    }

    public boolean shouldOptimizeChunks() {
        return this.modEnabled && this.optimizeChunks && this.optimizationLevel > 0;
    }

    public int getEffectiveParticleLimit() {
        if (!this.modEnabled || this.optimizationLevel == 0) {
            return this.maxParticles;
        }
        float multiplier = switch (this.optimizationLevel) {
            case 1 -> 0.9f;
            case 2 -> 0.7f;
            case 3 -> 0.5f;
            default -> 1.0f;
        };
        return (int)((float)this.maxParticles * multiplier);
    }

    public void load() {
        block9: {
            try {
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                        YACLConfig loadedConfig = (YACLConfig)GSON.fromJson((Reader)reader, YACLConfig.class);
                        if (loadedConfig != null) {
                            this.copyFrom(loadedConfig);
                            System.out.println("\u041a\u043e\u043d\u0444\u0456\u0433\u0443\u0440\u0430\u0446\u0456\u044e Veltium \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043e \u0443\u0441\u043f\u0456\u0448\u043d\u043e!");
                        }
                        break block9;
                    }
                }
                this.save();
                System.out.println("\u0421\u0442\u0432\u043e\u0440\u0435\u043d\u043e \u043d\u043e\u0432\u0443 \u043a\u043e\u043d\u0444\u0456\u0433\u0443\u0440\u0430\u0446\u0456\u044e Veltium!");
            }
            catch (IOException e) {
                System.err.println("\u041f\u043e\u043c\u0438\u043b\u043a\u0430 \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u044f \u043a\u043e\u043d\u0444\u0456\u0433\u0443\u0440\u0430\u0446\u0456\u0457 Veltium: " + e.getMessage());
            }
        }
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                GSON.toJson((Object)this, (Appendable)writer);
                if (this.showNotifications) {
                    System.out.println("\u041a\u043e\u043d\u0444\u0456\u0433\u0443\u0440\u0430\u0446\u0456\u044e Veltium \u0437\u0431\u0435\u0440\u0435\u0436\u0435\u043d\u043e \u0443\u0441\u043f\u0456\u0448\u043d\u043e!");
                }
            }
        }
        catch (IOException e) {
            System.err.println("\u041f\u043e\u043c\u0438\u043b\u043a\u0430 \u0437\u0431\u0435\u0440\u0435\u0436\u0435\u043d\u043d\u044f \u043a\u043e\u043d\u0444\u0456\u0433\u0443\u0440\u0430\u0446\u0456\u0457 Veltium: " + e.getMessage());
        }
    }

    private void copyFrom(YACLConfig other) {
        this.modEnabled = other.modEnabled;
        this.showNotifications = other.showNotifications;
        this.cornerSnap = other.cornerSnap;
        this.optimizationLevel = other.optimizationLevel;
        this.maxParticles = other.maxParticles;
        this.reduceLag = other.reduceLag;
        this.optimizeRendering = other.optimizeRendering;
        this.cullParticles = other.cullParticles;
        this.enableEntityCulling = other.enableEntityCulling;
        this.optimizeChunks = other.optimizeChunks;
        this.fastMath = other.fastMath;
        this.smartMemoryManagement = other.smartMemoryManagement;
        this.tickOptimizationLevel = other.tickOptimizationLevel;
        this.showFpsCounter = other.showFpsCounter;
        this.showMemoryUsage = other.showMemoryUsage;
        this.showPing = other.showPing;
        this.showCoordinates = other.showCoordinates;
        this.showTime = other.showTime;
        this.showAdvancedFps = other.showAdvancedFps;
        this.showAdvancedMemory = other.showAdvancedMemory;
        this.showAdvancedPing = other.showAdvancedPing;
        this.hudPosition = other.hudPosition != null ? other.hudPosition : "top-left";
        this.hudX = other.hudX;
        this.hudY = other.hudY;
        this.hudUpdateInterval = other.hudUpdateInterval;
        this.hudShadow = other.hudShadow;
        this.hudBold = other.hudBold;
        this.hudScale = other.hudScale;
        this.hudTextOpacity = other.hudTextOpacity;
        this.hudBackgroundOpacity = other.hudBackgroundOpacity;
        this.hudBackgroundColor = other.hudBackgroundColor;
        this.fpsGoodColor = other.fpsGoodColor;
        this.fpsMediumColor = other.fpsMediumColor;
        this.fpsBadColor = other.fpsBadColor;
        this.memoryGoodColor = other.memoryGoodColor;
        this.memoryMediumColor = other.memoryMediumColor;
        this.memoryBadColor = other.memoryBadColor;
        this.pingGoodColor = other.pingGoodColor;
        this.pingMediumColor = other.pingMediumColor;
        this.pingBadColor = other.pingBadColor;
        this.enableCoordinateColors = other.enableCoordinateColors;
        this.coordinatesColor = other.coordinatesColor;
        this.coordinatesXColor = other.coordinatesXColor;
        this.coordinatesYColor = other.coordinatesYColor;
        this.coordinatesZColor = other.coordinatesZColor;
        this.timeColor = other.timeColor;
    }

    public static class_437 createConfigScreen(class_437 parent) {
        YACLConfig config = YACLConfig.getInstance();
        return YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"text.optimizationmod.config.title")).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.category.hud")).tooltip(new class_2561[]{class_2561.method_43471((String)"text.optimizationmod.category.hud.tooltip")}).option(YACLConfig.createBooleanOption("text.optimizationmod.option.mod_enabled", "text.optimizationmod.option.mod_enabled.tooltip", true, () -> config.modEnabled, val -> {
            config.modEnabled = val;
        })).option(YACLConfig.createBooleanOption("text.optimizationmod.option.show_notifications", "text.optimizationmod.option.show_notifications.tooltip", true, () -> config.showNotifications, val -> {
            config.showNotifications = val;
        })).option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"text.optimizationmod.separator.hud_elements"))).option(YACLConfig.createBooleanOption("text.optimizationmod.option.show_fps", "text.optimizationmod.option.show_fps.tooltip", true, () -> config.showFpsCounter, val -> {
            config.showFpsCounter = val;
        })).option(YACLConfig.createBooleanOption("text.optimizationmod.option.show_memory", "text.optimizationmod.option.show_memory.tooltip", false, () -> config.showMemoryUsage, val -> {
            config.showMemoryUsage = val;
        })).option(YACLConfig.createBooleanOption("text.optimizationmod.option.show_ping", "text.optimizationmod.option.show_ping.tooltip", false, () -> config.showPing, val -> {
            config.showPing = val;
        })).option(YACLConfig.createBooleanOption("text.optimizationmod.option.show_coordinates", "text.optimizationmod.option.show_coordinates.tooltip", true, () -> config.showCoordinates, val -> {
            config.showCoordinates = val;
        })).option(YACLConfig.createBooleanOption("text.optimizationmod.option.show_time", "text.optimizationmod.option.show_time.tooltip", false, () -> config.showTime, val -> {
            config.showTime = val;
        })).option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"text.optimizationmod.separator.advanced_stats"))).option(YACLConfig.createBooleanOption("text.optimizationmod.option.show_advanced_fps", "text.optimizationmod.option.show_advanced_fps.tooltip", false, () -> config.showAdvancedFps, val -> {
            config.showAdvancedFps = val;
        })).option(YACLConfig.createBooleanOption("text.optimizationmod.option.show_advanced_memory", "text.optimizationmod.option.show_advanced_memory.tooltip", false, () -> config.showAdvancedMemory, val -> {
            config.showAdvancedMemory = val;
        })).option(YACLConfig.createBooleanOption("text.optimizationmod.option.show_advanced_ping", "text.optimizationmod.option.show_advanced_ping.tooltip", false, () -> config.showAdvancedPing, val -> {
            config.showAdvancedPing = val;
        })).option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"text.optimizationmod.separator.size_position"))).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.option.hud_scale")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"text.optimizationmod.option.hud_scale.tooltip")})).binding((Object)Float.valueOf(1.0f), () -> Float.valueOf(config.hudScale), val -> {
            config.hudScale = val.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.5f), (Number)Float.valueOf(3.0f))).step((Number)Float.valueOf(0.1f))).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.option.hud_position")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"text.optimizationmod.option.hud_position.tooltip")})).binding((Object)"top-left", () -> config.hudPosition, val -> {
            config.hudPosition = val;
        }).controller(opt -> DropdownStringControllerBuilder.create((Option)opt).values(new String[]{"top-left", "top-right", "bottom-left", "bottom-right"})).build()).option(YACLConfig.createBooleanOption("text.optimizationmod.option.corner_snap", "text.optimizationmod.option.corner_snap.tooltip", false, () -> config.cornerSnap, val -> {
            config.cornerSnap = val;
        })).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.option.hud_x")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"text.optimizationmod.option.hud_x.tooltip")})).binding((Object)10, () -> config.hudX, val -> {
            config.hudX = val;
        }).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)500)).step((Number)1)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.option.hud_y")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"text.optimizationmod.option.hud_y.tooltip")})).binding((Object)10, () -> config.hudY, val -> {
            config.hudY = val;
        }).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)500)).step((Number)1)).build()).option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"text.optimizationmod.separator.text_appearance"))).option(YACLConfig.createBooleanOption("text.optimizationmod.option.hud_shadow", "text.optimizationmod.option.hud_shadow.tooltip", true, () -> config.hudShadow, val -> {
            config.hudShadow = val;
        })).option(YACLConfig.createBooleanOption("text.optimizationmod.option.hud_bold", "text.optimizationmod.option.hud_bold.tooltip", false, () -> config.hudBold, val -> {
            config.hudBold = val;
        })).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.option.hud_text_opacity")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"text.optimizationmod.option.hud_text_opacity.tooltip")})).binding((Object)Float.valueOf(1.0f), () -> Float.valueOf(config.hudTextOpacity), val -> {
            config.hudTextOpacity = val.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.1f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.1f))).build()).option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"text.optimizationmod.separator.colors"))).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.option.coordinates_color")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"text.optimizationmod.option.coordinates_color.tooltip")})).binding((Object)YACLConfig.intToColor(0xFFFFFF), () -> YACLConfig.intToColor(config.coordinatesColor), val -> {
            config.coordinatesColor = YACLConfig.colorToInt(val);
        }).controller(ColorControllerBuilder::create).build()).group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.category.coordinate_colors")).collapsed(true).option(YACLConfig.createBooleanOption("text.optimizationmod.option.enable_coordinate_colors", "text.optimizationmod.option.enable_coordinate_colors.tooltip", false, () -> config.enableCoordinateColors, val -> {
            config.enableCoordinateColors = val;
        })).option(YACLConfig.createColorOption("text.optimizationmod.option.coordinates_x_color", "text.optimizationmod.option.coordinates_x_color.tooltip", 0xFF5555, () -> config.coordinatesXColor, val -> {
            config.coordinatesXColor = val;
        })).option(YACLConfig.createColorOption("text.optimizationmod.option.coordinates_y_color", "text.optimizationmod.option.coordinates_y_color.tooltip", 0x55FF55, () -> config.coordinatesYColor, val -> {
            config.coordinatesYColor = val;
        })).option(YACLConfig.createColorOption("text.optimizationmod.option.coordinates_z_color", "text.optimizationmod.option.coordinates_z_color.tooltip", 0x5555FF, () -> config.coordinatesZColor, val -> {
            config.coordinatesZColor = val;
        })).build()).option(YACLConfig.createColorOption("text.optimizationmod.option.time_color", "text.optimizationmod.option.time_color.tooltip", 0xFFFFFF, () -> config.timeColor, val -> {
            config.timeColor = val;
        })).group(YACLConfig.createFpsColorGroup(config)).group(YACLConfig.createMemoryColorGroup(config)).group(YACLConfig.createPingColorGroup(config)).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.category.optimization")).tooltip(new class_2561[]{class_2561.method_43471((String)"text.optimizationmod.category.optimization.tooltip")}).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.option.optimization_level")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"text.optimizationmod.option.optimization_level.tooltip")})).binding((Object)2, () -> config.optimizationLevel, val -> {
            config.optimizationLevel = val;
        }).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)3)).step((Number)1)).build()).option(YACLConfig.createBooleanOption("text.optimizationmod.option.reduce_lag", "text.optimizationmod.option.reduce_lag.tooltip", true, () -> config.reduceLag, val -> {
            config.reduceLag = val;
        })).option(YACLConfig.createBooleanOption("text.optimizationmod.option.optimize_rendering", "text.optimizationmod.option.optimize_rendering.tooltip", true, () -> config.optimizeRendering, val -> {
            config.optimizeRendering = val;
        })).option(YACLConfig.createBooleanOption("text.optimizationmod.option.cull_particles", "text.optimizationmod.option.cull_particles.tooltip", true, () -> config.cullParticles, val -> {
            config.cullParticles = val;
        })).option(YACLConfig.createBooleanOption("text.optimizationmod.option.entity_culling", "text.optimizationmod.option.entity_culling.tooltip", true, () -> config.enableEntityCulling, val -> {
            config.enableEntityCulling = val;
        })).option(YACLConfig.createBooleanOption("text.optimizationmod.option.optimize_chunks", "text.optimizationmod.option.optimize_chunks.tooltip", true, () -> config.optimizeChunks, val -> {
            config.optimizeChunks = val;
        })).build()).save(config::save).build().generateScreen(parent);
    }

    private static Option<Boolean> createBooleanOption(String nameKey, String tooltipKey, boolean defaultValue, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return Option.createBuilder().name((class_2561)class_2561.method_43471((String)nameKey)).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)tooltipKey)})).binding((Object)defaultValue, getter, setter).controller(opt -> BooleanControllerBuilder.create((Option)opt).formatValue(val -> val != false ? class_2561.method_43471((String)"text.optimizationmod.yes").method_27692(class_124.field_1060) : class_2561.method_43471((String)"text.optimizationmod.no").method_27692(class_124.field_1061))).build();
    }

    private static Option<Color> createColorOption(String nameKey, String tooltipKey, int defaultValue, Supplier<Integer> getter, Consumer<Integer> setter) {
        return Option.createBuilder().name((class_2561)class_2561.method_43471((String)nameKey)).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)tooltipKey)})).binding((Object)YACLConfig.intToColor(defaultValue), () -> YACLConfig.intToColor((Integer)getter.get()), val -> setter.accept(YACLConfig.colorToInt(val))).controller(ColorControllerBuilder::create).build();
    }

    private static OptionGroup createFpsColorGroup(YACLConfig config) {
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.category.fps_colors")).collapsed(true).option(YACLConfig.createColorOption("text.optimizationmod.option.fps_good_color", "text.optimizationmod.option.fps_good_color.tooltip", 0x55FF55, () -> config.fpsGoodColor, val -> {
            config.fpsGoodColor = val;
        })).option(YACLConfig.createColorOption("text.optimizationmod.option.fps_medium_color", "text.optimizationmod.option.fps_medium_color.tooltip", 0xFFFF55, () -> config.fpsMediumColor, val -> {
            config.fpsMediumColor = val;
        })).option(YACLConfig.createColorOption("text.optimizationmod.option.fps_bad_color", "text.optimizationmod.option.fps_bad_color.tooltip", 0xFF5555, () -> config.fpsBadColor, val -> {
            config.fpsBadColor = val;
        })).build();
    }

    private static OptionGroup createMemoryColorGroup(YACLConfig config) {
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.category.memory_colors")).collapsed(true).option(YACLConfig.createColorOption("text.optimizationmod.option.memory_good_color", "text.optimizationmod.option.memory_good_color.tooltip", 0x55FF55, () -> config.memoryGoodColor, val -> {
            config.memoryGoodColor = val;
        })).option(YACLConfig.createColorOption("text.optimizationmod.option.memory_medium_color", "text.optimizationmod.option.memory_medium_color.tooltip", 0xFFFF55, () -> config.memoryMediumColor, val -> {
            config.memoryMediumColor = val;
        })).option(YACLConfig.createColorOption("text.optimizationmod.option.memory_bad_color", "text.optimizationmod.option.memory_bad_color.tooltip", 0xFF5555, () -> config.memoryBadColor, val -> {
            config.memoryBadColor = val;
        })).build();
    }

    private static OptionGroup createPingColorGroup(YACLConfig config) {
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"text.optimizationmod.category.ping_colors")).collapsed(true).option(YACLConfig.createColorOption("text.optimizationmod.option.ping_good_color", "text.optimizationmod.option.ping_good_color.tooltip", 0x55FF55, () -> config.pingGoodColor, val -> {
            config.pingGoodColor = val;
        })).option(YACLConfig.createColorOption("text.optimizationmod.option.ping_medium_color", "text.optimizationmod.option.ping_medium_color.tooltip", 0xFFFF55, () -> config.pingMediumColor, val -> {
            config.pingMediumColor = val;
        })).option(YACLConfig.createColorOption("text.optimizationmod.option.ping_bad_color", "text.optimizationmod.option.ping_bad_color.tooltip", 0xFF5555, () -> config.pingBadColor, val -> {
            config.pingBadColor = val;
        })).build();
    }
}

