/*
 * Decompiled with CFR 0.152.
 */
package com.example.mixin.client;

import com.example.Veltium;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_897;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_897.class})
public class EntityRenderMixin {
    @Unique
    private static final Map<Integer, VeltiumEntityRenderData> veltium$entityData = new ConcurrentHashMap<Integer, VeltiumEntityRenderData>();
    @Unique
    private static long veltium$lastCleanup = 0L;
    @Unique
    private static final int CLEANUP_INTERVAL = 10000;
    @Unique
    private static final int DATA_EXPIRE_TIME = 60000;

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void veltium$optimizeEntityRender(class_1297 entity, double x, double y, double z, float yaw, float tickDelta, CallbackInfo ci) {
        if (!Veltium.config.shouldCullEntities() || Veltium.config.optimizationLevel == 0) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        int entityId = entity.method_5628();
        double distanceSquared = client.field_1724.method_5858(entity);
        VeltiumEntityRenderData data = veltium$entityData.computeIfAbsent(entityId, id -> new VeltiumEntityRenderData(entity));
        if (data.entityRef.get() == null || ((class_1297)data.entityRef.get()).method_31481()) {
            veltium$entityData.remove(entityId);
            return;
        }
        if (this.veltium$shouldCullEntity(entity, client, distanceSquared, currentTime, data)) {
            ci.cancel();
            return;
        }
        data.lastRenderTime = currentTime;
        if (currentTime - veltium$lastCleanup > 10000L) {
            this.veltium$cleanupOldEntities(currentTime);
        }
    }

    @Unique
    private boolean veltium$shouldCullEntity(class_1297 entity, class_310 client, double distanceSquared, long currentTime, VeltiumEntityRenderData data) {
        int optimizationLevel = Veltium.config.optimizationLevel;
        if (entity instanceof class_1657) {
            return this.veltium$shouldCullPlayer(entity, distanceSquared, currentTime, data, optimizationLevel);
        }
        if (entity instanceof class_1309) {
            return this.veltium$shouldCullLivingEntity((class_1309)entity, client, distanceSquared, currentTime, data, optimizationLevel);
        }
        return this.veltium$shouldCullGenericEntity(entity, client, distanceSquared, currentTime, data, optimizationLevel);
    }

    @Unique
    private boolean veltium$shouldCullPlayer(class_1297 entity, double distanceSquared, long currentTime, VeltiumEntityRenderData data, int optimizationLevel) {
        if (optimizationLevel < 3) {
            return false;
        }
        if (distanceSquared > 20736.0) {
            return currentTime - data.lastRenderTime < 300L;
        }
        return false;
    }

    @Unique
    private boolean veltium$shouldCullLivingEntity(class_1309 entity, class_310 client, double distanceSquared, long currentTime, VeltiumEntityRenderData data, int optimizationLevel) {
        if (entity.method_5851() || entity.method_16914() || entity.method_5765() || entity.method_5782()) {
            return false;
        }
        if (optimizationLevel >= 2 && distanceSquared > 1600.0) {
            boolean recentlyMoved;
            boolean isMoving = entity.method_18798().method_1027() > 0.005;
            boolean bl = recentlyMoved = currentTime - data.lastMovementTime < 2000L;
            if (!isMoving && !recentlyMoved) {
                return currentTime - data.lastRenderTime < (long)this.veltium$getUpdateInterval(distanceSquared, optimizationLevel);
            }
            if (isMoving) {
                data.lastMovementTime = currentTime;
            }
        }
        if (optimizationLevel >= 3) {
            class_1308 mob;
            if (distanceSquared > 576.0 && entity instanceof class_1429) {
                if (!entity.method_24828() && entity.method_18798().field_1351 < -0.3) {
                    return false;
                }
                return currentTime - data.lastRenderTime < 200L;
            }
            if (distanceSquared > 400.0 && entity instanceof class_1308 && (mob = (class_1308)entity).method_5968() == null && mob.method_18798().method_1027() < 0.002) {
                return currentTime - data.lastRenderTime < 300L;
            }
        }
        return false;
    }

    @Unique
    private boolean veltium$shouldCullGenericEntity(class_1297 entity, class_310 client, double distanceSquared, long currentTime, VeltiumEntityRenderData data, int optimizationLevel) {
        if (optimizationLevel < 2) {
            return false;
        }
        if (entity.method_16914() || entity.method_5851() || entity.method_5765() || entity.method_5782()) {
            return false;
        }
        if (distanceSquared > 2304.0) {
            boolean isMoving;
            boolean bl = isMoving = entity.method_18798().method_1027() > 0.002;
            if (!isMoving) {
                return currentTime - data.lastRenderTime < (long)this.veltium$getUpdateInterval(distanceSquared, optimizationLevel);
            }
        }
        return false;
    }

    @Unique
    private int veltium$getUpdateInterval(double distanceSquared, int optimizationLevel) {
        if (distanceSquared > 22500.0) {
            return 500 + optimizationLevel * 100;
        }
        if (distanceSquared > 10000.0) {
            return 300 + optimizationLevel * 50;
        }
        if (distanceSquared > 2500.0) {
            return 150 + optimizationLevel * 25;
        }
        return 75;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void veltium$cleanupOldEntities(long currentTime) {
        try {
            veltium$entityData.entrySet().removeIf(entry -> {
                VeltiumEntityRenderData data = (VeltiumEntityRenderData)entry.getValue();
                class_1297 entity = (class_1297)data.entityRef.get();
                return entity == null || entity.method_31481() || currentTime - data.lastRenderTime > 60000L;
            });
        }
        catch (Exception exception) {
        }
        finally {
            veltium$lastCleanup = currentTime;
        }
    }

    @Unique
    @Environment(value=EnvType.CLIENT)
    private static class VeltiumEntityRenderData {
        final WeakReference<class_1297> entityRef;
        long lastRenderTime = 0L;
        long lastMovementTime = 0L;

        VeltiumEntityRenderData(class_1297 entity) {
            this.entityRef = new WeakReference<class_1297>(entity);
        }
    }
}

