/*
 * Decompiled with CFR 0.152.
 */
package com.example.mixin.client;

import com.example.Veltium;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_4066;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_757.class})
public class GameRendererMixin {
    @Shadow
    @Final
    private class_310 field_4015;
    private long lastPerformanceCheck = 0L;
    private long lastFrameTime = System.nanoTime();
    private float averageFps = 60.0f;
    private int frameCounter = 0;
    private boolean adaptiveMode = false;
    private int originalRenderDistance = -1;
    private class_4066 originalParticlesMode = null;
    private boolean originalBobView = true;
    private boolean performanceOptimizationsActive = false;

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRenderStart(CallbackInfo ci) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastPerformanceCheck > 1000L) {
            this.updatePerformanceMetrics();
            this.checkAndApplyAdaptiveOptimizations();
            this.lastPerformanceCheck = currentTime;
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRenderEnd(CallbackInfo ci) {
        this.updateFrameMetrics();
    }

    @ModifyVariable(method={"getFov"}, at=@At(value="HEAD"), argsOnly=true)
    private double modifyFov(double fov) {
        if (!Veltium.config.optimizeRendering || !this.adaptiveMode) {
            return fov;
        }
        if (this.averageFps < 30.0f && Veltium.config.shouldReduceLag()) {
            return Math.max(fov * 0.95, 70.0);
        }
        if (this.averageFps < 45.0f) {
            return Math.max(fov * 0.98, 85.0);
        }
        return fov;
    }

    private void updateFrameMetrics() {
        long currentFrameTime = System.nanoTime();
        long frameTimeDelta = currentFrameTime - this.lastFrameTime;
        this.lastFrameTime = currentFrameTime;
        if (frameTimeDelta > 0L) {
            float currentFps = 1.0E9f / (float)frameTimeDelta;
            this.averageFps = this.averageFps * 0.9f + currentFps * 0.1f;
        }
        ++this.frameCounter;
    }

    private void updatePerformanceMetrics() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        double memoryUsagePercent = (double)usedMemory / (double)runtime.maxMemory();
        this.adaptiveMode = (this.averageFps < 50.0f || memoryUsagePercent > 0.8) && Veltium.config.shouldReduceLag();
    }

    private void checkAndApplyAdaptiveOptimizations() {
        boolean shouldOptimize;
        if (!Veltium.config.optimizeRendering) {
            this.restoreOriginalSettings();
            return;
        }
        boolean bl = shouldOptimize = this.averageFps < 40.0f || (double)Runtime.getRuntime().freeMemory() < (double)Runtime.getRuntime().totalMemory() * 0.15;
        if (shouldOptimize && !this.performanceOptimizationsActive) {
            this.applyPerformanceOptimizations();
        } else if (!shouldOptimize && this.performanceOptimizationsActive) {
            this.restoreOriginalSettings();
        }
    }

    private void applyPerformanceOptimizations() {
        int currentDistance;
        if (this.field_4015.field_1690 == null) {
            return;
        }
        this.performanceOptimizationsActive = true;
        if (this.originalRenderDistance == -1) {
            this.originalRenderDistance = (Integer)this.field_4015.field_1690.method_42503().method_41753();
        }
        if (this.originalParticlesMode == null) {
            this.originalParticlesMode = (class_4066)this.field_4015.field_1690.method_42475().method_41753();
        }
        this.originalBobView = (Boolean)this.field_4015.field_1690.method_42448().method_41753();
        int targetDistance = this.averageFps < 20.0f ? Math.max(4, currentDistance - 4) : (this.averageFps < 35.0f ? Math.max(6, currentDistance - 2) : Math.max(8, currentDistance - 1));
        if (targetDistance != (currentDistance = ((Integer)this.field_4015.field_1690.method_42503().method_41753()).intValue())) {
            this.field_4015.field_1690.method_42503().method_41748((Object)targetDistance);
        }
        if ((Integer)this.field_4015.field_1690.method_42524().method_41753() > 60 && this.averageFps < 30.0f) {
            this.field_4015.field_1690.method_42524().method_41748((Object)60);
        }
        if (this.averageFps < 25.0f) {
            class_4066 currentParticles;
            if (((Boolean)this.field_4015.field_1690.method_42448().method_41753()).booleanValue()) {
                this.field_4015.field_1690.method_42448().method_41748((Object)false);
            }
            if ((currentParticles = (class_4066)this.field_4015.field_1690.method_42475().method_41753()) == class_4066.field_18197) {
                this.field_4015.field_1690.method_42475().method_41748((Object)class_4066.field_18198);
            } else if (currentParticles == class_4066.field_18198 && this.averageFps < 15.0f) {
                this.field_4015.field_1690.method_42475().method_41748((Object)class_4066.field_18199);
            }
        }
        if (this.averageFps < 15.0f) {
            int simDistance;
            if (((Boolean)this.field_4015.field_1690.method_41792().method_41753()).booleanValue()) {
                this.field_4015.field_1690.method_41792().method_41748((Object)false);
            }
            if ((simDistance = ((Integer)this.field_4015.field_1690.method_42510().method_41753()).intValue()) > 5) {
                this.field_4015.field_1690.method_42510().method_41748((Object)Math.max(5, simDistance - 2));
            }
        }
    }

    private void restoreOriginalSettings() {
        if (!this.performanceOptimizationsActive || this.field_4015.field_1690 == null) {
            return;
        }
        this.performanceOptimizationsActive = false;
        if (this.originalRenderDistance != -1) {
            int currentDistance = (Integer)this.field_4015.field_1690.method_42503().method_41753();
            if (this.averageFps > 55.0f && currentDistance < this.originalRenderDistance) {
                int newDistance = Math.min(this.originalRenderDistance, currentDistance + 1);
                this.field_4015.field_1690.method_42503().method_41748((Object)newDistance);
            }
        }
        if (this.averageFps > 50.0f) {
            this.field_4015.field_1690.method_42448().method_41748((Object)this.originalBobView);
            if (this.originalParticlesMode != null) {
                this.field_4015.field_1690.method_42475().method_41748((Object)this.originalParticlesMode);
            }
            this.field_4015.field_1690.method_41792().method_41748((Object)true);
        }
        if (this.averageFps > 45.0f) {
            int currentSimDistance = (Integer)this.field_4015.field_1690.method_42510().method_41753();
            int targetSimDistance = Math.min(10, currentSimDistance + 1);
            this.field_4015.field_1690.method_42510().method_41748((Object)targetSimDistance);
        }
    }

    public float getAverageFps() {
        return this.averageFps;
    }

    public boolean isAdaptiveModeActive() {
        return this.adaptiveMode;
    }

    public boolean arePerformanceOptimizationsActive() {
        return this.performanceOptimizationsActive;
    }
}

