/*
 * Decompiled with CFR 0.152.
 */
package com.example.mixin.client;

import com.example.Veltium;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_542;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_310.class})
public class MinecraftClientMixin {
    private int ticksSinceLastOptimization = 0;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onMinecraftClientInit(class_542 args, CallbackInfo ci) {
        if (Veltium.config.fastMath) {
            System.setProperty("java.awt.headless", "true");
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onClientTick(CallbackInfo ci) {
        ++this.ticksSinceLastOptimization;
        if (this.ticksSinceLastOptimization >= 600) {
            this.ticksSinceLastOptimization = 0;
            this.performMemoryOptimization();
        }
    }

    private void performMemoryOptimization() {
        long totalMemory;
        if (!Veltium.config.smartMemoryManagement) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        double memoryUsage = 1.0 - (double)freeMemory / (double)(totalMemory = runtime.totalMemory());
        if (memoryUsage > 0.85) {
            System.gc();
        }
    }
}

