/*
 * Decompiled with CFR 0.152.
 */
package com.example.mixin.client;

import com.example.Veltium;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_702;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_702.class})
public class ParticleMixin {
    private static long veltiumLastMemoryCheck = 0L;
    private static long veltiumLastGCTime = 0L;
    private static boolean veltiumShouldCullParticles = false;
    private static int veltiumParticleCounter = 0;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void veltiumOptimizeParticles(CallbackInfo ci) {
        if (!Veltium.config.cullParticles || Veltium.config.optimizationLevel < 1) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - veltiumLastMemoryCheck > 1000L) {
            long totalMemory;
            Runtime runtime = Runtime.getRuntime();
            long freeMemory = runtime.freeMemory();
            double memoryUsage = 1.0 - (double)freeMemory / (double)(totalMemory = runtime.totalMemory());
            veltiumShouldCullParticles = memoryUsage > 0.7;
            veltiumLastMemoryCheck = currentTime;
            if (memoryUsage > 0.85 && currentTime - veltiumLastGCTime > 30000L) {
                System.gc();
                veltiumLastGCTime = currentTime;
            }
        }
    }

    @Inject(method={"addParticle"}, at={@At(value="HEAD")}, cancellable=true)
    private void veltiumCullDistantParticles(CallbackInfo ci) {
        if (!Veltium.config.cullParticles) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        int cullRate = this.veltiumGetCullRate(client.method_47599());
        if (++veltiumParticleCounter % cullRate != 0) {
            ci.cancel();
            return;
        }
        if (veltiumShouldCullParticles && veltiumParticleCounter % 2 == 0) {
            ci.cancel();
        }
    }

    private int veltiumGetCullRate(int fps) {
        if (fps < 20) {
            return 5;
        }
        if (fps < 40) {
            return 3;
        }
        if (fps < 60) {
            return 2;
        }
        return 1;
    }
}

