/*
 * Decompiled with CFR 0.152.
 */
package com.example.mixin.client;

import com.example.Veltium;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_761;
import net.minecraft.class_846;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_761.class})
public class WorldRenderMixin {
    private static long lastOptCheck = 0L;
    private static long lastFpsCheck = 0L;
    private static int cachedFps = 30;
    private static boolean isPojavLauncher = false;
    private static boolean lowPerfMode = true;
    private static int frameCounter = 0;
    private static long lastMemCheck = 0L;
    private static boolean lowMemoryMode = false;
    private static final Map<class_2338, Long> blockOutlineCache = new ConcurrentHashMap<class_2338, Long>();
    private static int dynamicRenderDist = 4;
    private static int particleReduction = 4;
    private static int skyRenderSkip = 3;
    @Shadow
    private class_846 field_45614;

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void optimizeWorldRender(CallbackInfo ci) {
        if (Veltium.config.optimizationLevel >= 1 || isPojavLauncher) {
            long currentTime = System.currentTimeMillis();
            ++frameCounter;
            if (currentTime - lastFpsCheck > 1000L) {
                cachedFps = class_310.method_1551().method_47599();
                lastFpsCheck = currentTime;
                lowPerfMode = isPojavLauncher ? cachedFps < 25 : cachedFps < 30;
                this.adjustDynamicRenderDistance();
            }
            if (isPojavLauncher && currentTime - lastMemCheck > 3000L) {
                this.checkMemoryStatus();
                lastMemCheck = currentTime;
            }
            if (currentTime - lastOptCheck > (long)(isPojavLauncher ? 1500 : 3000)) {
                blockOutlineCache.entrySet().removeIf(e -> currentTime - (Long)e.getValue() > 1000L);
                lastOptCheck = currentTime;
            }
        }
    }

    @Inject(method={"setupTerrain"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizeTerrainSetup(class_4184 camera, CallbackInfo ci) {
        if (Veltium.config.optimizationLevel >= 2 && lowPerfMode) {
            int forcedDistance = Math.max(4, dynamicRenderDist / 2);
            class_243 class_2432 = camera.method_19326();
        }
    }

    @Inject(method={"drawBlockOutline"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizeBlockOutline(CallbackInfo ci) {
        if (Veltium.config.optimizationLevel >= 1 || isPojavLauncher) {
            if (isPojavLauncher && (lowPerfMode || lowMemoryMode)) {
                if (frameCounter % 2 != 0) {
                    ci.cancel();
                    return;
                }
            } else if (lowPerfMode) {
                ci.cancel();
                return;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1765 != null && client.field_1765.method_17784() != null) {
                int timeout;
                class_2338 pos = class_2338.method_49638((class_2374)client.field_1765.method_17784());
                Long lastRender = blockOutlineCache.get(pos);
                long now = System.currentTimeMillis();
                int n = timeout = isPojavLauncher ? 100 : 50;
                if (lastRender != null && now - lastRender < (long)timeout) {
                    ci.cancel();
                    return;
                }
                blockOutlineCache.put(pos, now);
            }
        }
    }

    @Inject(method={"renderLayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizeParticleRender(CallbackInfo ci) {
        if (isPojavLauncher) {
            if (frameCounter % particleReduction == 0) {
                ci.cancel();
            }
        } else if (Veltium.config.optimizationLevel >= 3 && lowPerfMode && frameCounter % 3 == 0) {
            ci.cancel();
        }
    }

    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizeSkyRender(CallbackInfo ci) {
        if (isPojavLauncher) {
            if (frameCounter % skyRenderSkip != 0) {
                ci.cancel();
            }
        } else if (Veltium.config.optimizationLevel >= 3 && lowPerfMode && frameCounter % 2 == 0) {
            ci.cancel();
        }
    }

    @Inject(method={"renderWeather"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizeWeatherRender(CallbackInfo ci) {
        if (isPojavLauncher) {
            if (lowMemoryMode && frameCounter % 8 != 0) {
                ci.cancel();
            } else if (frameCounter % 6 != 0) {
                ci.cancel();
            }
        } else if (Veltium.config.optimizationLevel >= 2 && lowPerfMode && frameCounter % 4 != 0) {
            ci.cancel();
        }
    }

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizeCloudsRender(CallbackInfo ci) {
        if (isPojavLauncher && (lowPerfMode || lowMemoryMode)) {
            ci.cancel();
        }
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/WorldRenderer;renderEntities(Lnet/minecraft/client/render/Camera;Lnet/minecraft/client/render/VertexConsumerProvider$Immediate;Lnet/minecraft/client/render/LightmapTextureManager;Lnet/minecraft/client/render/MatrixStack;)V"), index=0)
    private double optimizeEntityRenderDistance(double distance) {
        if (isPojavLauncher) {
            if (lowMemoryMode) {
                return Math.min(distance, 16.0);
            }
            if (lowPerfMode) {
                return Math.min(distance, 24.0);
            }
            return Math.min(distance, 32.0);
        }
        if (Veltium.config.optimizationLevel >= 2 && lowPerfMode) {
            return Math.min(distance, 32.0);
        }
        return distance;
    }

    @Inject(method={"setupTerrain"}, at={@At(value="HEAD")})
    private void optimizeTerrainSetupExtra(CallbackInfo ci) {
    }

    private void adjustDynamicRenderDistance() {
        if (isPojavLauncher) {
            if (cachedFps > 35) {
                dynamicRenderDist = Math.min(8, dynamicRenderDist + 1);
            } else if (cachedFps < 15) {
                dynamicRenderDist = Math.max(2, dynamicRenderDist - 2);
            } else if (cachedFps < 25) {
                dynamicRenderDist = Math.max(3, dynamicRenderDist - 1);
            }
        } else if (cachedFps > 60) {
            dynamicRenderDist = Math.min(32, dynamicRenderDist + 1);
        } else if (cachedFps < 30) {
            dynamicRenderDist = Math.max(4, dynamicRenderDist - 2);
        }
    }

    private void checkMemoryStatus() {
        long max;
        Runtime runtime = Runtime.getRuntime();
        long used = runtime.totalMemory() - runtime.freeMemory();
        double usage = (double)used / (double)(max = runtime.maxMemory());
        boolean bl = lowMemoryMode = usage > 0.8;
        if (usage > 0.85) {
            System.gc();
        }
    }

    static {
        String vmName = System.getProperty("java.vm.name", "").toLowerCase();
        String osName = System.getProperty("os.name", "").toLowerCase();
        boolean bl = isPojavLauncher = vmName.contains("android") || osName.contains("android") || System.getProperty("pojav.launcher") != null;
        if (isPojavLauncher) {
            dynamicRenderDist = 3;
            particleReduction = 6;
            skyRenderSkip = 4;
        }
    }
}

