/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.config.YACLConfig;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4063;
import net.minecraft.class_4066;
import net.minecraft.class_5250;
import net.minecraft.class_5365;
import net.minecraft.class_640;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class TemplateModClient
implements ClientModInitializer {
    public static YACLConfig config;
    private static class_304 configKeyBinding;
    private long lastHudUpdate = 0L;
    private long lastGC = 0L;
    private String cachedTime = "";
    private int cachedPing = 0;
    private boolean messageSent = false;
    private final List<ColoredText> hudLines = new ArrayList<ColoredText>();
    private final List<Integer> fpsHistory = new ArrayList<Integer>();
    private final List<Double> memoryHistory = new ArrayList<Double>();
    private final List<Integer> pingHistory = new ArrayList<Integer>();
    private static final int MAX_HISTORY = 100;

    public void onInitializeClient() {
        config = YACLConfig.getInstance();
        configKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.optimizationmod.config", class_3675.class_307.field_1668, 79, "category.optimizationmod"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!this.messageSent && client.field_1724 != null && TemplateModClient.config.modEnabled && TemplateModClient.config.showNotifications) {
                client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"text.optimizationmod.message.loaded"));
                this.messageSent = true;
            }
            while (configKeyBinding.method_1436()) {
                client.method_1507(YACLConfig.createConfigScreen(client.field_1755));
            }
            this.applyOptimizations(client);
        });
        HudRenderCallback.EVENT.register(this::renderHud);
        System.out.println("Veltium \u043c\u043e\u0434 \u0456\u043d\u0456\u0446\u0456\u0430\u043b\u0456\u0437\u043e\u0432\u0430\u043d\u043e!");
    }

    private void applyOptimizations(class_310 client) {
        Runtime runtime;
        long usedMemory;
        if (!TemplateModClient.config.modEnabled || TemplateModClient.config.optimizationLevel == 0 || client.field_1690 == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (TemplateModClient.config.optimizationLevel >= 2) {
            client.field_1690.method_42448().method_41748((Object)false);
            client.field_1690.method_42435().method_41748((Object)false);
        }
        if (TemplateModClient.config.optimizationLevel >= 3) {
            client.field_1690.method_42528().method_41748((Object)class_4063.field_18162);
            client.field_1690.method_42534().method_41748((Object)class_5365.field_25427);
            client.field_1690.method_42475().method_41748((Object)class_4066.field_18198);
        }
        if (TemplateModClient.config.reduceLag && currentTime - this.lastGC > 30000L && (double)(usedMemory = (runtime = Runtime.getRuntime()).totalMemory() - runtime.freeMemory()) > (double)runtime.maxMemory() * 0.8) {
            System.gc();
            this.lastGC = currentTime;
        }
    }

    private void renderHud(class_332 drawContext, class_9779 renderTickCounter) {
        class_310 client = class_310.method_1551();
        if (!TemplateModClient.config.modEnabled || client.field_1724 == null || client.method_53526().method_53536() || client.field_1690.field_1842) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastHudUpdate > (long)TemplateModClient.config.hudUpdateInterval) {
            this.updateCache(client);
            this.updateStatistics(client);
            this.lastHudUpdate = currentTime;
        }
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_22905(TemplateModClient.config.hudScale, TemplateModClient.config.hudScale, 1.0f);
        this.renderHudElements(drawContext, client);
        drawContext.method_51448().method_22909();
    }

    private void updateStatistics(class_310 client) {
        int currentFps = client.method_47599();
        this.fpsHistory.add(currentFps);
        if (this.fpsHistory.size() > 100) {
            this.fpsHistory.removeFirst();
        }
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        double memoryUsagePercent = (double)usedMemory / (double)maxMemory * 100.0;
        this.memoryHistory.add(memoryUsagePercent);
        if (this.memoryHistory.size() > 100) {
            this.memoryHistory.removeFirst();
        }
        this.pingHistory.add(this.cachedPing);
        if (this.pingHistory.size() > 100) {
            this.pingHistory.removeFirst();
        }
    }

    private int getFpsMin() {
        return this.fpsHistory.isEmpty() ? 0 : Collections.min(this.fpsHistory);
    }

    private int getFpsAvg() {
        return this.fpsHistory.isEmpty() ? 0 : (int)this.fpsHistory.stream().mapToInt(Integer::intValue).average().orElse(0.0);
    }

    private int getFpsMax() {
        return this.fpsHistory.isEmpty() ? 0 : Collections.max(this.fpsHistory);
    }

    private double getMemoryMin() {
        return this.memoryHistory.isEmpty() ? 0.0 : Collections.min(this.memoryHistory);
    }

    private double getMemoryAvg() {
        return this.memoryHistory.isEmpty() ? 0.0 : this.memoryHistory.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
    }

    private double getMemoryMax() {
        return this.memoryHistory.isEmpty() ? 0.0 : Collections.max(this.memoryHistory);
    }

    private int getPingMin() {
        return this.pingHistory.isEmpty() ? 0 : Collections.min(this.pingHistory);
    }

    private int getPingAvg() {
        return this.pingHistory.isEmpty() ? 0 : (int)this.pingHistory.stream().mapToInt(Integer::intValue).average().orElse(0.0);
    }

    private int getPingMax() {
        return this.pingHistory.isEmpty() ? 0 : Collections.max(this.pingHistory);
    }

    private void renderHudElements(class_332 drawContext, class_310 client) {
        this.hudLines.clear();
        if (TemplateModClient.config.showFpsCounter) {
            int fps = client.method_47599();
            int fpsColor = config.getFpsColor(fps);
            if (TemplateModClient.config.showAdvancedFps && !this.fpsHistory.isEmpty()) {
                int fpsMin = this.getFpsMin();
                int fpsAvg = this.getFpsAvg();
                int fpsMax = this.getFpsMax();
                String fpsText = class_2561.method_43469((String)"text.optimizationmod.hud.fps_stats", (Object[])new Object[]{fps, fpsMin, fpsAvg, fpsMax}).getString();
                this.hudLines.add(new ColoredText(fpsText, fpsColor));
            } else {
                String fpsText = class_2561.method_43469((String)"text.optimizationmod.hud.fps", (Object[])new Object[]{fps}).getString();
                this.hudLines.add(new ColoredText(fpsText, fpsColor));
            }
        }
        if (TemplateModClient.config.showMemoryUsage) {
            Runtime runtime = Runtime.getRuntime();
            long usedMemory = runtime.totalMemory() - runtime.freeMemory();
            long maxMemory = runtime.maxMemory();
            long usedMB = usedMemory / 0x100000L;
            long maxMB = maxMemory / 0x100000L;
            int percentage = (int)(usedMemory * 100L / maxMemory);
            double memoryUsagePercent = (double)usedMemory / (double)maxMemory * 100.0;
            int memoryColor = config.getMemoryColor(memoryUsagePercent);
            if (TemplateModClient.config.showAdvancedMemory && !this.memoryHistory.isEmpty()) {
                double memoryMin = this.getMemoryMin();
                double memoryAvg = this.getMemoryAvg();
                double memoryMax = this.getMemoryMax();
                String memoryText = class_2561.method_43469((String)"text.optimizationmod.hud.memory_stats", (Object[])new Object[]{String.format("%dMB/%dMB (%d%%)", usedMB, maxMB, percentage), String.format("%.1f%%", memoryMin), String.format("%.1f%%", memoryAvg), String.format("%.1f%%", memoryMax)}).getString();
                this.hudLines.add(new ColoredText(memoryText, memoryColor));
            } else {
                String memoryText = class_2561.method_43469((String)"text.optimizationmod.hud.memory", (Object[])new Object[]{usedMB, maxMB, percentage}).getString();
                this.hudLines.add(new ColoredText(memoryText, memoryColor));
            }
        }
        if (TemplateModClient.config.showPing && client.method_1562() != null) {
            int pingColor = config.getPingColor(this.cachedPing);
            if (TemplateModClient.config.showAdvancedPing && !this.pingHistory.isEmpty()) {
                int pingMin = this.getPingMin();
                int pingAvg = this.getPingAvg();
                int pingMax = this.getPingMax();
                String pingText = class_2561.method_43469((String)"text.optimizationmod.hud.ping_stats", (Object[])new Object[]{this.cachedPing, pingMin, pingAvg, pingMax}).getString();
                this.hudLines.add(new ColoredText(pingText, pingColor));
            } else {
                String pingText = class_2561.method_43469((String)"text.optimizationmod.hud.ping", (Object[])new Object[]{this.cachedPing}).getString();
                this.hudLines.add(new ColoredText(pingText, pingColor));
            }
        }
        if (TemplateModClient.config.showCoordinates && client.field_1724 != null) {
            double x = (double)Math.round(client.field_1724.method_23317() * 10.0) / 10.0;
            double y = (double)Math.round(client.field_1724.method_23318() * 10.0) / 10.0;
            double z = (double)Math.round(client.field_1724.method_23321() * 10.0) / 10.0;
            String coordsText = class_2561.method_43469((String)"text.optimizationmod.hud.coordinates", (Object[])new Object[]{x, y, z}).getString();
            this.hudLines.add(new ColoredText(coordsText, TemplateModClient.config.coordinatesColor));
        }
        if (TemplateModClient.config.showTime) {
            String timeText = class_2561.method_43469((String)"text.optimizationmod.hud.time", (Object[])new Object[]{this.cachedTime}).getString();
            this.hudLines.add(new ColoredText(timeText, TemplateModClient.config.timeColor));
        }
        if (this.hudLines.isEmpty()) {
            return;
        }
        int totalHeight = this.hudLines.size() * 12 + 8;
        int padding = 4;
        for (int i = 0; i < this.hudLines.size(); ++i) {
            ColoredText line = this.hudLines.get(i);
            int textWidth = client.field_1772.method_1727(line.text);
            int finalX = this.getHudX(client, textWidth);
            int finalY = this.getHudY(client, totalHeight) + i * 12;
            if (TemplateModClient.config.hudBackgroundColor != 0 && TemplateModClient.config.hudBackgroundOpacity > 0.0f) {
                int bgColor = TemplateModClient.config.hudBackgroundColor & 0xFFFFFF | (int)(TemplateModClient.config.hudBackgroundOpacity * 255.0f) << 24;
                drawContext.method_25294(finalX - padding, finalY - padding, finalX + textWidth + padding, finalY + 12 - padding, bgColor);
            }
            if (TemplateModClient.config.showCoordinates && TemplateModClient.config.enableCoordinateColors && line.text.contains("XYZ")) {
                this.renderColoredCoordinates(drawContext, client, line.text, finalX, finalY);
                continue;
            }
            this.renderTextLine(drawContext, client, line.text, finalX, finalY, line.color);
        }
    }

    private void renderColoredCoordinates(class_332 drawContext, class_310 client, String text, int x, int y) {
        int colonIndex = text.indexOf(58);
        if (colonIndex == -1) {
            this.renderTextLine(drawContext, client, text, x, y, TemplateModClient.config.coordinatesColor);
            return;
        }
        String prefix = text.substring(0, colonIndex + 2);
        String coordinates = text.substring(colonIndex + 2);
        String[] parts = coordinates.trim().split(" ");
        if (parts.length >= 3) {
            int currentX = x;
            this.renderTextLine(drawContext, client, prefix, currentX, y, TemplateModClient.config.coordinatesColor);
            this.renderTextLine(drawContext, client, parts[0], currentX += client.field_1772.method_1727(prefix), y, TemplateModClient.config.coordinatesXColor);
            this.renderTextLine(drawContext, client, parts[1], currentX += client.field_1772.method_1727(parts[0] + " "), y, TemplateModClient.config.coordinatesYColor);
            this.renderTextLine(drawContext, client, parts[2], currentX += client.field_1772.method_1727(parts[1] + " "), y, TemplateModClient.config.coordinatesZColor);
        } else {
            this.renderTextLine(drawContext, client, text, x, y, TemplateModClient.config.coordinatesColor);
        }
    }

    private void updateCache(class_310 client) {
        if (client.method_1562() != null && client.field_1724 != null) {
            try {
                class_640 playerEntry = client.method_1562().method_2871(client.field_1724.method_5667());
                this.cachedPing = playerEntry != null ? playerEntry.method_2959() : 0;
            }
            catch (Exception e) {
                this.cachedPing = 0;
            }
        }
        LocalDateTime now = LocalDateTime.now();
        this.cachedTime = now.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    private void renderTextLine(class_332 drawContext, class_310 client, String text, int x, int y, int color) {
        if (text == null || text.isEmpty()) {
            return;
        }
        class_5250 mutableText = class_2561.method_43470((String)text);
        if (TemplateModClient.config.hudBold) {
            mutableText = mutableText.method_27692(class_124.field_1067);
        }
        int finalColor = color & 0xFFFFFF | (int)(Math.max(0.1f, TemplateModClient.config.hudTextOpacity) * 255.0f) << 24;
        if (TemplateModClient.config.hudShadow) {
            drawContext.method_27535(client.field_1772, (class_2561)mutableText, x, y, finalColor);
        } else {
            drawContext.method_51439(client.field_1772, (class_2561)mutableText, x, y, finalColor, false);
        }
    }

    private int getHudX(class_310 client, int textWidth) {
        int screenWidth = (int)((float)client.method_22683().method_4486() / TemplateModClient.config.hudScale);
        if (TemplateModClient.config.cornerSnap) {
            return switch (TemplateModClient.config.hudPosition) {
                case YACLConfig.HudPosition.TOP_RIGHT, YACLConfig.HudPosition.BOTTOM_RIGHT -> screenWidth - textWidth - 1;
                default -> 1;
            };
        }
        int scaledOffsetX = (int)((float)TemplateModClient.config.hudX / TemplateModClient.config.hudScale);
        return switch (TemplateModClient.config.hudPosition) {
            case YACLConfig.HudPosition.TOP_RIGHT, YACLConfig.HudPosition.BOTTOM_RIGHT -> Math.max(0, screenWidth - textWidth - scaledOffsetX);
            default -> Math.max(0, scaledOffsetX);
        };
    }

    private int getHudY(class_310 client, int hudHeight) {
        int screenHeight = (int)((float)client.method_22683().method_4502() / TemplateModClient.config.hudScale);
        int scaledHudHeight = (int)((float)hudHeight / TemplateModClient.config.hudScale);
        if (TemplateModClient.config.cornerSnap) {
            return switch (TemplateModClient.config.hudPosition) {
                case YACLConfig.HudPosition.BOTTOM_RIGHT, YACLConfig.HudPosition.BOTTOM_LEFT -> screenHeight - scaledHudHeight - 1;
                default -> 1;
            };
        }
        int scaledOffsetY = (int)((float)TemplateModClient.config.hudY / TemplateModClient.config.hudScale);
        return switch (TemplateModClient.config.hudPosition) {
            case YACLConfig.HudPosition.BOTTOM_RIGHT, YACLConfig.HudPosition.BOTTOM_LEFT -> Math.max(0, screenHeight - scaledHudHeight - scaledOffsetY);
            default -> Math.max(0, scaledOffsetY);
        };
    }

    @Environment(value=EnvType.CLIENT)
    private static class ColoredText {
        final String text;
        final int color;

        ColoredText(String text, int color) {
            this.text = text;
            this.color = color;
        }
    }
}

