/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl;

import net.minecraft.world.damagesource.DamageSource;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.abilities.MorphAbility;
import xyz.nifeather.morph.abilities.options.DryoutAbilityOption;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.utilities.DamageSourceUtils;
import xyz.nifeather.morph.utilities.MathUtils;

public class DryOutInAirAbility
extends MorphAbility<DryoutAbilityOption> {
    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return AbilityNames.DRYOUT_IN_AIR;
    }

    @Override
    public boolean handle(Player player, DisguiseState state) {
        this.updateOxygen(player, (DryoutAbilityOption)this.getOptionFor(state));
        return true;
    }

    @Override
    @NotNull
    public ISkillAbilityOptionHandler<DryoutAbilityOption> optionHandler() {
        return DryoutAbilityOption.OPTION_HANDLER;
    }

    private void updateOxygen(Player player, @Nullable DryoutAbilityOption option) {
        if (option == null) {
            return;
        }
        int air = player.getRemainingAir();
        air -= (option.includeRain ? player.isInWater() : player.isInWater() || player.isInRain()) ? -5 : 5;
        air = MathUtils.clamp(-20, player.getMaximumAir(), air);
        if (air <= -20) {
            NmsRecord nmsRecord = NmsRecord.of(player);
            DamageSourceUtils.NotScalableDamageSource source = DamageSourceUtils.toNotScalable(nmsRecord.nmsWorld().damageSources().dryOut()).bypassEverything();
            nmsRecord.nmsPlayer().hurtServer(nmsRecord.nmsWorld(), (DamageSource)source, 2.0f);
            air = 0;
        }
        player.setRemainingAir(air);
    }
}

