/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.listeners;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.ServerBackend;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.ProtocolListener;
import xyz.nifeather.morph.backends.server.renderer.network.registries.RenderRegistry;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class SpawnPacketHandler
extends ProtocolListener {
    @Resolved(shouldSolveImmediately=true)
    private RenderRegistry registry;

    @Override
    public String getIdentifier() {
        return "spawn_listener";
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Play.Server.SPAWN_ENTITY) {
            return;
        }
        WrapperPlayServerSpawnEntity wrapper = new WrapperPlayServerSpawnEntity(event);
        this.onEntityAddPacket(wrapper, event);
    }

    private void onEntityAddPacket(WrapperPlayServerSpawnEntity packet, PacketSendEvent packetEvent) {
        ServerBackend backend = ServerBackend.getInstance();
        if (backend == null) {
            return;
        }
        UUID uuid = packet.getUUID().orElse(null);
        if (uuid == null) {
            return;
        }
        SingleWatcher bindingWatcher = this.registry.getWatcher(uuid);
        if (bindingWatcher == null) {
            return;
        }
        if (packet.getData() == 10998) {
            return;
        }
        try {
            Player disguisedPlayer = Bukkit.getPlayer((UUID)uuid);
            if (disguisedPlayer != null) {
                Player affectedPlayer = (Player)packetEvent.getPlayer();
                backend.serverRenderer.refreshStateForPlayer(disguisedPlayer, List.of(affectedPlayer));
                packetEvent.setCancelled(true);
            }
        }
        catch (Throwable t) {
            Player sourcePlayer = this.getPlayerFrom(packet.getEntityId());
            this.handleException(sourcePlayer, bindingWatcher, t);
        }
    }
}

