/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin.applets;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.commands.brigadier.BrigadierCommand;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class SchedulerTestCommand
extends BrigadierCommand {
    private final AtomicInteger scheduleCount = new AtomicInteger(0);
    private final AtomicInteger taskId = new AtomicInteger(0);
    @Nullable
    private ExecutorService threadPoolExecutor;

    @Override
    @Nullable
    public String getPermissionRequirement() {
        return "feathermorph.admin";
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(Commands.literal((String)this.name()).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::execute)));
        super.registerAsChild(parentBuilder);
    }

    private int execute(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        int limit = IntegerArgumentType.getInteger(context, (String)"count");
        this.logger.info("Executing scheduler leak test with limit: " + limit);
        if (this.threadPoolExecutor != null) {
            this.threadPoolExecutor.shutdownNow();
            this.threadPoolExecutor = null;
        }
        this.scheduleCount.set(0);
        this.threadPoolExecutor = Executors.newFixedThreadPool(20, new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable run) {
                Thread ret = new Thread(run);
                ret.setName("Test Thread #" + this.count.getAndIncrement());
                ret.setUncaughtExceptionHandler((thread, throwable) -> SchedulerTestCommand.this.logger.error("Uncaught exception in thread " + thread.getName(), throwable));
                return ret;
            }
        });
        AtomicInteger cc = new AtomicInteger();
        AtomicInteger server = new AtomicInteger();
        for (int i = 0; i < 20; ++i) {
            CompletableFuture.runAsync(() -> {
                while (cc.get() < limit) {
                    cc.addAndGet(1);
                    this.plugin.schedule(() -> {
                        int xxc = 0;
                        ++xxc;
                        ObjectArrayList list = new ObjectArrayList();
                        list.addAll(List.of(Integer.valueOf(1103), "CCB", Float.valueOf(994.14f)));
                        int xx = server.addAndGet(1);
                        sender.sendActionBar((Component)Component.text((String)"Hello from Thread %s! complete schedule is %s".formatted(Thread.currentThread().getName(), xx)));
                    });
                }
                this.logger.info("%s Complete: %s".formatted(Thread.currentThread().getName(), cc.get()));
            }, this.threadPoolExecutor);
        }
        this.plugin.schedule(() -> sender.sendMessage("Ran %s/%s tasks --> %s".formatted(cc.get(), limit, ((FeatherMorphMain)this.plugin).execSchedules)), 20);
        return 1;
    }

    @Override
    @NotNull
    public String name() {
        return "scheduler_leak_test";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return null;
    }
}

