/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.messages;

import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.platform.CurrentPlatform;
import xyz.nifeather.morph.platform.entity.IPlatformPlayer;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Managers.DependencyManager;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class MessageUtils
extends MorphPluginObject {
    private static DependencyManager pluginDepMgr;
    private static MorphConfigManager config;
    private static FeatherMorphMain plugin;
    private static MorphConfigManager configManager;
    private static final Bindable<String> serverLocale;
    private static final Bindable<Boolean> singleLanguage;

    private static void setupConfigManager() {
        if (pluginDepMgr == null) {
            pluginDepMgr = DependencyManager.getInstance(FeatherMorphMain.getMorphNameSpace());
        }
        config = pluginDepMgr.get(MorphConfigManager.class);
        plugin = FeatherMorphMain.getInstance();
    }

    public static void send(CommandSender sender, String m) {
        FormattableMessage context = new FormattableMessage(FeatherMorphMain.getInstance(), "<content>").resolve("content", locale -> Component.text((String)m));
        MessageUtils.send(sender, context);
    }

    public static void send(CommandSender sender, Component ... componentArray) {
        TextComponent finalComponent = Component.empty();
        for (Component subComponent : componentArray) {
            finalComponent = (TextComponent)finalComponent.append(subComponent);
        }
        TextComponent finalComponent1 = finalComponent;
        FormattableMessage context = new FormattableMessage(FeatherMorphMain.getInstance(), "<content>").resolve("content", arg_0 -> MessageUtils.lambda$send$1((Component)finalComponent1, arg_0));
        MessageUtils.send(sender, context);
    }

    public static void send(CommandSender sender, FormattableMessage context) {
        MessageUtils.send(sender, context, List.of());
    }

    public static void send(CommandSender sender, FormattableMessage context, Function<Component, Component> componentModifier) {
        MessageUtils.send(sender, context, List.of(componentModifier));
    }

    public static void send(CommandSender sender, FormattableMessage context, List<Function<Component, Component>> componentModifiers) {
        if (config == null) {
            MessageUtils.setupConfigManager();
        }
        FormattableMessage rootMessage = new FormattableMessage(FeatherMorphMain.getInstance(), config.getOrDefault(String.class, ConfigOption.PLUGIN_PREFIX));
        Component inputComponent = context.createComponent();
        if (inputComponent.equals((Object)Component.empty())) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                FeatherMorphMain.getInstance().getSLF4JLogger().info("[DEBUG] Ignoring empty message");
            }
            return;
        }
        Component outputComponent = rootMessage.resolve("message", context).createComponent(MessageUtils.getLocale(sender));
        for (Function<Component, Component> componentModifier : componentModifiers) {
            outputComponent = componentModifier.apply(outputComponent);
        }
        sender.sendMessage(outputComponent);
    }

    @NotNull
    public static String getLocale(IPlatformPlayer player) {
        return MessageUtils.getLocale(CurrentPlatform.instance().entityLookup().getNativePlayer(player));
    }

    @NotNull
    public static String getLocale(Player player) {
        if (MessageUtils.isSingleLanguage()) {
            return MessageUtils.getServerLocale();
        }
        String nmsLocale = NmsRecord.ofPlayer((Player)player).language;
        return nmsLocale == null ? MessageUtils.getServerLocale() : nmsLocale.toLowerCase().replace('-', '_');
    }

    @NotNull
    public static String getLocaleOr(CommandSender sender, @NotNull String defaultValue) {
        String locale = MessageUtils.getLocale(sender);
        return locale == null ? defaultValue : locale;
    }

    private static void initializeConfigManager() {
        if (configManager != null) {
            return;
        }
        DependencyManager depMgr = DependencyManager.getInstance(FeatherMorphMain.getMorphNameSpace());
        MorphConfigManager config = depMgr.get(MorphConfigManager.class);
        if (config != null) {
            config.bind(serverLocale, ConfigOption.LANGUAGE_CODE);
            config.bind(singleLanguage, ConfigOption.SINGLE_LANGUAGE);
        }
        configManager = config;
    }

    public static String getServerLocale() {
        MessageUtils.initializeConfigManager();
        return serverLocale.get();
    }

    public static boolean isSingleLanguage() {
        MessageUtils.initializeConfigManager();
        return singleLanguage.get();
    }

    @Nullable
    public static String getLocale(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!MessageUtils.isSingleLanguage()) {
                return MessageUtils.getLocale(player);
            }
        }
        return MessageUtils.getServerLocale();
    }

    private static /* synthetic */ Component lambda$send$1(Component finalComponent1, String locale) {
        return finalComponent1;
    }

    static {
        serverLocale = new Bindable<String>("zh_cn");
        singleLanguage = new Bindable<Boolean>(true);
    }
}

