/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.messages.vanilla;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.messages.vanilla.BasicVanillaMessageStore;
import xyz.nifeather.morph.messages.vanilla.VanillaMessageSubStore;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;

public class VanillaMessageStore
extends BasicVanillaMessageStore {
    private final Bindable<String> serverLocale = new Bindable<String>("en_us");
    private final Map<String, VanillaMessageSubStore> subStores = new Object2ObjectOpenHashMap();

    @Initializer
    private void load(MorphConfigManager config) {
        config.bind(this.serverLocale, ConfigOption.LANGUAGE_CODE);
        this.serverLocale.onValueChanged((o, n) -> {
            if (n.equalsIgnoreCase("en_us")) {
                return;
            }
            this.getOrCreateSubStore((String)n);
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BasicVanillaMessageStore getOrCreateSubStore(String locale) {
        if (locale.equalsIgnoreCase("en_us")) {
            return this;
        }
        VanillaMessageSubStore store = null;
        Map<String, VanillaMessageSubStore> map = this.subStores;
        synchronized (map) {
            store = this.subStores.getOrDefault(locale, null);
            if (store != null) {
                return store;
            }
            store = new VanillaMessageSubStore(locale);
            store.initializeStorage();
            store.saveConfiguration();
            this.subStores.put(locale, store);
        }
        return store;
    }

    public Component getComponent(String key, @Nullable String defaultValue, @Nullable String locale) {
        String msg = this.get(key, defaultValue, locale);
        return msg == null ? Component.translatable((String)key) : Component.text((String)msg);
    }

    @Override
    public String get(String key, @Nullable String defaultValue, @Nullable String locale) {
        if (locale == null || locale.isBlank() || locale.isEmpty()) {
            this.logger.warn("Resolving key " + key + " for null or empty locale");
            locale = "en_us";
        }
        if (locale.equals("en_us")) {
            return super.get(key, defaultValue, null);
        }
        BasicVanillaMessageStore store = this.getOrCreateSubStore(locale);
        return store.get(key, defaultValue, locale);
    }

    @Override
    public boolean reloadConfiguration() {
        this.subStores.clear();
        return super.reloadConfiguration();
    }

    @Override
    @NotNull
    protected String getLocaleCode() {
        return this.serverLocale.get();
    }
}

