/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class BlockDestroyHandler {
    private Player player;
    private ServerPlayer nmsPlayer;
    private float progress = -1.0f;
    private long lastUpdate;
    private long lastDestroy;
    @Nullable
    private Block block;
    private ServerLevel nmsWorld;
    private BlockState nmsBlock;

    public BlockDestroyHandler(@Nullable Block block, float progress, Player player) {
        this.progress = progress;
        this.setPlayer(player);
        this.changeBlock(block);
    }

    private void setPlayer(Player player) {
        this.player = player;
        this.nmsPlayer = ((CraftPlayer)player).getHandle();
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean setProgress(float newProgress, long currentTick) {
        boolean instant;
        float delta = newProgress - this.progress;
        boolean bl = instant = delta > 1.0f;
        if (!instant && currentTick - this.lastUpdate < 1L) {
            return false;
        }
        this.lastUpdate = currentTick;
        if (this.progress == newProgress || currentTick - this.lastDestroy < 6L && delta > 0.0f && !instant) {
            return false;
        }
        this.progress = newProgress;
        if (this.block != null) {
            newProgress = newProgress > 1.0f ? -1.0f : newProgress;
            this.nmsWorld.destroyBlockProgress(this.nmsPlayer.getId(), ((CraftBlock)this.block).getPosition(), this.clamp(-1, 100, (int)(newProgress * 10.0f) - 1));
        }
        if (this.progress > 1.0f) {
            this.lastDestroy = currentTick;
            if (this.block != null) {
                this.player.breakBlock(this.block);
            }
            this.changeBlock(null);
        }
        return true;
    }

    private int clamp(int min, int max, int val) {
        return val < min ? min : Math.min(val, max);
    }

    public float getProgress() {
        return this.progress;
    }

    @Nullable
    public Block getBlock() {
        return this.block;
    }

    @Nullable
    public ServerLevel getNmsWorld() {
        return this.nmsWorld;
    }

    @Nullable
    public BlockState getNmsBlock() {
        return this.nmsBlock;
    }

    public void changeBlock(@Nullable Block block) {
        this.nmsBlock = null;
        this.nmsWorld = null;
        this.block = block;
        if (block != null) {
            this.nmsBlock = ((CraftBlock)block).getNMS();
            this.nmsWorld = ((CraftWorld)block.getWorld()).getHandle();
        }
        this.setProgress(0.0f, this.lastUpdate + 2L);
    }
}

