/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.misc.ISupportDiffs;
import xyz.nifeather.morph.misc.actions.BiConsumerActions;
import xyz.nifeather.morph.misc.disguiseProperty.IPropertyValidateHandle;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyValidationException;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.AbstractProperties;

public class PropertyHandler {
    private final Map<SingleProperty<?>, Object> propertyMap = new ConcurrentHashMap();
    private final List<SingleProperty<?>> validProperties = new CopyOnWriteArrayList();
    protected final BiConsumerActions<SingleProperty<?>, Object> actions = new BiConsumerActions();
    @Nullable
    private AbstractProperties<?> bindingProperties;

    public <X> void hookOnPropertyWrite(BiConsumer<SingleProperty<X>, X> consumer) {
        this.actions.hook(consumer);
    }

    public Map<String, String> toNetworkProperties() {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        try {
            for (Map.Entry<SingleProperty<?>, Object> entry : this.propertyMap.entrySet()) {
                SingleProperty<?> property = entry.getKey();
                Object value = entry.getValue();
                map.put(property.id(), property.forValue(value));
            }
        }
        catch (ParseErrorException e) {
            FeatherMorphMain.getInstance().getSLF4JLogger().error("Failed writing full network map, some properties may not be synced!", (Throwable)e);
        }
        return map;
    }

    @Nullable
    public AbstractProperties<?> bindingProperties() {
        return this.bindingProperties;
    }

    public void initProperties(AbstractProperties<?> properties) {
        this.reset();
        this.bindingProperties = properties;
        this.validProperties.addAll(properties.getRegisteredProperties().values());
    }

    public void updateFromPropertiesInput(Map<String, String> input) throws ParseErrorException, PropertyValidationException {
        this.updateFromPropertiesInput(input, map -> {});
    }

    public void updateFromPropertiesInput(Map<String, String> input, IPropertyValidateHandle validateHandle) throws ParseErrorException, PropertyValidationException {
        if (this.bindingProperties == null) {
            FeatherMorphMain.getInstance().getSLF4JLogger().warn("Trying to update property input while a PropertyHandler has not been initialized?!");
            return;
        }
        Map<SingleProperty<?>, Object> results = this.bindingProperties.readFromPropertiesInput(input);
        validateHandle.validate(results);
        results.forEach(this::writeGeneric);
    }

    public void reset() {
        this.validProperties.clear();
        this.bindingProperties = null;
        this.clearProperties();
    }

    public void clearProperties() {
        this.propertyMap.clear();
    }

    private void writeGeneric(SingleProperty<?> property, Object value) {
        if (!property.type().isInstance(value)) {
            throw new IllegalArgumentException("Incompatible value for id '%s', excepted for '%s', but got '%s'".formatted(property.id(), property.defaultVal().getClass(), value.getClass()));
        }
        this.set(property, value);
    }

    public <X> void set(SingleProperty<X> property, @NotNull X value) throws NullPointerException {
        if (!this.validProperties.contains(property)) {
            FeatherMorphMain.getInstance().getSLF4JLogger().warn("The given property '%s' doesn't exist in '%s'".formatted(property.id(), this.bindingProperties));
            return;
        }
        Objects.requireNonNull(value, "Null values are not accepted");
        Object existing = this.getOptional(property).orElse(null);
        if (!value.equals(existing)) {
            X diffIfPossible;
            if (existing instanceof ISupportDiffs) {
                ISupportDiffs existingDiff = existing;
                diffIfPossible = existingDiff.diff(value);
            } else {
                diffIfPossible = value;
            }
            this.propertyMap.put(property, value);
            this.actions.invoke(BiConsumerActions.pair(property, diffIfPossible));
        }
    }

    public boolean contains(SingleProperty<?> property) {
        return this.propertyMap.containsKey(property);
    }

    @NotNull
    public <X> X get(SingleProperty<X> property) {
        return this.getOr(property, property.defaultVal());
    }

    public <X> Optional<X> getOptional(SingleProperty<X> property) {
        return Optional.ofNullable(this.getOr(property, null));
    }

    @Nullable
    @Contract(value="_, null -> _; _, !null -> !null")
    public <X> X getOr(SingleProperty<X> property, X defaultVal) {
        return (X)this.propertyMap.getOrDefault(property, defaultVal);
    }

    @Nullable
    @Contract(value="_, null -> _; _, !null -> !null")
    public <X> X getOr(String propertyName, @Nullable X defaultVal) {
        SingleProperty property = this.validProperties.stream().filter(p -> p.id().equals(propertyName)).findFirst().orElse(null);
        if (property == null) {
            return defaultVal;
        }
        return this.getOr(property, defaultVal);
    }

    public Map<SingleProperty<?>, ?> getAll() {
        return new Object2ObjectArrayMap(this.propertyMap);
    }

    public void copyTo(PropertyHandler other) {
        this.propertyMap.forEach((k, v) -> other.set((SingleProperty)k, (Object)v));
    }

    public boolean bindingPropertiesEquals(PropertyHandler other) {
        return other.bindingProperties != null && this.bindingPropertiesEquals(other.bindingProperties);
    }

    public boolean bindingPropertiesEquals(AbstractProperties<?> other) {
        return this.bindingProperties != null && this.bindingProperties.equals(other);
    }

    public void dispose() {
        this.actions.clear();
    }
}

