/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.commands.C2S;

import java.util.Arrays;
import java.util.Map;
import xyz.nifeather.morph.network.BasicClientHandler;
import xyz.nifeather.morph.network.annotations.Environment;
import xyz.nifeather.morph.network.annotations.EnvironmentType;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.utils.Asserts;

public class C2SExchangeRequestManagementCommand
extends AbstractC2SCommand<String> {
    @Environment(value=EnvironmentType.SERVER)
    public Decision decision;
    @Environment(value=EnvironmentType.SERVER)
    public String targetRequestName;

    public C2SExchangeRequestManagementCommand(Decision decision, String targetRequestName) {
        this.decision = decision;
        this.targetRequestName = targetRequestName;
    }

    public static C2SExchangeRequestManagementCommand fromArguments(Map<String, String> arguments) throws RuntimeException {
        String decisionName = Asserts.getStringOrThrow(arguments, "decision");
        String targetPlayerName = Asserts.getStringOrThrow(arguments, "request");
        Decision decision = Arrays.stream(Decision.values()).filter(v -> v.name().equalsIgnoreCase(decisionName)).findFirst().orElseThrow(() -> new RuntimeException("No matched Decision for input '%s'".formatted(decisionName)));
        return new C2SExchangeRequestManagementCommand(decision, targetPlayerName);
    }

    @Override
    public Map<String, String> generateArgumentMap() {
        return Map.of("decision", this.decision.name(), "request", this.targetRequestName);
    }

    @Override
    public String getBaseName() {
        return "manage_request";
    }

    @Override
    @Environment(value=EnvironmentType.SERVER)
    public void onCommand(BasicClientHandler<?> listener) {
        listener.onRequestCommand(this);
    }

    public static enum Decision {
        ACCEPT,
        DENY,
        UNKNOWN;

    }
}

