/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.fmccl.converter.C2SCommandConverter;
import xyz.nifeather.fmccl.converter.S2CCommandConverter;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SCommand;
import xyz.nifeather.fmccl.processor.C2SCommandProcessor;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SCommandRecord;
import xyz.nifeather.morph.network.commands.C2S.ClientInitializeRecordV3;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.InitializeRespondV3;
import xyz.nifeather.morph.network.server.MessageChannel;
import xyz.nifeather.morph.network.server.handlers.AbstractCommandPacketHandler;
import xyz.nifeather.morph.network.server.handlers.MorphLegacyCommandConverter;
import xyz.nifeather.morph.network.server.handlers.results.CommandHandleResult;
import xyz.nifeather.morph.network.server.handlers.results.VersionHandleResult;

public class V1ProtocolHandler
extends AbstractCommandPacketHandler {
    public static final V1ProtocolHandler V1_INSTANCE = new V1ProtocolHandler();
    private final C2SCommandProcessor commandProcessor = new C2SCommandProcessor();
    private final S2CCommandConverter s2cConverter = new MorphLegacyCommandConverter();
    private final C2SCommandConverter c2sConverter = new C2SCommandConverter();
    private static final List<String> validChannels = List.of(MessageChannel.initializeChannelV1, MessageChannel.versionChannelV1, MessageChannel.commandChannelV1);

    @Override
    @NotNull
    public List<String> validChannels() {
        return validChannels;
    }

    @Override
    @NotNull
    public ClientInitializeRecordV3 handleInitializeData(Player player, byte @NotNull [] rawData) {
        return new ClientInitializeRecordV3(List.of(), 0, true);
    }

    @Override
    @NotNull
    public VersionHandleResult handleVersionData(Player player, byte @NotNull [] rawData) {
        try {
            String clientVersionStr = new String(rawData, StandardCharsets.UTF_8);
            return VersionHandleResult.from(Integer.parseInt(clientVersionStr));
        }
        catch (Throwable t) {
            this.logger.error("Failed to decode client version from legacy buffer: " + t.getMessage());
            return VersionHandleResult.fail();
        }
    }

    @Override
    @NotNull
    public CommandHandleResult handleCommandData(Player player, byte @NotNull [] rawData) {
        try {
            String str = new String(rawData, StandardCharsets.UTF_8);
            NetheriteC2SCommand<?> command = this.commandProcessor.processLegacyCommandLine(str);
            AbstractC2SCommand<?> convert = this.c2sConverter.fromNetheriteCommand(command);
            return CommandHandleResult.from(C2SCommandRecord.fromC2SCommand(convert));
        }
        catch (Throwable t) {
            this.logger.error("Failed to handle command from player '%s': %s".formatted(player.getName(), t.getMessage()));
            return CommandHandleResult.fail();
        }
    }

    public void sendVersionRespond(Player player, int implementingApi) {
        this.sendInt(player, MessageChannel.versionChannelV1, implementingApi);
    }

    public void sendV1InitializeRespond(Player player) {
        this.sendString(player, MessageChannel.initializeChannelV1, "");
    }

    @Override
    @Deprecated
    public void sendInitializeRespond(Player player, InitializeRespondV3 respond) {
        this.sendInt(player, MessageChannel.versionChannelV1, respond.apiVersion());
    }

    public void sendString(Player player, String channel, String message) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer()).writeBytes(message.getBytes(StandardCharsets.UTF_8));
        this.sendPacketRaw(channel, player, (ByteBuf)buffer);
    }

    @Override
    public void sendCommand(Player player, AbstractS2CCommand<?> command) {
        String commandString;
        try {
            commandString = this.s2cConverter.toNetheriteCommand(command).buildCommand();
        }
        catch (Throwable t) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logger.warn("Can't convert from modern to legacy: " + t.getMessage());
            }
            return;
        }
        this.sendString(player, MessageChannel.commandChannelV1, commandString);
    }
}

