/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.server.handlers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.network.commands.C2S.C2SCommandRecord;
import xyz.nifeather.morph.network.commands.C2S.ClientInitializeRecordV3;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.InitializeRespondV3;
import xyz.nifeather.morph.network.commands.S2C.S2CCommandRecord;
import xyz.nifeather.morph.network.server.MessageChannel;
import xyz.nifeather.morph.network.server.handlers.AbstractCommandPacketHandler;
import xyz.nifeather.morph.network.server.handlers.results.CommandHandleResult;
import xyz.nifeather.morph.network.server.handlers.results.VersionHandleResult;

public class V3ProtocolHandler
extends AbstractCommandPacketHandler {
    public static final V3ProtocolHandler V3_INSTANCE = new V3ProtocolHandler();
    private static final List<String> validChannels = List.of(MessageChannel.initializeChannelV3, MessageChannel.commandChannelV3);
    private final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    @NotNull
    public List<String> validChannels() {
        return validChannels;
    }

    @Override
    @NotNull
    public ClientInitializeRecordV3 handleInitializeData(Player player, byte @NotNull [] rawData) {
        try {
            ClientInitializeRecordV3 deSerialized = (ClientInitializeRecordV3)this.gson.fromJson(this.readStringFromByteInput(rawData), ClientInitializeRecordV3.class);
            return new ClientInitializeRecordV3(deSerialized.clientFeatures(), deSerialized.apiVersion(), true);
        }
        catch (Throwable t) {
            this.logger.error("Failed to decode initialize data from '%s': %s".formatted(player.getName(), t.getMessage()));
            return ClientInitializeRecordV3.fail();
        }
    }

    @Override
    @NotNull
    public VersionHandleResult handleVersionData(@NotNull Player player, byte @NotNull [] data) {
        try {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
            int clientVersion = buf.readInt();
            return VersionHandleResult.from(clientVersion);
        }
        catch (Throwable t) {
            this.logger.warn("Failed to handle version input from '%s', they might using legacy client implementation: %s".formatted(player.getName(), t.getMessage()));
            return VersionHandleResult.fail();
        }
    }

    @Override
    @NotNull
    public CommandHandleResult handleCommandData(@NotNull Player player, byte @NotNull [] data) {
        try {
            String str = this.readStringFromByteInput(data);
            C2SCommandRecord rec = (C2SCommandRecord)this.gson.fromJson(str, C2SCommandRecord.class);
            return CommandHandleResult.from(new C2SCommandRecord(rec.commandName(), rec.arguments()));
        }
        catch (Throwable t) {
            this.logger.error("Failed to handle command from player '%s': %s".formatted(player.getName(), t.getMessage()));
            return CommandHandleResult.fail();
        }
    }

    @Override
    public void sendInitializeRespond(Player player, InitializeRespondV3 respond) {
        this.sendString(player, MessageChannel.initializeChannelV3, this.gson.toJson((Object)respond));
    }

    @Override
    public void sendCommand(Player player, AbstractS2CCommand<?> command) {
        this.sendString(player, MessageChannel.commandChannelV3, this.gson.toJson((Object)S2CCommandRecord.fromS2CCommand(command)));
    }

    protected String readStringFromByteInput(byte[] rawData) throws Throwable {
        String input = null;
        try {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])rawData));
            input = buf.readUtf();
            if (buf.readableBytes() > 0) {
                throw new RuntimeException("Malformed buffer: still has %s readable bytes!".formatted(buf.readableBytes()));
            }
        }
        catch (Throwable t) {
            this.logger.info("Failed to decode byte: %s".formatted(t.getMessage()));
            throw t;
        }
        return input;
    }

    public void sendString(Player player, String channel, String message) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer()).writeUtf(message);
        this.sendPacketRaw(channel, player, (ByteBuf)buffer);
    }
}

